

<!-- Modal start -->
<div class="modal fade" id="exampleModalDayPrevious" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Reopen Day</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="dayprevious" method="post">
                    @csrf
                
                <!-- Field wrapper start -->
                <div class="field-wrapper">
                    <div class="input-group">
                        <input type="date" min="2020-01-01" class="form-control" name="date" value="<?= $dayClose->day_close ?>">
                        <button class="btn btn-light">Submit</button>
                    </div>
                    <div class="field-placeholder">Datepicker</div>
                </div>
                <!-- Field wrapper end -->
                </form>
                <hr>
                <div class="field-wrapper">
                    <a href="{{route('closeday.index')}}">Day Status</a>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->




<script>
    $("#dayprevious").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('day.previous')}}",
                dataType: "json",
                data: $('#dayprevious').serialize(),
                success: function(data){
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 5000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.addEventListener('mouseenter', Swal.stopTimer)
                            toast.addEventListener('mouseleave', Swal.resumeTimer)
                        }
                        })
                        if (data[0] == 0) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Oops...',
                                text: 'Day Alright Closed!',
                                footer: 'SOMETHING HAPPENED'
                                })
                        }else{
                            Toast.fire({
                            icon: 'success',
                            title: 'Day Reopen to ' + data[0]
                            })
                        }
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });
</script>