<!-- Modal start -->
<div class="modal fade" id="expensesType" tabindex="-1" aria-labelledby="exampleModalFullScreenTitle" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalFullScreenTitle">New Expenses Category</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Row start -->
            
            <div class="row gutters">
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

                    <!-- Card start -->
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">New Category</div>
                        </div>
                        <div class="card-body">
                            <form action="{{route('ExpenseType')}}" method="post">
                                @csrf
                            <!-- Row start -->
                            <div class="row gutters">
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                    
                                    <!-- Field wrapper start -->
                                    <div class="field-wrapper">
                                        <div class="input-group">
                                            <input class="form-control" type="text" required name="expense_type_name">
                                            <span class="input-group-text">
                                                <i class="icon-user1"></i>
                                            </span>
                                        </div>
                                        <div class="field-placeholder">Category Nmae <span class="text-danger">*</span></div>
                                    </div>
                                    <!-- Field wrapper end -->

                                </div>
                         
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12" name="expense_type_description">
                                    
                                    <!-- Field wrapper start -->
                                    <div class="field-wrapper">
                                        <textarea class="form-control" rows="2"></textarea>
                                        <div class="field-placeholder">Description</div>
                                    </div>
                                    <!-- Field wrapper end -->

                                </div>
                   
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                            <!-- Row end -->
                            </form>
                        </div>
                    </div>
                    <!-- Card end -->

                </div>
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

                    <!-- Card start -->
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">Expenses Types</div>
                        </div>
                        <div class="card-body">
                            
                        <div class="table-responsive" id="tabler">
                            <table id="basicExample" class="table custom-table">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Description</th>
                                        <th>Action</th>
                                        
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($e_type as $type)
                                    <tr>
                                        <td>{{$type->expense_type_name}}</td>
                                        <td>{{$type->expense_type_description}}</td>
                                        <td>
                                            <div class="actions">
                                                <a href="#" data-toggle="tooltip" id="{{$type->id}}" onclick="DeleteExpenseType(this.id)" data-placement="top" title="" data-original-title="Delete">
                                                    <i class="icon-x-circle text-danger"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        </div>
                    </div>
                    <!-- Card end -->

                </div>
            </div>
            <!-- Row end -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->




<!-- Modal start -->
<div class="modal fade" id="expensesList" tabindex="-1" aria-labelledby="exampleModalFullScreenTitle" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalFullScreenTitle">Expenses List</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table id="copy-print-csv" class="table custom-table">
                        <thead>
                            <tr>
                                <th>Station</th>
                                <th>Paid to</th>
                                <th>Type</th>
                                <th>Reference No#</th>
                                <th>Amount Paid</th>
                                <th>pay Method</th>
                                <th>Date</th>
                                <th>Note</th>
                                <th>Document</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($expenses_list as $list)
                            <tr>
                                <td>{{@strtoupper($list->e_name)}}</td>
                                <td>{{$list->e_paid_to}}</td>
                                <td>{{$list->e_type}}</td>
                                <td>{{$list->e_reference}}</td>
                                <td>@convert($list->e_amount)</td>
                                <td>{{$list->e_payment}}</td>
                                <td>{{$list->e_date}}</td>
                                <td>{{$list->e_note}}</td>
                                <td>{{$list->payment_account}}</td>
                                <td><a href="/uploads/{{$list->e_document}}" class="text-danger">download attachment</a></td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->


<script>
    function DeleteExpenseType(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This will delete the expense type created!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#tabler").load(" #tabler");
                    Swal.fire(
                        'Expense Type!',
                        'This Expense Type is Deleted',
                        'success'
                        )
                }
                xhttp.open("GET", "/dashboard/delete-type/"+id);
                xhttp.send();
            }
            })
    }
</script>