<!-- Modal start -->
<div class="modal fade" id="exampleModalLong" tabindex="-1" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLongTitle">Rejected Items</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
                        @csrf
                        <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-12">
                        @if($voucher_rejected->count() < 1)
                            No rejected stock
                        @else
                            <div class="table-responsive">
                                <table class="table table-bordered" id="reorder">
                                    <thead>
                                        <tr>
                                            <th>Items</th>
                                            <th>Quantity</th>
                                            <th>UOM</th>
                                            <th>Authorize Qty</th>
                                            <th>Issue Qty</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($voucher_rejected  as $req)
                                        <tr>
                                            <td>
                                                <p>{{@ucwords(@strtolower($req->issue_item))}}</p>
                                            </td>
                                            <td>
                                             {{$req->issue_quantity}}
                                            </td>
                                            <td>{{$req->issue_unit}}</td>
                                            <td>
                                                {{$req->authorize_qty}}
                                            </td>
                                            <td>
                                            <input type="text" class="form-control" name="issue_qty]" value="{{$req->issue_quantity}}" readonly>
                                            </td>
                                            
                                            <td>
                                                <form id="rejectedItem">
                                                    @csrf
                                                        <input type="text" class="form-control" name="issue_qty" value="{{$req->issue_quantity}}" hidden readonly>
                                                        <input type="text" class="form-control" name="issue_date" value="{{$req->issue_date}}" hidden>
                                                        <input type="text" class="form-control" name="issue_station" value="{{$req->issue_store}}" hidden>
                                                        <input type="text" class="form-control" name="issue_recieved_station" value="{{$req->station}}" hidden>
                                                        <input type="text" class="form-control" name="issue_item_id" value="{{$req->issue_item_id}}" hidden>
                                                        <input type="text" class="form-control" name="issue_unit" value="{{$req->issue_unit}}" hidden>
                                                        <input type="text" class="form-control" name="issue_item" value="{{$req->issue_item}}" hidden>
                                                        <input type="text" class="form-control" name="issue_rate" value="{{$req->issue_rate}}" hidden>
                                                        <input type="hidden" value="{{$details->issue_transaction_id}}" name="transaction_no">
                                                        <button class="btn btn-primary btn-sm" type="submit"> <i class="icon-check"></i></button>
                                                        
                                                </form>
                                            </td>
                                            
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                
                            </div>
                            @endif
                        </div>
                    </div>
                    <!-- Row end -->

                
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
    </div>
<!-- Modal end -->


<script>
    $("#rejectedItem").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('AcceptRejected')}}",
                dataType: "json",
                data: $('#rejectedItem').serialize(),
                success: function(data){
                    $("#original").load(" #original");
                    $("#reorder").load(" #reorder");
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.addEventListener('mouseenter', Swal.stopTimer)
                            toast.addEventListener('mouseleave', Swal.resumeTimer)
                        }
                        })

                        Toast.fire({
                        icon: 'success',
                        title: 'Restored Successfully'
                        })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });
</script> 