@extends('layouts.app')

@section('content')

<?php $balance = ($payHistory->sum('increase') - $payHistory->sum('decrease')) ?>

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

@if($customer->status == 5)
<!-- Row start -->
<div class="row gutters">

<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
    <!-- Consultants card start -->
    <div class="consulting-card">
        <div class="consulting-card-bg"></div>
        <div class="consulting-card-body">
            <h4>{{@strtoupper($customer->customer->customer_name)}} - {{$invoice_number}}</h4>
            These are transactions related to this customer, <a href="{{route('index.customer', $customer->customer->id)}}" class="text-primary" style="text-decoration:underline"> click here </a> to view all transactions <br>
            {{$customer->customer_address}} <br>
            <a href="{{route('orders.customer', encrypt($customer->customer->id))}}" class="btn btn-info stripes-btn"> <i class="icon-user1" aria-hidden="true"></i> Profile</a>  
            <button class="btn btn-outline-info stripes-btn" data-bs-toggle="modal" data-bs-target="#scheduleModal"> <i class="icon-phone"></i> {{$customer->customer->customer_phone}}</button>     
            <a href="/dashboard/invoice/<?= $invoice_number ?>/<?= $customer_id ?>" class="btn btn-outline-primary btn-sm"> Invoice</a>                                                                         
        </div>
    </div>
    <!-- Consultants card end -->

</div>
@else

<a style="margin-bottom:15px" href="/dashboard/invoice/<?= $invoice_number ?>/<?= $customer_id ?>" class="btn btn-primary btn-sm">Show Invoice</a> 

@endif

    <!-- Row start -->
    <div class="row gutters">
        <div class="container">

            <!-- Card start -->
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                                <th>OrderID.</th>
                                <th>Ordered Date</th>
                                <th>Product</th>
                                <th>Order status</th>
                                <th>Qty</th>												
                                <th> Rate</th>
                                <th>Total</th>
                                @if(auth()->user()->role !== "Sales Person")
                                <th>Action</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($orders as $list)
                            <tr>
                                <td>#{{$list->invoice_number}}</td>
                                <td>{{$list->created_at}}</td>
                                <td>{{$list->invoice_product_name}}</td>
                                <td>
                                    @if($list->invoice_status == 1)
                                    <span class="badge bg-primary">
                                            General Sale</span>
                                    @elseif($list->invoice_status == 2)
                                    <span class="badge bg-success">
                                            No Charge</span>
                                    @elseif($list->invoice_status == 5)
                                    <span class="badge bg-warning">
                                            On Hold</span>
                                    @else
                                    <span class="badge bg-danger">
                                            voided</span>

                                    @endif
                                </td>
                                <td>
                                {{$list->invoice_quantity}}
                                </td>
                                <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                @if(auth()->user()->role !== "Sales Person")
                                <td>
                                    <button onclick="getOrderId(this.id)" id="{{$list->id}}" class="btn btn-poutline-light" data-bs-toggle="modal" data-bs-target="#exampleModalchangestatus">
                                    <i class="icon-edit1"></i>
                                    </button>
                                </td>
                                @endif
                            </tr>
                            @endforeach
                        </tbody> 
                    </table>
                    </div>
                    <!-- Row end -->

                    @if($customer->status == 5)
                    @if(($balance-$discount) > 0)
                    <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#paymentTrans" style="margin-top:14px" class="btn btn-info btn sm">
                         Pay</a>
                         @else
                         <a href="javascript:void(0)" onclick="confirmComplete(this.id)" id="{{$invoice_number}}"  style="margin-top:14px" class="btn btn-success btn sm">
                         Complete Payment</a>
                         @endif

                        <a href="#" class="btn btn-outline-primary btn sm" style="margin-top:14px" data-bs-toggle="modal" data-bs-target="#paymentsNistrot"> 
                        Payment History </a>
                        @endif
                </div>

                
            </div>
            <!-- Card end -->

            

        </div>


        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->




<!-- Modal start -->
<div class="modal fade" id="exampleModalchangestatus" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog ">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">Change Status</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
               <form id="change">
               <input type="text" name="invoice_id" id="id" readonly hidden>
                 <!-- Field wrapper start -->
                @csrf
                <div class="field-wrapper">
                    <div class="input-group">
                        <select name="status" class="select-single js-states">
                            <option value="General">General</option>
                            @if(auth()->user()->role == "Administrator")
                            <option value="Rejected">Rejected</option>
                            @endif
                        </select>
                    </div>
                    <div class="field-placeholder">Status</div>
                </div>
                <!-- Field wrapper end -->

                <div class="field-wrapper">
                    <div class="input-group">
                        <textarea name="comment" cols="30" rows="10" required></textarea>
                    </div>
                    <div class="field-placeholder">Comment</div>
                </div>
                <!-- Field wrapper end -->

                <button class="btn btn-primary btn-sm">Save Changes</button>
               </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->



<?php $pay = DB::table('payment_methods')->pluck('payment_name') ?>


<!-- Modal start -->
<div class="modal fade" id="paymentTrans" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">Confirm Payment</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
               <form action="{{route('ConfirmHeldPay')}}" id="SavePay" method="POST">
                   @csrf
                   <input type="text" required value="{{$invoice_number}}" name="order_id" hidden>
               <input type="text" name="invoice_id" id="id" readonly hidden>
                 <!-- Field wrapper start -->
                @csrf
                <div class="field-wrapper">
                    <div class="input-group">
                        <select name="payment_met" class="select-single js-states">
                            @foreach($pay as $pay)
                                <option value="{{$pay}}">{{$pay}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="field-placeholder">Pay Type<span class="text-danger">*</span></div>
                </div>
                <!-- Field wrapper end -->

                <div class="field-wrapper">
                    <div class="input-group">
                        <input type="text" required name="amount">
                    </div>
                    <div class="field-placeholder">Amount Received <span class="text-danger">*</span></div>
                </div>
                <!-- Field wrapper end -->

                <div class="field-wrapper">
                    <div class="input-group">
                        <textarea name="comment" cols="30" rows="10"></textarea>
                    </div>
                    <div class="field-placeholder">Note</div>
                </div>
                <!-- Field wrapper end -->

                <button class="btn btn-primary" type="button" onclick="SavePay()">Save </button>
               </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->



<!-- Modal start -->
<div class="modal fade" id="paymentsNistrot" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">Payment History - Balance of {{empty($app->currency) ? "GHS" : $app->currency}}@convert($total_Bal = ($balance - $discount)) </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            @if($discount != 0)
            <div class="alert alert-light alert-dismissible fade show" role="alert">
               This's a discounted order. Total cost of order was <strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($orders->sum('invoice_total_price'))</strong>, discount was <strong> {{empty($app->currency) ? "GHS" : $app->currency}}@convert($discount)</strong>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif
            <div class="table-responsive">
            <table id="hideSearchExample" class="table custom-table">
												<thead>
													<tr>
                                                        <th>EnteredBy</th>
														<th>Pay Type</th>
														<th>CreatedAt</th>
														<th>Description</th>
														<th>Increase</th>
														<th>Decrease</th>
													</tr>
												</thead>
												<tbody>
                                                    @foreach($payHistory as $pay)
													<tr>
														<td>{{$pay->user->name}}</td>
														<td>{{$pay->pay_type}}</td>
														<td>{{$pay->created_at}}</td>
														<td>{{$pay->description}}</td>
														<td>
                                                            @if( $pay->description ==  "Initial")
                                                                {{empty($app->currency) ? "GHS" : $app->currency}}@convert($pay->increase - $discount)
                                                            @else
                                                                {{empty($app->currency) ? "GHS" : $app->currency}}@convert($pay->increase)
                                                            @endif
                                                        </td>
														<td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($pay->decrease)</td>
													</tr>
													@endforeach
													
												</tbody>
											</table>
										</div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->





<script>
    function getOrderId(id) {
        document.getElementById('id').value = id
    }


    $("#change").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('changeInvoiceStatus')}}",
                dataType: "json",
                data: $('#change').serialize(),
                success: function(data){
                    var item_id = JSON.parse(data.item_id);
                    var status = JSON.parse(data.status);
                    var invoice_id = JSON.parse(data.invoice_id);
                   
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Status Changed Successfully'
                    })
                
                    
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });



        function SavePay() {
            Swal.fire({
                title: 'Are you sure?',
                text: "Kindly confirm reciept of payment from customer, you may not be able to revert this",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Save!'
                }).then((result) => {
                if (result.isConfirmed) {
                    $('#loading-wrapper').show();
                    document.getElementById("SavePay").submit();
                }
                })
        }


        function confirmComplete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You are completing payment on this order, you may not be able to revert",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Save!'
                }).then((result) => {
                if (result.isConfirmed) {
                    $('#loading-wrapper').show();
                    window.location.href = "/complete/held-transaction/" + id;
                }
                })
        }
</script>


@endsection