@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">
    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">
        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Physical Stock Taking</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
            
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('physicalStockDate')}}" method="get">
       <div class="d-flex justify-content-end">
            <!-- Field wrapper start -->
            <div class="field-wrapper m-0">
                <div class="input-group">
                <!-- <a href="#" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#exampleModalexampleModal">Import Stock</a> -->
                <!-- <a style="margin-right:12px" href="{{route('openingStock')}}" class="btn btn-outline-primary">Adjust Opening Stock</a> -->
               
                </div>
            </div>
            <!-- Field wrapper end -->

        
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <input type="date" class="form-control"  name="date" value="{{request('date')}}" max="{{$dayClose->day_close}}">
                        
                        <button class="btn btn-info"><i class="icon-eye1"></i> view</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
                
            </div>
            
        </div>
       </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-12">
                <!-- Card start -->
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">Stock Taking</div>
                    </div>
                    
                    <div style="margin-left:20px; margin-top:12px">
                        Stock Taking Date: <em>{{request()->date == null ? $dayClose->day_close : request()->date }}</em>, Station: <?=auth()->user()->station?>
                    </div>
                    
                    <div class="card-body">
                    <form action="{{route('save.physical')}}" id="stocktaking" method="POST">

                    <input type="text" name="date" value="{{request('date')}}" hidden>

                        @csrf
                        <div class="table-responsive">
                    <table id="basicExample" class="table custom-table">
                                <thead>
                                    <tr>
                                    <th>Items</th>
                                    <th>Category</th>
                                    <th>Unit</th>
                                    <th>Closing Stock</th>
                                    <th>Physical Stock</th>
                                    <th>Remark</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                    
                                    @foreach($record_physical->chunk(50) as $row)
                                    @foreach($row as $report)

                                    @if(in_array(auth()->user()->station, json_decode($report->inactive_station)) == true)
                                        @continue
                                    @endif
                                    <tr>
                                        <td>{{@ucwords(@strtolower($report->item_name))}}</td>
                                        <td>{{@ucwords(@strtolower($report->item_category))}}</td>
                                        <td>{{$report->item_unit}}</td>
                                        <td>@convert(round($report->opening_stock, 2) + round($report->stock_in, 2) - round($report->stock_out, 2))</td>
                                        <td>
                                            <input type="number" min="0" step="0.0001" min="0" class="form-control" placeholder="Kindly Enter Physical Stock" name="items[<?=$report->id;?>][issue_item_physical_stock]" value="{{$report->physical_stock}}">
                                            <input type="text" class="form-control" name="items[<?=$report->id;?>][issue_item_id]" value="{{$report->item_id}}" hidden>
                                        </td>
                                        
                                        <td><textarea name="items[<?=$report->id;?>][comment]" class="form-control" id="" cols="30" rows="2"></textarea></td>
                                    </tr>
                                    @endforeach
                                    @endforeach
                                </tbody>
                        </table>
                        </div>
                        <div style="margin-top:12px">
                            <button class="btn btn-primary" type="button" onclick="physical()">Save</button>
                        </div>
                        </form>
                    </div>
                </div>
                <!-- Card end -->
            </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Content wrapper end -->


<!-- Modal start -->
    <div class="modal fade" id="exampleModalexampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Import Stock</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{route('importOpeningStock')}}" method="post" enctype="multipart/form-data">
                    @csrf
                <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <div class="input-group">														
                            <input type="date" class="form-control" name="date" value="{{$dayClose->day_close}}">
                        </div>
                    </div>
                    <!-- Field wrapper end -->
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <div class="input-group">														
                            <input type="file" class="form-control" name="file">
                            <button class="btn btn-outline-primary" type="submit" id="inputGroupFile02">Upload</button>
                        </div>
                    </div>
                    <!-- Field wrapper end -->
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
            </div>
        </div>
    </div>
    <!-- Modal end -->



    <script>
        function physical() {
            Swal.fire({
                title: 'Are you sure?',
                text: "you are submitting your physical stock as at now. it will be matched against your computer stock",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Save!'
                }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("stocktaking").submit();
                }
                })
        }
    </script> 
@endsection