<!DOCTYPE html>
<html lang="en">

<head>
    	<!-- Sweet Alert-->
    <link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'PT Sans', sans-serif;
        }

        @page {
            size: 2.8in 11in;
            margin-top: 0cm;
            margin-left: 0cm;
            margin-right: 0cm;
        }

        table {
            width: 100%;
        }

        tr {
            width: 100%;

        }

        h1 {
            text-align: center;
            vertical-align: middle;
        }

        #logo {
            width: 60%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            padding: 5px;
            margin: 2px;
            display: block;
            margin: 0 auto;
        }

        header {
            width: 100%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            vertical-align: middle;
        }

        .items thead {
            text-align: center;
        }

        .center-align {
            text-align: center;
        }

        .bill-details td {
            font-size: 12px;
        }

        .receipt {
            font-size: medium;
        }

        .items .heading {
            font-size: 12.5px;
            text-transform: uppercase;
            border-top:1px solid black;
            margin-bottom: 4px;
            border-bottom: 1px solid black;
            vertical-align: middle;
        }

        .items thead tr th:first-child,
        .items tbody tr td:first-child {
            width: 47%;
            min-width: 47%;
            max-width: 47%;
            word-break: break-all;
            text-align: left;
        }

        .items td {
            font-size: 12px;
            text-align: right;
            vertical-align: bottom;
        }

        .price::before {
            font-family: Arial;
            text-align: right;
        }

        .sum-up {
            text-align: right !important;
        }
        .total {
            font-size: 13px;
            border-top:1px dashed black !important;
            border-bottom:1px dashed black !important;
        }
        .total.text, .total.price {
            text-align: right;
        }
        
        .line {
            border-top:1px solid black !important;
        }
        .heading.rate {
            width: 20%;
        }
        .heading.amount {
            width: 25%;
        }
        .heading.qty {
            width: 5%
        }
        p {
            padding: 1px;
            margin: 0;
        }
        section {
            font-size: 12px;
        }
        
        .footer {
              position: fixed;
              left: 0;
              bottom: 0;
              width: 100%;
              background-color: #073a82;
              color: white;
              text-align: center;
              padding:10px
            }
            
            @media print {
              body * {
                visibility: hidden;
              }
              #section-to-print, #section-to-print * {
                visibility: visible;
              }
              #section-to-print {
                position: absolute;
                left: 0;
                top: 0;
              }
            }
            
            
            .button {
                  border: none;
                  color: white;
                  padding: 15px 32px;
                  text-align: center;
                  text-decoration: none;
                  display: inline-block;
                  font-size: 16px;
                  margin: 4px 2px;
                  cursor: pointer;
                }
                
                .button1 {background-color: #4CAF50;} /* Green */
                .button2 {background-color: #008CBA;} /* Blue */
    </style>
</head>

<body onLoad="window.print();">
    
    <main id="section-to-print">
    <header>
        <div>
            <h3><strong>{{$app->app_name}}</strong></h3>
            @if($amount_paid->status == 5)
            <h5>Held Receipt</h5>
            @endif
            <div style="font-size:15px">
                <strong><?= $branch_details -> branch_name ?></strong><br>
                <?= $branch_details -> branch_location ?></br>
                Phone   : <?= $branch_details -> branch_contact ?></br>
                <small>{{$app->app_website}}</small> <small>{{$app->app_email}}</small></br>
            </div>
        </div>

    </header>
    <p style="font-size:12px; margin-top:5px">Receipt No. : {{$number}}</p>
    <table class="bill-details">
        <tbody>
            <tr>
                <td>Date : <span><?= $time ?></span></td>
                <td>Cashier : 
                    <span>
                            <?php 
                                $f_name = explode(" ", $sales_person_name);
                                echo @strtoupper($f_name[0]);
                              ?>
                      </span>
                </td>
            </tr>
            <tr>
                <td>TIN #: <span><?= $branch_details -> tin_number ?></span></td>
                <td>{{ empty($agency_->agency) ?  "" : "Paid By: " . $agency_->agency}}</td>
            </tr>
            <tr>
                <th class="center-align" colspan="2"><span class="receipt">Original Receipt</span></th>
            </tr>
        </tbody>
    </table>
    
    <table class="items">
        <thead>
            <tr>
                <th class="heading name">Item</th>
                <th class="heading qty">Qty</th>
                <th class="heading rate">Rate</th>
                <th class="heading amount">Total</th>
            </tr>
        </thead>
       
        <tbody>
            <?php $sumTotal = 0 ?>
            @foreach($invoice_generate as $invoice)
            <?php $sumTotal += $invoice->invoice_quantity * $invoice->invoice_unit_price ?>

            <tr>
                <td>{!!ucwords(@strtolower($invoice->invoice_product_name))!!}</td>
                <td>{{$invoice->invoice_quantity}}</td>
                <td class="price">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($invoice->invoice_unit_price)</td>
                <td class="price">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($invoice->invoice_quantity * $invoice->invoice_unit_price)</td>
            </tr>
            @endforeach
            <tr>
                @if($discount == null)
                <td colspan="3" class="sum-up line">Discount</td>
                <td class="line price">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(0)</td>
                @else
                <?php 
                if ($discount->type == "Cash") {
                  echo '<td colspan="3" class="sum-up line">' . "Discount" . '</td>';
                  echo '<td class="line price">' . $discount->discount . '</td>';
                }elseif ($discount->type == "Percentage") {
                  echo '<td colspan="3" class="sum-up line">' . "Discount" . '</td>';
                  echo '<td class="line price">' . (($discount->discount/$sumTotal)*100) . "%". '</td>';
                }
                ?>
              @endif
            </tr>
            <tr>
                @if($discount != null)
                <td colspan="3" class="sum-up">Sub Total</td>
                <td class="price">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($discount->amount_paid)</td>
                @endif
            </tr>
            <tr>
                <td colspan="3" class="sum-up">Tax</td>
                <td class="price">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(0)</td>
                
            </tr>
            
            <tr>
                <th colspan="3" class="total text">Total</th>
                @if($discount == null)
                <th class="total price">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($total)</th>
                @else
                <th class="total price">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($discount->amount_paid)</th>
                @endif
            </tr>
            <tr>
                <th colspan="3" class="total text">Amount Paid</th>
                <th class="total price">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($amount_paid->amount_paid)</th>
            </tr>
            <tr>
                <th colspan="3" class="total text">Balance Due</th>
                @if($discount == null)
                <th class="total price">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($total - $amount_paid->amount_paid)</th>
                @else
                <th class="total price">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($discount->amount_paid - $amount_paid->amount_paid)</th>
                @endif
            </tr>
             @if($customer -> customer_name !== "WALK-IN CUSTOMER")
            <tr>
                <td></td>
                <td></td>
              </tr>
              <tr>
                <td colspan="3">Customer Name:</td>
                <td class="price">{{$customer -> customer_name}}</td>
              </tr>
              <tr>
                <td colspan="3">Address:</td>
                <td class="price">{{$customer -> customer_address}}</td>
              </tr>
              <tr>
                <td colspan="3">PhoneNo:</td>
                <td class="price"><strong>{{$customer -> customer_phone}}</strong></td>
              </tr>
              <tr>
                <td colspan="3">Note</td>
                <td class="price">{{$customer -> customer_note}}</td>
              </tr>
              @endif
    </table>
        </tbody>
    </table>
    <section>
        <p style="text-align:center">
            {!!$app->app_receipt_footer!!}
        </p>
        <p style="text-align:center">Powered by Andas Solutions Ltd. <br>0542401240</p>
    </section>
    </main>
    
    <div class="footer">
      <p>
      <button onclick="display()" class="button button1"> Print </button>
      
         <button type="button" class="button button2" onclick="newInvoice()">New Sale</button>
       </p>
    </div>
</body>


<script>

         function display() {
          window.print();
         }


         function newInvoice() {
          Swal.fire({
              title: 'Are you sure?',
              text: "You want to create new sale!",
              icon: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#3085d6',
              cancelButtonColor: '#d33',
              confirmButtonText: 'Yes, new sale!'
            }).then((result) => {
              if (result.isConfirmed) {
                window.location.href = "/";
              }
            })
         }
         
          function callInvoice() {
          Swal.fire({
              title: 'Are you sure?',
              text: "You want to create new sale!",
              icon: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#3085d6',
              cancelButtonColor: '#d33',
              confirmButtonText: 'Yes, new sale!'
            }).then((result) => {
              if (result.isConfirmed) {
                window.location.href = "/";
              }
            })
         }


         function getValueTWO() {
            var e = document.getElementById("sale_type22");
            if (e.value === "CREDIT NOTE") {
                $('#submitTicketModal').modal('show');

                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                   
                }
                xhttp.open("GET", "/ceqa-dashboard/sale-type/cash-sales");
                xhttp.send();
            }else{
                console.log("error")
            }
        }
  </script>
  
    <!-- Sweet Alerts js -->
    <script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>

</html>
