@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">


<!-- Breadcrumb container start -->
<div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
              <li class="breadcrumb-item active" aria-current="page">Purchase</li>
            </ol>
        </nav>
    </div>


    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">   
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('PurchaseListDateType')}}" method="get">
            <input type="text" name="purchase_type" hidden value="{{request('purchase_type')}}">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <div style="margin-right:10px"><small>From</small></div>
                    <input type="date" class="form-control" name="start_date" max="{{$dayClose->day_close}}">
                    <div style="margin-right:10px; margin-left:10px"><small>to</small></div>
                    <input type="date" class="form-control" name="end_date" max="{{$dayClose->day_close}}">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
                
            </div>
        </form>
        </div>
   
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->




    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12">
            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">{{request('purchase_type')}} -  [Summary]</div>
                    
                    <form action="{{route('PrintPurchasesType')}}" method="GET">
                    <input type="text" name="purchase_type" hidden value="{{request('purchase_type')}}">
                    <input type="date" class="form-control" value="{{request('start_date')}}" hidden name="start_date">
                    <input type="date" class="form-control" value="{{request('end_date')}}" hidden name="end_date">
                            <button class="btn btn-outline-primary"> <i class="icon-print"></i> Print</button>
                    </form>
                    
                </div>
                
                <div style="margin-left:20px;">
                    Report for: <em>{{request()->start_date == null ?  $dayClose->day_close : request()->start_date . " / " .  request()->end_date}}</em>
                </div>
                
                <div class="card-body">
                <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                            <th>Due Date</th>	
                              <th>Added by</th>
                              <th>Status</th>
                              <th>Date</th>													  
                              <th>Vendor</th>													  
                              <th>Amount</th>
                              @if(request('purchase_type') == "Purchase Invoice")
                              <th>Amount paid</th>
                              <th>Bill Balance</th>
                              @endif
                              <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($lists as $list)
                            <tr>
                                <td>{{$list ->purchase_due_date}}
                                    <p>{{$list->purchases_transaction_id}}</p>
                                </td>
                              <td>
                                  <?php $user_ =\DB::table('users')->where('id', $list->user_id)->first() ?>
                                  {{$user_->name}}
                              </td>
                              <td>
                              <span class="badge bg-primary">Recieved</sapn>
                              </td>
                              <td>
                              {{$list->date}}
                              </td>													  
                              <td>{{$list->vendor_name}}</td>
                              <td>{{empty($app->currency) ? GHS : $app->currency}}@convert($list->purchase_amount)</td>
                              @if(request('purchase_type') == "Purchase Invoice")
                              <td>{{empty($app->currency) ? GHS : $app->currency}}@convert($list->purchase_amount_paid)</td>
                              <td>
                                  {{empty($app->currency) ? GHS : $app->currency}}@convert($list->purchase_amount_balance)
                              </td>
                              @endif
                              <td>
                              <div class="actions">
                                      <a href="{{route('purchase.show',$list->purchases_transaction_id)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                          <i class="icon-edit1 text-info"></i>
                                      </a>
                                  </div>
                              </td>
                            </tr>
                            @endforeach
                        </tbody>
                </table>
                    </div>
                </div>
            </div>
            <!-- Card end -->
        </div>
    </div>
    <!-- Row end -->
                          

</div>
<!-- Content wrapper end -->



@endsection