@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">


<!-- Breadcrumb container start -->
<div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
              <li class="breadcrumb-item active" aria-current="page">Purchase</li>
            </ol>
        </nav>
    </div>
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <div class="d-flex justify-content-end">
            <form action="{{route('PurchaseListDate')}}" method="GET">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <select class="select-single js-states" title="Select Term" data-live-search="true" name="vendor">
                        <option value="{{request()->vendor == null  ? "- All Vendors -" : request()->vendor}}">{{request()->vendor == null ? "- All Vendors -" : request()->vendor}}</option>
                        @foreach($vendors as $vendor)
                        <option>{{$vendor->vendor_name}}</option>
                        @endforeach
                    </select>
                        <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                            <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info">Report</button>
                    </div>
                </div>
                <!-- End field Wrapper -->
            </form>
        </div>
    </div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->


<!-- Row start -->
<div class="row gutters">

    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <div class="card">
                                            
        <div class="card-title">
        </div>
                
                <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                            <th>Due Date</th>	
                              <th>Added by</th>
                              <th>Status</th>
                              <th>Date</th>													  
                              <th>Vendor</th>													  
                              <th>Bill Amount</th>
                              <th>Amount paid</th>
                              <th>Bill Balance</th>
                              <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($lists as $list)
                            <tr>
                                <td>{{$list ->purchase_due_date}}
                                    <p>{{$list->purchases_transaction_id}}</p>
                                </td>
                              <td>
                                  <?php $user_ =\DB::table('users')->where('id', $list->user_id)->first() ?>
                                  {{$user_->name}}
                              </td>
                              <td>
                              <span class="badge bg-primary">Recieved</sapn>
                              </td>
                              <td>
                              {{$list->date}}
                              </td>													  
                              <td>{{$list->vendor_name}}</td>
                              <td>{{empty($app->currency) ? GHS : $app->currency}}@convert($list->purchase_amount)</td>
                              <td>{{empty($app->currency) ? GHS : $app->currency}}@convert($list->purchase_amount_paid)</td>
                              <td>
                                  {{empty($app->currency) ? GHS : $app->currency}}@convert($list->purchase_amount_balance)
                              </td>
                              <td>
                              <div class="actions">
                                      <a href="{{route('purchase.show',$list->purchases_transaction_id)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                          <i class="icon-edit1 text-info"></i>
                                      </a>
                                  </div>
                              </td>
                            </tr>
                            @endforeach
                        </tbody>
                </table>
                </div>

            </div>
        </div>

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection