@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-header-lg">
                <h4>New {{request('type')}}</h4>
                <div class="text-end">
                    <a href="{{route('showAll.purchase')}}" class="btn btn-outline-primary">Purchase</a>
                </div>
            </div>
            <div class="card-body">
                Purchase details appears in your purchase. Purchase date is used in the dashboard and reports. select the date you expect to pay as the <strong>Due Date</strong>
            <form id="purchase">
                @csrf

                @if($check_purchase == null)
                <input type="text" name="purchase_transaction_id" id="trans" hidden value="<?=  rand(5034,10034580)+rand(4580,10034580) . date("Yd") . date('Hi');?>">
                @else
                <input type="text" name="purchase_transaction_id" id="trans" hidden value="{{$check_purchase -> purchase_transaction_id}}">
                @endif
                <!-- Row start -->
                <div class="row justify-content-between">

                    <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">

                        <!-- Row start -->
                        <div class="row gutters">

                            <div class="col-12">
                                <div class="form-section-header light-bg">Purchase Information</div>
                            </div>
                            <div class="col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                @if($check_purchase == null)
                                <select class="select-single js-states" title="Select Term" data-live-search="true" name="purchase_vendor">
                                    <option disabled selected> - Select Vendor -</option>
                                    @foreach($vendors as $vendor)
                                    <option value="{{$vendor->vendor_name}}">{{@ucwords(@strtolower($vendor->vendor_name))}}</option>
                                    @endforeach
                                </select>
                                @else
                                <select class="select-single js-states" title="Select Term" data-live-search="true" name="purchase_vendor">
                                        <option value="{{$check_purchase->purchase_vendor}}" selected>{{@ucwords(@strtolower($check_purchase->purchase_vendor))}}</option>
                                </select>
                                @endif
                                    <div class="field-placeholder">Vendor<span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>
                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                 <!-- Field wrapper start -->
                                 <div class="field-wrapper">
                                    <div class="input-group">
                                        <input type="date" class="form-control" name="purchase_date" value="<?= $dayClose->day_close ?>">
                                    </div>
                                    <div class="field-placeholder">Purchase Date</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>

                            <!-- <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                 
                                 <div class="field-wrapper">
                                    <div class="input-group">
                                        <input type="date" class="form-control" name="purchase_expiry" value="">
                                    </div>
                                    <div class="field-placeholder">Expiry Date</div>
                                </div>
                                
                            </div> -->

                        </div>
                        <!-- Row end -->

                    </div>
                    
                    <div class="col-xl-5 col-lg-5 col-md-7 col-sm-7 col-12">
                     
                        <!-- Row start -->
                        <div class="row gutters">

                        <div class="col-12">
                                <div class="form-section-header light-bg">Other Information</div>
                            </div>

                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <select class="select-single js-states" required name="purchase_item" title="Select Term" data-live-search="true">
                                    <option disabled selected> - Select Item -</option>
                                        @foreach($items as $item)
                                        <option value="{{$item -> item_name}} - {{$item -> id}}">{{@ucwords(@strtolower($item -> item_name))}}</option>
                                        @endforeach
                                    </select>
                                    <div class="field-placeholder">Item</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>
                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">
                                        <input type="number" name="purchase_quantity" class="form-control" step="0.001">
                                    </div>
                                    <div class="field-placeholder">Quantity</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>


                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">
                                        <input type="number" name="purchase_rate" step="0.01" class="form-control">
                                    </div>
                                    <div class="field-placeholder">Rate</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>

                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper" id="unit-re">
                                    <select id="unit-listing" name="purchase_unit" class="select-single js-states" title="Select Term" data-live-search="true">
                                    <option disabled selected> - Select Unit -</option>
                                    @foreach($units as $unit)
                                    <option value="{{$unit -> abbreviation}}">{{@ucwords(@strtolower($unit -> abbreviation))}}</option>
                                    @endforeach
                                    </select>
                                    <div class="field-placeholder">UOM</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>


                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                <button class="btn btn-outline-primary"><i class="icon-shopping-cart1" aria-hidden="true"></i> Add to Cart</button> 
                                </div>
                                <!-- Field wrapper end -->
                            </div>

                        </div>
                        <!-- Row end -->

                    </div>

                </div>
                <!-- Row end -->
            </form>

                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-12">
                        <div class="table-responsive">
                            <table class="table table-bordered" id="tabler">
                                <thead>
                                    <tr>
                                        <th colspan="7" class="pt-3 pb-3">Item Details</th>
                                    </tr>
                                    <tr>
                                        <th>Sr#</th>
                                        <th>Item</th>
                                        <th>Rate <br><strong>{{empty($app->currency) ? GHS : $app->currency}}</strong></th>
                                        <th>Quantity</th>
                                        <th>Total <br><strong>{{empty($app->currency) ? GHS : $app->currency}}</strong></th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach($purchases as $receipt)
                                    <tr>
                                        <td>{{$loop->iteration}}</td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <select class="select-single js-states w-100" data-live-search="true">
                                                    <option>{{@ucwords(@strtolower($receipt->purchase_item))}}</option>
                                                </select>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" class="form-control" value="@convert($receipt->purchase_rate)" placeholder="Rate" readonly>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="tex" class="form-control" value="{{$receipt->purchase_quantity}} {{$receipt->purchase_unit}}" placeholder="Qty" readonly>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" class="form-control" value="@convert($receipt->purchase_total)" readonly>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                       
                                        <td>
                                            <div class="table-actions">
                                                <button class="btn btn-outline-light" type="button" id="{{$receipt->id}}" onclick="deleteDock(this.id)">
                                                    <i class="icon-trash-2"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                    <tr>
                                    <td colspan="4">&nbsp;</td>
                                    <td>
                                        <p class="m-0">Subtotal</p>
                                        <p class="m-0">Discount</p>
                                        <p class="m-0">Total</p>
                                    </td>
                                    <td>
                                        <p class="m-0">@convert($purchases->sum('purchase_total'))</p>
                                        <p class="m-0">@convert(0)</p>
                                        <p class="mt-2 text-danger">@convert($purchases->sum('purchase_total'))</p>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>

                        <div class="field-wrapper">
                            <textarea class="form-control" rows="3" onchange="editNote()" id="noteText" placeholder="Memo"></textarea>
                            <div class="field-placeholder">Note</div>
                        </div>

                    </div>
                </div>
                <!-- Row end -->

                <!-- Row start -->
                <div class="row gutters">

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="form-actions-footer">
                            <div class="text-end">
                                <button class="btn btn-light" onclick="saveOnlyAndPrint()" data-bs-toggle="modal" data-bs-target="#payment">Save & Print</button>
                                <button class="btn btn-primary ms-1" onclick="saveOnly()" data-bs-toggle="modal" data-bs-target="#payment">Save</button>
                                <button class="btn btn-danger ms-1" onClick="confirmClose()">Close</button>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- Row end -->

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->



<!-- Modal start -->
<div class="modal fade" id="payment" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="staticBackdropLabel">Purchase</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
        <form action="{{route('savePurchasePrint')}}" id="savePurchase" method="post">

        <input type="text" id="savetype" name="save" hidden>

        <input type="text" value="{{request('type')}}" name="purchase_type" hidden>

            @csrf            

                <!-- Row start -->
                <div class="row gutters">
                @if(request('type') == "Purchase Invoice")
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <select class="select-single js-states" name="payment_mode" title="Select Product Category" data-live-search="true">
                        @foreach(\DB::table('payment_methods')->get() as $payments)
                            <option>{{$payments->payment_name}}</option>
                            @endforeach
                        </select>
                        <div class="field-placeholder">Payment mode<span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->
                    </div>
                    
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
                    <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <select class="select-single js-states" title="Select Product Category" name="payment_account" data-live-search="true">
                            @foreach($payment_accounts as $payment_accounts)
                                <option value="{{$payment_accounts -> account_number}}">{{@ucwords(@strtolower($payment_accounts->account_name))}} ~ {{@ucwords(@strtolower($payment_accounts->account_type))}}</option>
                            @endforeach
                            </select>
                            <div class="field-placeholder">Account</div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>


                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <input type="number" step="0.01" min="0" value="0" name="amount_paid" required>
                            </div>
                            <div class="field-placeholder">Amount<span class="text-danger">*</span></div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>


                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <input type="date" name="due_date" required>
                            </div>
                            <div class="field-placeholder">Due Date<span class="text-danger">*</span></div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <input type="text" name="transaction_id">
                            </div>
                            <div class="field-placeholder">Trans. Ref</div>
                            <small class="text-mute" >Enter transaction ID, cheque number, transfer ID or any ID related to payment</small>
                        </div>
                        <!-- Field wrapper end -->

                    </div>

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <textarea name="payment_note"></textarea>
                            </div>
                            <div class="field-placeholder">Payment Note <span class="text-danger"></span></div>
                            
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                    @else

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12>">
                        <div class="field-wrapper">
                            {{request('type')}} does not have any financial implications. It can be converted to Purchase Invoice
                            </div>
                        </div>
                    @endif

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <button class="btn btn-outline-primary"  type="button" onclick="confirmPurchase()">Save</button>
                    </div>
                </div>
                <!-- Row end -->
            </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary"  id="closebtn" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->


<script>
    
    function getUnit(){
        $("#unit-re").load(" #unit-re");
        var e = document.getElementById("ddlViewBy");
        var strUser = e.value;
        var split_arrary = strUser.split(" - ")

        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                var res = JSON.parse(this.responseText)
                var sel = document.getElementById('unit-listing');

                for(var i = 0; i < res.length; i++) {
                    var opt = document.createElement('option');
                    opt.innerHTML = res[i];
                    opt.value = res[i];
                    sel.appendChild(opt);
                }
            }
            xhttp.open("GET", "/dashboard/get-unit/"+split_arrary[1]);
            xhttp.send();
    }



    function deleteDock(id) {
        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $("#tabler").load(" #tabler");
            }
            xhttp.open("GET", "/dashboard/purchase-dock/remove/"+id);
            xhttp.send();
    }

    function editNote() {
            var note = document.getElementById('noteText').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/dashboard/customer-note/" + note);
            xhttp.send();
        }


    $("#purchase").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('purchase.store')}}",
                dataType: "json",
                data: $('#purchase').serialize(),
                success: function(data){
                    $("#tabler").load(" #tabler");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Added to Cart, add new Item'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });


    function confirmReceipt() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('savePurchase')}}";
            }
            })
    }


    function confirmPurchase() {
            var closeClick = document.getElementById('closebtn');
            closeClick.click();
            Swal.fire({
                title: 'Purchases, Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, make purchases!'
                }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("savePurchase").submit();
                }
                })
        }


    function saveOnlyAndPrint(){
       document.getElementById('savetype').value = 1
    }
    function saveOnly(){
       document.getElementById('savetype').value = 0
    }


    function confirmClose() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Clear Current Transaction!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('clearPurchase')}}";
            }
            })
    }

    </script>

@endsection