<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>Revenue Summary - {{request()->date == null ? $dayClose->day_close : request()->date}}</title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">

        <!-- fontAwesome -->
        <link href="{{asset('assets/fontawesome/css/all.css')}}" rel="stylesheet">

	</head>

    <style>
         @media print {
                #back{
                    visibility: hidden;
                }
            }
    </style>

<body onload="window.print();">

<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
            <a href="#" onclick="window.history.go(-1); return false" id="back" style="text-decoration:underline"><span class="badge bg-info">Return Back</span></a><br>
                <a href="#" class="logo">
                    <img src="/assets/img/{{$app->app_logo}}" alt="logo" style="max-width:70px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: {{auth()->user()->name}} <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0" style="width:70%">
                    <strong>{{$app->app_name}}</strong>,<br>
                    REVENUE SUMMARY FOR -  [{{request()->branch}}]<br>
                </address>

                <div class="invoice-num">
                    <div>Report Date</div>
                    <div> {{request()->date == null ? $dayClose->day_close : request()->date}}</div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->

    <?php session()->put('sales_summary_date', request()->date) ?>


	<table class="table table-bordered table-striped m-0">
        <thead>
        <tr>
            <th>Outlets</th>
            <th>Sales</th>
            <th>Discounts</th>
            <th>Total</th>
        </tr>
        </thead>
        <tbody>
        <?php 
                    if(request()->branch == "ALL BRANCHES"){
                    $discount_all = \DB::table('discounts')
                     ->where('is_held', 0)
                     ->WhereDate('created_at','>=', $from)
                     ->WhereDate('created_at','<=', $to)
                     ->sum('amount_deducted');
                     }else{
              
                     $discount_all = \DB::table('discounts')
                     ->where('branch', request()->branch)
                     ->where('is_held', 0)
                     ->WhereDate('created_at','>=', $from)
                     ->WhereDate('created_at','<=', $to)
                     ->sum('amount_deducted');
                     
                     }

                 ?>
            @foreach($summary as $report)
            <tr>
                <td>{{$report->branch}}</td>
                <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($report->total)</td>
                <td>
                    <?php 

                       $discount = \DB::table('discounts')->where('branch', $report->branch)
                       ->where('is_held', 0)
                        ->WhereDate('created_at','>=', $from)
                        ->WhereDate('created_at','<=', $to)
                        ->sum('amount_deducted');

                    ?>
                    {{empty($app->currency) ? "GHS" : $app->currency}}@convert($discount)</td>
                <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($report->total - $discount)</td>
            </tr>
            @endforeach
            <td><strong>TOTAL</strong></td>
            <td><strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($total)</strong></td>
            <td><strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($discount_all)</strong></td>
            <td><strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($total - $discount_all)</strong></td>
        </tbody>
	</table>

</div>

   
</div>


</div>

   @if(auth()->user()->role == "Administrator")
   <div style="padding:15px">
            <a href="{{route('SalesReportSummary')}}" class="text-info" style="text-decoration:underline">Detailed Summary</a>
    </div>
    @endif



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('assets/js/jquery.min.js')}}"></script>
		<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('assets/js/modernizr.js')}}"></script>
		<script src="{{asset('assets/js/moment.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('assets/js/main.js')}}"></script>

	</body>

</html>
