<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>Detailed Sales Summary - {{request()->date == null ? $from : request()->date}}</title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">

        <!-- fontAwesome -->
        <link href="{{asset('assets/fontawesome/css/all.css')}}" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


        <script src="{{asset('assets/js/ajax.min.js')}}"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">


		
	</head>

<body>

<div class="card-body">
<div class="invoice-container">
 

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0" style="width:70%">
                    <strong>{{$app->app_name}}</strong>,<br>
                    Detailed Sales Summary -  All Outlets<br>
                </address>

                <div class="invoice-num">
                    <div>Report Date</div>
                    <div> {{$from}} / {{$to}}</div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->


    @if($from ==  $to)
	<table class="table table-bordered table-striped m-0">
        <thead>
        <tr>
            <th>Outlets</th>
            <th>Date</th>
            <th>Account number</th>
            <th>Total sale</th>
            <th>Discount</th>
            <th>Receipt count</th>
            <th>Rejected</th>
            <th>No Charge</th>
        </tr>
        </thead>
        <tbody>
            @foreach($branches_sales as $report)
            <tr>
                <td><span class="text-info">{{$report->branch_name}}</span></td>
                <td>{{$from}}</td>
                <td>{{$report->branch_account_number}}</td>
                <td>
                {{empty($app->currency) ? "GHS" : $app->currency}}@convert(
                        \DB::table('invoices')
                        ->whereDate('created_at',  $from)
                        ->where('invoice_status',  1)
                        ->where('branch', $report->branch_name)
                        ->sum('invoice_total_price')
                    )
                </td>
                <td>
                {{empty($app->currency) ? "GHS" : $app->currency}}@convert(
                    \DB::table('orders')->where('branch', $report->branch_name)
                    ->whereDate('created_at',  $from)
                    ->sum('discount')
                    )
                </td>
                <td>
                    @convert(
                        \DB::table('orders')
                        ->whereDate('created_at',  $from)
                        ->where('branch', $report->branch_name)
                        ->count()
                    )
                </td>
                <td>
                {{empty($app->currency) ? "GHS" : $app->currency}}@convert(
                        \DB::table('invoices')
                        ->whereDate('created_at',  $from)
                        ->where('invoice_status',  0)
                        ->where('branch', $report->branch_name)
                        ->sum('invoice_total_price')
                    )
                </td>
                <td>
                {{empty($app->currency) ? "GHS" : $app->currency}}@convert(
                        \DB::table('invoices')
                        ->whereDate('created_at',  $from)
                        ->where('invoice_status',  2)
                        ->where('branch', $report->branch_name)
                        ->sum('invoice_total_price')
                    )
                </td>
            </tr>
            @endforeach

            <tfoot>
                <tr>
                    <td><strong>Grand Total</strong></td>
                    <td></td>
                    <td></td>
                    <td>
                    <strong>
                    {{empty($app->currency) ? "GHS" : $app->currency}}@convert(
                        \DB::table('invoices')
                        ->whereDate('created_at',  $from)
                        ->where('invoice_status',  1)
                        ->whereIn('branch', $branches_sales->pluck('branch_name'))
                        ->sum('invoice_total_price')
                    )
                    </strong>
                    </td>
                    <td>
                        <strong>
                        {{empty($app->currency) ? "GHS" : $app->currency}}@convert(
                        \DB::table('orders')
                            ->whereDate('created_at',  $from)
                            ->sum('discount')
                        )
                        </strong>
                    </td>
                    <td>
                        <strong>
                        @convert(
                        \DB::table('orders')
                            ->whereDate('created_at',  $from)
                            ->count()
                        )
                        </strong>
                    </td>
                    <td>
                        <strong>
                        {{empty($app->currency) ? "GHS" : $app->currency}} @convert(
                                \DB::table('invoices')
                                ->whereDate('created_at',  $from)
                                ->where('invoice_status',  0)
                                ->whereIn('branch', $branches_sales->pluck('branch_name'))
                                ->sum('invoice_total_price')
                            )
                        </strong>
                    </td>
                    <td>
                    <strong>
                        {{empty($app->currency) ? "GHS" : $app->currency}} @convert(
                                \DB::table('invoices')
                                ->whereDate('created_at',  $from)
                                ->where('invoice_status',  2)
                                ->whereIn('branch', $branches_sales->pluck('branch_name'))
                                ->sum('invoice_total_price')
                            )
                        </strong>
                    </td>
                </tr>
            </tfoot>
          
        </tbody>
	</table>
    @else

</div>

<table class="table table-bordered table-striped m-0">
        <thead>
        <tr>
            <th>Outlets</th>
            <th>Account number</th>
            <th>Total sale</th>
            <th>Discount</th>
            <th>Receipt count</th>
            <th>Rejected</th>
            <th>No Charge</th>
        </tr>
        </thead>
        <tbody>
            @foreach($branches_sales as $report)
            <tr>
                <td><span class="text-info">{{$report->branch_name}}</span></td>
                <td>{{$report->branch_account_number}}</td>
                <td>
                {{empty($app->currency) ? "GHS" : $app->currency}}@convert(
                        \DB::table('invoices')
                        ->WhereDate('created_at','>=', $from)
                        ->WhereDate('created_at','<=', $to)
                        ->where('invoice_status',  1)
                        ->where('branch', $report->branch_name)
                        ->sum('invoice_total_price')
                    )
                </td>
                <td>
                {{empty($app->currency) ? "GHS" : $app->currency}}@convert(
                        \DB::table('orders')
                        ->WhereDate('created_at','>=', $from)
                        ->WhereDate('created_at','<=', $to)
                        ->where('branch', $report->branch_name)
                        ->sum('discount')
                    )
                </td>
                <td>
                    @convert(
                        \DB::table('orders')
                        ->WhereDate('created_at','>=', $from)
                        ->WhereDate('created_at','<=', $to)
                        ->where('branch', $report->branch_name)
                        ->count()
                    )
                </td>
                <td>
                {{empty($app->currency) ? "GHS" : $app->currency}}@convert(
                        \DB::table('invoices')
                        ->WhereDate('created_at','>=', $from)
                        ->WhereDate('created_at','<=', $to)
                        ->where('invoice_status',  0)
                        ->where('branch', $report->branch_name)
                        ->sum('invoice_total_price')
                    )
                </td>
                <td>
                {{empty($app->currency) ? "GHS" : $app->currency}}@convert(
                        \DB::table('invoices')
                        ->WhereDate('created_at','>=', $from)
                        ->WhereDate('created_at','<=', $to)
                        ->where('invoice_status',  2)
                        ->where('branch', $report->branch_name)
                        ->sum('invoice_total_price')
                    )
                </td>
            </tr>
            @endforeach

            <tfoot>
                <tr>
                    <td><strong>Grand Total</strong></td>
                    <td></td>
                    <td>
                    <strong>
                    {{empty($app->currency) ? "GHS" : $app->currency}} @convert(
                        \DB::table('invoices')
                        ->WhereDate('created_at','>=', $from)
                        ->WhereDate('created_at','<=', $to)
                        ->where('invoice_status',  1)
                        ->whereIn('branch', $branches_sales->pluck('branch_name'))
                        ->sum('invoice_total_price')
                    )
                    </strong>
                    </td>
                    <td>
                        <strong>
                        {{empty($app->currency) ? "GHS" : $app->currency}}@convert(
                        \DB::table('orders')
                        ->WhereDate('created_at','>=', $from)
                        ->WhereDate('created_at','<=', $to)
                            ->sum('discount')
                        )
                        </strong>
                    </td>
                    <td>
                        <strong>
                        @convert(
                        \DB::table('orders')
                        ->WhereDate('created_at','>=', $from)
                        ->WhereDate('created_at','<=', $to)
                            ->count()
                        )
                        </strong>
                    </td>
                    <td>
                        <strong>
                        {{empty($app->currency) ? "GHS" : $app->currency}} @convert(
                                \DB::table('invoices')
                                ->WhereDate('created_at','>=', $from)
                                ->WhereDate('created_at','<=', $to)
                                ->where('invoice_status',  0)
                                ->whereIn('branch', $branches_sales->pluck('branch_name'))
                                ->sum('invoice_total_price')
                            )
                        </strong>
                    </td>
                    <td>
                    <strong>
                        {{empty($app->currency) ? "GHS" : $app->currency}} @convert(
                                \DB::table('invoices')
                                ->WhereDate('created_at','>=', $from)
                                ->WhereDate('created_at','<=', $to)
                                ->where('invoice_status',  2)
                                ->whereIn('branch', $branches_sales->pluck('branch_name'))
                                ->sum('invoice_total_price')
                            )
                        </strong>
                    </td>
                </tr>
            </tfoot>
          
        </tbody>
	</table>

   
</div>
@endif


</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('assets/js/jquery.min.js')}}"></script>
		<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('assets/js/modernizr.js')}}"></script>
		<script src="{{asset('assets/js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('assets/vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('assets/vendor/megamenu/js/custom.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>

		<!-- Apex Charts -->
		<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/salesGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/ordersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/earningsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/visitorsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/customersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('assets/vendor/circliful/circliful.custom.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>

		<!-- Dropzone JS -->
		<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('assets/js/main.js')}}"></script>

	</body>

</html>
