@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">


    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Cost of Sales Analysis Report</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('PrintSalesAnalysisBranch')}}" method="GET">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <input type="text" name="branch" value="{{$branch}}" hidden>
                    <!-- <a class="btn btn-danger" href="{{route('costOfSalesAnalysisDetailed')}}">	<i class="icon-bar-chart"></i> Detailed Report</a> -->
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"> Reports</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
                
            </div>
        </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->

						<!-- Row start -->
						<div class="row gutters">
							<div class="col-xl-12">
								<!-- Card start -->
								<div class="card">
									<div class="card-header">
                                        <div class="card-title">Cost of Sales Analysis Report -  [Summary - Product Wise]</div>
                                        @if(Route::currentRouteName() == "costOfSalesAnalysisDetailedSortBranchOfficer")
                                            <form action="{{route('PrintSalesAnalysisBranch')}}" method="GET" >
                                                <input type="text" name="branch" value="{{$branch}}" hidden>  
                                                <input type="text" name="type" value="{{request()->type}}" hidden>        
                                                <input type="text" name="date" value="<?= request()->date == null ? date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close))   : request()->date ?>" hidden>
                                                <button class="btn btn-primary">View Report</button>
                                            </form>
                                        @else 
                                            @if(request()->branch == null)
                                                <form action="{{route('PrintSalesAnalysis')}}" method="GET">
                                                        <input type="text" name="date" value="<?= request()->date == null ? date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close))   : request()->date ?>" hidden>
                                                        <button class="btn btn-primary">View Report</button>
                                                    </form>
                                            @else
                                            <form action="{{route('PrintSalesAnalysisBranch')}}" method="GET" >
                                            <input type="text" name="branch" value="{{request()->branch}}" hidden>  
                                            <input type="text" name="type" value="{{request()->type}}" hidden>        
                                            <input type="text" name="date" value="<?= request()->date == null ? date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close))   : request()->date ?>" hidden>
                                                        <button class="btn btn-primary">View Report</button>
                                                    </form>
                                            @endif
                                       @endif
                                    </div>
                                    
                                    <div style="margin-left:20px; margin-top:12px">
                                        Report for Today:  <em>{{request()->date == null ? $dayClose->day_close : request()->date }}</em>, Related Branch: {{$branch}}
                                    </div>
                                    
									<div class="card-body">
                                    <div class="table-responsive">
                                            <table id="copy-print-csv" class="table custom-table">
                                                <thead>
                                                    <tr>
                                                    <th>Date</th>
                                                    <th>Product</th>
                                                    <th>Category</th>
                                                    <th>Quantity</th>
                                                    <th>Net Amt({{empty($app->currency) ? "GHS" : $app->currency}})</th>
                                                    <th>Gross Amt({{empty($app->currency) ? "GHS" : $app->currency}})</th>
                                                    <th>Cost({{empty($app->currency) ? "GHS" : $app->currency}})</th>
                                                    <th>Cost(%)</th>
                                                    <th>Profit({{empty($app->currency) ? "GHS" : $app->currency}})</th>
                                                    <th>Profit(%)</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($cos as $report)
                                                    <tr>
                                                        <td>{{$report->date}}</td>
                                                        <td>{{$report->item_name}}</td>
                                                        <td>{{$report->category}}</td>
                                                        <td>{{$report->quantity}}</td>
                                                        <td>@convert($report->net_amount)</td>
                                                        <td>@convert($report->gross_amount)</td>
                                                        <td>@convert($report->cost)</td>
                                                        <td>@convert(((float)$report->cost/(float)($report->net_amount == 0 ? 1 :$report->net_amount))*100)</td>
                                                        <td>@convert($report->net_amount - $report->cost)</td>
                                                        <td>@convert((($report->net_amount - $report->cost)/($report->net_amount == 0 ? 1 :$report->net_amount))*100)</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                        </table>
                                        </div>
									</div>
								</div>
								<!-- Card end -->
                            </div>
						</div>
						<!-- Row end -->

                        @include('modal.branch-sales-analysis')
					</div>
					<!-- Content wrapper end -->


@endsection