@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">


    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Cost of Sales Analysis Report</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('costOfSalesAnalysis')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    @can('create', App\Models\User::class)
                    <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#exampleModalCenterBranchSales">View by Outlet</button>
                    @endcan
                    <!-- <a class="btn btn-danger" href="{{route('costOfSalesAnalysisDetailed')}}">	<i class="icon-bar-chart"></i> Detailed Report</a> -->
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"> Reports</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
                
            </div>
        </form>

        <br>
        @if(auth()->user()->role == "Administrator")
        <!-- <form action="{{route('costOfSalesAnalysisReRun')}}" method="get">
            <div class="d-flex justify-content-end">
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <input type="date" class="form-control" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"> Re run Cost </button>
                    </div>
                </div>
                
            </div>
        </form> -->
        @endif
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->

						<!-- Row start -->
						<div class="row gutters">
							<div class="col-xl-12">
								<!-- Card start -->
								<div class="card">
									<div class="card-header">
                                        <div class="card-title">Cost of Sales Analysis Report -  [All Outlets - MENU ITEMWISE]</div> 
                                       @if(request()->branch == null)
                                        <form action="{{route('PrintSalesAnalysis')}}" method="GET">
                                                <input type="text" name="date" value="<?= request()->date == null ? date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close))   : request()->date ?>" hidden>
                                                <button class="btn btn-outline-primary"> <i class="icon-printer"></i> Print</button>
                                            </form>
                                       @else
                                       <form action="{{route('PrintSalesAnalysisBranch')}}" method="GET" >
                                       <input type="text" name="branch" value="{{request()->branch}}" hidden>  
                                       <input type="text" name="type" value="{{request()->type}}" hidden>        
                                       <input type="text" name="date" value="<?= request()->date == null ? date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close))   : request()->date ?>" hidden>
                                                <button class="btn btn-outline-primary"> <i class="icon-printer"></i> Print</button>
                                            </form>
                                       @endif
                                    </div>

        
                                    
                                    <div style="margin-left:20px;">
                                        Report for Today:  <em>{{request()->date == null ? $dayClose->day_close : request()->date }}</em>, Related Branch: {{request()->branch == null ? "All Branches" : request()->branch }}
                                    </div>
                                    
									<div class="card-body">

                                    <div class="alert alert-light alert-dismissible fade show" role="alert">
                                    It provides an in-depth analysis of the costs directly associated with the sale of goods or services by a business. It helps evaluate the profitability and efficiency of the company's sales operations by examining the costs incurred in generating revenue.
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>

                                    <div class="table-responsive">
                                            <table id="copy-print-csv" class="table custom-table">
                                                <thead>
                                                    <tr>
                                                    @if(request('type') == "detailed")
                                                        <th>Date</th>
                                                    @endif
                                                    <th>Product</th>
                                                    <th>Category</th>
                                                    <th>Quantity</th>
                                                    <th>Net Amt({{empty($app->currency) ? "GHS" : $app->currency}})</th>
                                                    <th>Gross Amt({{empty($app->currency) ? "GHS" : $app->currency}})</th>
                                                    <th>Cost({{empty($app->currency) ? "GHS" : $app->currency}})</th>
                                                    <th>Cost(%)</th>
                                                    <th>Profit({{empty($app->currency) ? "GHS" : $app->currency}})</th>
                                                    <th>Profit(%)</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($cos as $report)
                                                    <tr>
                                                    @if(request('type') == "detailed")
                                                    <td>{{$report->date}}</td>
                                                        @endif
                                                        <td>{{@strtoupper($report->item_name)}}</td>
                                                        <td>{{@strtoupper($report->category)}}</td>
                                                        <td>{{$report->quantity}}</td>
                                                        <td>@convert($report->net_amount)</td>
                                                        <td>@convert($report->gross_amount)</td>
                                                        <td>@convert($report->cost)</td>
                                                        <td>@convert(((float)$report->cost/(float)($report->net_amount == 0 ? 1 :$report->net_amount))*100)</td>
                                                        <td>@convert($report->net_amount - $report->cost)</td>
                                                        <td>@convert((($report->net_amount - $report->cost)/($report->net_amount == 0 ? 1 :$report->net_amount))*100) </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                        </table>
                                        </div>
									</div>
								</div>
								<!-- Card end -->
                            </div>
						</div>
						<!-- Row end -->

                        @include('modal.branch-sales-analysis')
					</div>
					<!-- Content wrapper end -->


@endsection