<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<title> {{$app->app_name}}</title>
</head>
	<style type="text/css">

	table {
			width: 95%;
			padding: 1%;
			margin: 1%;
			text-align: left;
			border-collapse: collapse;
			font-size: 10px;

		}
	tr, th, td{
		border: 1px solid gray;
		padding: 1%;

	}

	</style>

<body onload="window.print();">
<center>


	<div style="font-size: 15px; font-weight: bolder;">
		<span><b>{{$app->app_name}}</b></span><br>
		<span>COST OF SALES ANALYSIS REPORT -  [SUMMARY - PRODUCT WISE]</span><br>
		<span><b> <?=@strtoupper(request()->branch == null ? "All Branches" : request()->branch );?></b></span><br>
		<span><b><i>  DATE:  <?=strtoupper(date("j F, Y", strtotime( request()->date == null ? $dayClose->day_close : request()->date)));?>.</i></b></span> <br>
	</div>

    <div class="table-responsive">
	<table style="border-collapse: collapse; font-size:9px">
        <thead>
        <tr>
            <th>Date</th>
            <th>Product</th>
            <th>Category</th>
            <th>Quantity</th>
            <th>Net Amt({{empty($app->currency) ? "GHS" : $app->currency}})</th>
            <th>Gross Amt({{empty($app->currency) ? "GHS" : $app->currency}})</th>
            <th>Cost({{empty($app->currency) ? "GHS" : $app->currency}})</th>
            <th>Cost(%)</th>
            <th>Profit({{empty($app->currency) ? "GHS" : $app->currency}})</th>
            <th>Profit(%)</th>
        </tr>
        </thead>
        <tbody>
            @foreach($cos as $report)
            <tr>
                <td>{{$report->date}}</td>
                <td>{{$report->item_name}}</td>
                <td>{{$report->category}}</td>
                <td>{{$report->quantity}}</td>
                <td>@convert($report->net_amount)</td>
                <td>@convert($report->gross_amount)</td>
                <td>@convert($report->cost)</td>
                <td>@convert(((float)$report->cost/(float)($report->net_amount == 0 ? 1 :$report->net_amount))*100)</td>
                <td>@convert($report->net_amount - $report->cost)</td>
                <td>@convert((($report->net_amount - $report->cost)/($report->net_amount == 0 ? 1 :$report->net_amount))*100)</td>
            </tr>
            @endforeach
                
        </tbody>
	</table>
</div>
</center>




Printed by: 
    {{auth()->user()->name}}<br>

Printed Date: <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>

</body>
</html>
