<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="ANDAS POS">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>Payment Summary For - {{request()->date == null ? $dayClose->day_close : request()->date}}</title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">


        <script src="{{asset('js/ajax.min.js')}}"></script>

        <!-- *************
            ************ assets/vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">


		
	</head>

<body onload="window.print();">


<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <a href="/" class="logo">
                    <img src="/assets/img/{{$app->fav_icon}}" alt="logo3" style="max-width:70px;">
            </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: {{auth()->user()->name}} <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0">
                    <strong>{{$app->app_name}}</strong>,<br>
                    Payment Summary<br>
                    Report for <strong><?=@strtoupper( request('branch'));?></strong>
                </address>

                <div class="invoice-num">
                    <div>Report Date</div>
                    <div> {{empty(request('date')) ? $dayClose->day_close : request('date')}} </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->

    <div class="table-responsive">
	<table class="table table-bordered table-striped m-0">
        <thead>
        <tr>
            <th>Name</th>
            <th>Description</th>
            <th>Total <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
        </tr>
        </thead>
        <tbody>
            <?php $sum = 0  ?>

            @foreach($agency_orders as $report)

            <?php 

                if (!request('date')) {
                    $discount = \DB::table('orders')->whereDate('created_at', $dayClose->day_close)->where('was_held','!=', 5)
                    ->where('branch', request('branch'))
                    ->where('payment_method', @strtoupper(empty($report->agency) ? "CASH" : $report->agency))->sum('discount');
                    $sum += $report->total - $discount;
                }else {
                    $discount = \DB::table('orders')
                    ->WhereDate('created_at','>=', $from)
                     ->WhereDate('created_at','<=', $to)     
                     ->where('branch', request('branch'))
                    ->where('was_held','!=', 5)->where('payment_method', @strtoupper(empty($report->agency) ? "CASH" : $report->agency))->sum('discount');
                    $sum += $report->total - $discount;
                }
                
            ?>
            <tr>
                <td>{{@strtoupper(empty($report->agency) ? "Cash" : $report->agency)}}</td>
                <td> Sales </td>
                <td>@convert($report->total - $discount)</td>
            </tr>
            @endforeach
            <tr>
                <td colspan="2">&nbsp;</td>
                <td><strong class="text-primary">@convert($sum) </strong></td>
            </tr>
               
        </tbody>
	</table>
</div>
</div>
</div>
</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('js/jquery.min.js')}}"></script>
		<script src="{{asset('js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('js/modernizr.js')}}"></script>
		<script src="{{asset('js/moment.js')}}"></script>

		<!-- *************
			************ assets/vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('assets/vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('assets/vendor/megamenu/js/custom.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>

		<!-- Apex Charts -->
		<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/salesGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/ordersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/earningsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/visitorsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/customersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('assets/vendor/circliful/circliful.custom.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>

		<!-- Dropzone JS -->
		<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('js/main.js')}}"></script>

	</body>

</html>
