@extends('layouts.app')

@section('content')
<?php $branching = \DB::table('branches')->OrderBy('branch_name', 'ASC')->get() ?>
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12">

            <!-- Dashboard header start -->
            <div class="dashboard-header">
                <div class="dashboard-header-content">
                    <!-- Top Actions - DateRange and Buttons -->
                    <form action="{{route('dateReport')}}" method="GET">
                            @csrf
                    <div class="d-flex justify-content-end">
                        <!-- Field wrapper start -->
                        
                        <div class="field-wrapper m-0">
                            <div class="input-group">
                                <input type="text" name="date" class="form-control custom-daterange2">
                                <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                </span>
                            </div>
                            <div class="field-placeholder">Select Date</div>
                        </div>
                        <!-- Field wrapper end -->
                        <button type="submit" class="btn"><i class="icon-download1"></i> <span>Reports</span></button>
                    </div>
                    </form>
                    <!-- Welcome Title -->
                    <div class="welcome-title">
                        <h1><strong>Hi! welcome!</strong><span> Generate Report </span>
                            <span class="winner-icon">
                                <img src="/assets/img/trophy.svg" alt="trophy">
                            </span>
                        </h1>
                    </div>

                    <!-- Sales Tiles COntainer -->
                    <div class="sales-tile-container">
                        <div class="sales-tile">
                            <h1><strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($all_sales)</strong></h1>
                            <h6> Sales - Last 30 days</h6>
                        </div>
                        <div class="sales-tile">
                            <h1><strong>{{$all_orders}}</strong></h1>
                            <h6><i class="icon-shopping-cart1"></i> Orders</h6>
                        </div>
                        <div class="sales-tile">
                            <h1><strong>{{$all_product}}</strong></h1>
                            <h6><i class="icon-shopping-bag1"></i> Products</h6>
                        </div>
                        <div class="sales-tile">
                            <h1><strong>{{$all_user_show->count()}}</strong></h1>
                            <h6><i class="far fa-user"></i> Users</h6>
                        </div>
                        
                    </div>
                </div>
            </div>
            <!-- Dashboard header end -->

        </div>
    </div>
    <!-- Row end -->

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-8 col-lg-8 col-md-12 col-sm-12 col-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Cashier Report</div>
                </div>
                <div class="card-body">
                <table id="rowSelection" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Cashier</th>
                        <th>Outlet</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($all_user_show as $user)
                        <tr>
                        <td>{{@strtoupper($user->name)}}</td>
                        <td>{{@strtoupper($user->branch)}}</td>
                        <td>
                        <button type="button" class="btn btn-outline-primary rounded-pill btn-sm" data-bs-toggle="modal" data-bs-target="#staticBackdrop{{$user->id}}">
                        <i class="icon-eye1" aria-hidden="true"></i>
                            </button>
                        </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Outlet Report</div>
                </div>
                <div class="card-body">
                
                <table class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Outlet</th>
                                  <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($branching as $branches)
                                <tr>												  
                                  <td>{{@strtoupper($branches->branch_name)}}</td>
                                  <td>
                                    <button type="button" class="btn btn-default rounded-pill btn-sm" data-bs-toggle="modal" data-bs-target="#staticBackdroprr{{$branches->id}}">
                                    <i class="icon-download1"></i> Report
                                    </button>                                 
                                </td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                </table>
                </div>
            </div>
        </div>
</div>
    <!-- Row end -->		

</div>
<!-- Content wrapper end -->



@foreach($all_user_show as $user)
<!-- Modal start Sales Report -->
<div class="modal fade" id="staticBackdrop{{$user->id}}" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="staticBackdropLabel">
            Generate Report of {{$user->name}}
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
             <!-- Top Actions - DateRange and Buttons -->
             <form action="{{route('dateReportByUser')}}" method="GET">
                            @csrf
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <!-- Field wrapper start -->
                        
                        <div class="field-wrapper m-0">
                            <div class="input-group">
                                <input type="text" name="user_id" value="{{$user->id}}" hidden>
                                <input type="text" name="date" class="form-control custom-daterange2">
                                <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                </span>
                            </div>
                            <div class="field-placeholder">Select Date</div>
                        </div>
                        <!-- Field wrapper end -->
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-2">
                            <button type="submit" class="btn btn-outline-primary"><i class="icon-download1"></i> <span>Reports</span></button>
                        </div>
                    </div>
                </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->
@endforeach



@foreach($branching as $branch)
<!-- Modal start Branch Report -->
<div class="modal fade" id="staticBackdroprr{{$branch->id}}" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="staticBackdropLabel">
            GENERATE REPORT FOR {{$branch->branch_name}}
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
             <!-- Top Actions - DateRange and Buttons -->
             <form action="{{route('branchSalesReport')}}" method="GET">
                            @csrf
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <!-- Field wrapper start -->
                        
                        <div class="field-wrapper m-0">
                            <div class="input-group">
                                <input type="text" name="branch" value="{{$branch->branch_name}}" hidden>
                                <input type="text" name="date" class="form-control custom-daterange2">
                                <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                </span>
                            </div>
                            <div class="field-placeholder">Select Date</div>
                        </div>
                        <!-- Field wrapper end -->
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-2">
                             <button type="submit" class="btn btn-outline-primary"><span>Reports</span></button>
                        </div>
                    </div>
                </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
@endforeach
<!-- Modal end -->




<script>
    function getId(clicked_id) {
        document.getElementById('user_id').value = clicked_id;
        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                // document.getElementById("demo").innerHTML = this.responseText;
                // console.log(this.responseText);
                document.getElementById('username').innerHTML = this.responseText;
            }
            xhttp.open("GET", "/get-user-details/"+clicked_id);
            xhttp.send();
    }


    function getIdBranch(clicked_id) {
        document.getElementById('branch').innerHTML = clicked_id;
        document.getElementById('branch_input').value = clicked_id;
    }
</script>

@endsection