@extends('layouts.app')

@section('content')
<?php $total = \DB::table('invoices')->where('invoice_category', '!=' ,'TRANSPORT')->where('branch', request()->branch)->where('user_role', "Call Center")->whereDate('created_at', $dayClose->day_close)->get() ?>
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

<div style="margin:15px">
    <h5><strong>Sales Report for </strong> - {{@strtoupper(request()->branch)}} , Sales Type: {{@strtoupper(request()->category)}}, DATE: {{request()->date}}</h5>
</div>

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($sales_today_branch->sum('invoice_total_price') - ($discounts+$deliveriesToday))</h2>
                        <p><strong>Net Sales</strong></p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($branch_total_house)</h2>
                        <p><a href="">No Charge</a></p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-check-circle"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($branch_total_reject)</h2>
                        <p><a href="#">Rejected Items</a></p>
                    </div>
                </div>
            </div>
        </div>



        
  

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                                <thead>
                                    <tr>
                                        <th>OrderNo.</th>
                                        <th>Ordered Date</th>
                                        <th>Product</th>
                                        <th>Qty</th>												
                                        <th>Rate</th>
                                        <th>Category</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sales_today_branch as $list)
                                    <tr>
                                        <td>#{{$list->invoice_number}}</td>
                                        <td>{{$list->created_at}}</td>
                                        <td>{{$list->invoice_product_name}}</td>
                                        <td>{{$list->invoice_quantity}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                        <td>{{$list->invoice_category}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->




    <!-- on the house sales and rejected orders -->

        <!-- Row start -->
        <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">On the House</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">        
                        <table                         id="apiCallbacks" class="table custom-table">

                                <thead>
                                    <tr>
                                         <th>OrderNo.</th>
                                        <th>Product</th>
                                        <th>Qty</th>												
                                        <th>Rate</th>
                                        <th>Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branch_total_house_list as $list)
                                    <tr>
                                    <td>#{{$list->invoice_number}}</td>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Rejected Order</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                        <table id="fixedHeader" class="table custom-table">
                                <thead>
                                    <tr>
                                        <th>OrderNo.</th>
                                        <th>Product</th>
                                        <th>Qty</th>												
                                        <th>Rate</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branch_total_reject_list as $list)
                                    <tr>
                                        <td>#{{$list->invoice_number}}</td>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                           
                        
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->


        <div class="col">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Invoice List</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                        <table id="scrollVertical" class="table custom-table">
                                <thead>
                                    <tr>
                                        <th>OrderNo.</th>
                                        <th>Total</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($order as $list)
                                    <tr>
                                        <td>#{{$list->order_id}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->total_cost_order - $list->discount}}</td>
                                        <td>
                                        @if($list->status == 5)
                                            <span class="badge bg-warning">
                                                    On Hold</span>
                                            @else
                                            <span class="badge bg-primary">
                                                    Completed</span>

                                            @endif
                                        </td>
                                        <td><a href="{{route('orderTransaction',$list->order_id)}}">view transaction</a></td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                           
                        
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
</div>
</div>
<!-- Content wrapper end -->

<!-- Modal for Discount Orders -->
@include('inc.discount-items')


@endsection