@extends('layouts.app')

@section('content')
<?php $total = \DB::table('invoices')->where('invoice_category', '!=' ,'TRANSPORT')->where('branch', request('branch'))->where('user_role', "Call Center")->whereDate('created_at', $dayClose->day_close)->get() ?>
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

<div>
    <h4><strong>{{$branch}}</strong> SALES REPORT FOR TODAY</h4>

    <form action="{{route('PrintSummaryBranch')}}" method="get">
        <input type="text" name="branch" value="{{request('branch')}}" hidden>
        <button class="btn btn-outline-light"><i class="icon-print"></i> Payment Summary Report</button>
    </form>
</div>

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($total_sales = (float)$branch_total_general - (float)$deliveries)</h2>
                        <p><strong><a href="#">Net Sales</a></strong></p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($branch_total_house)</h2>
                        <p><a href="#">No Charge</a></p>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-check-circle"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($branch_total_reject)</h2>
                        <p><a href="#">Rejected Order</a></p>
                    </div>
                </div>
            </div>
        </div>
    <!-- ROW END -->

<!-- Row start -->
<div class="row">
    <div class="col-sm-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Reports</h5>
                <p class="mb-3 text-light">view summary report on product, by item or product category, Report on discounted sales</p>
                <a href="{{route('departmentSummaryBranch', $branch)}}" class="text-danger" style="text-decoration:underline">View by Category</a>, 
                <a href="{{route('itemSummaryBranch', $branch)}}" class="text-danger" style="text-decoration:underline"> View by Item</a>,
                <a href="#" class="text-danger" style="text-decoration:underline" data-bs-toggle="modal" data-bs-target="#exampleModalFullScreen">
                    Discounts {{empty($app->currency) ? "GHS" : $app->currency}}@convert($discounts)
                </a>
            </div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Earnings</div>
            </div>
            <div class="card-body">
                
                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                        <div class="weekly-earnings">
                            <div id="weeklyEarnings"></div>
                            <p>Confirmed Sales</p>
                            <h5>{{empty($app->currency) ? "GHS" : $app->currency}} @convert($branch_total_general)</h5>															
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                        <div class="weekly-earnings">
                            <div id="monthlyEarnings"></div>
                            <p>Discounts & other amounts</p>
                            <h5>{{empty($app->currency) ? "GHS" : $app->currency}} @convert($unconfirmed = (float)$orders - (float)$branch_total_general)</h5>															
                        </div>
                    </div>
                </div>
                <!-- Row end -->
            </div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="card">
        <div class="card-header">
            <div class="card-title">Sales Type</div>
        </div>
        <div class="card-body">
            <div class="todo-container">
                <ul class="todo-body">
                    <li class="todo-list">
                        <div class="todo-info">
                            <span class="dot blue"></span>
                            <p>WALK-IN SALES</p>
                            <form action="{{route('getDeliveryReportRoute')}}" method="get">
                                        @csrf
                                        <input type="text" name="branch" hidden value="{{request()->branch}}">
                                        <input type="text" name="category" hidden value="Counter">
                                        <input type="text" readonly hidden name="date" value="<?= date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close));?>">
                                        <button type="submit" class="text-primary btn btn-link"> 
                                            view report
                                        </button>
                                    </form>
                        </div>
                    </li>												
                    <li class="todo-list">
                        <div class="todo-info">
                            <span class="dot orange"></span>
                            @if(request()->branch == "DAKODWOM BRANCH")
                            <p>DRIVE TNRU</p>
                            @else
                            <p>DELIVERY & CALL CENTER( {{empty($app->currency) ? "GHS" : $app->currency}}@convert($total->sum('invoice_total_price'))  )</p>
                            @endif
                            @if(request()->branch == "DAKODWOM BRANCH")
                            <form action="{{route('getDeliveryReportRoute')}}" method="get">
                            @csrf
                                        <input type="text" name="branch" hidden value="{{request()->branch}}">
                                        <input type="text" name="category" hidden value="Drive Thru">
                                        <input type="text" readonly hidden name="date" value="<?= date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close));?>">
                                        <button type="submit" class="text-primary btn btn-link"> 
                                            view report
                                        </button>
                                    </form>
                            @else
                            <form action="{{route('getDeliveryReportRoute')}}" method="get">
                            @csrf
                                        <input type="text" name="branch" hidden value="{{request()->branch}}">
                                        <input type="text" name="category" hidden value="Delivery">
                                        <input type="text" readonly hidden name="date" value="<?= date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close));?>">
                                        <button type="submit" class="text-primary btn btn-link"> 
                                            view report
                                        </button>
                                    </form>

                            @endif
                        </div>
                    </li>
                </ul>
            </div>
        </div>
        </div>
    </div>
</div>
<!-- Row end -->




    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    
                <div class="custom-tabs-container">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="first-tab" data-bs-toggle="tab" href="#first" role="tab" aria-controls="first" aria-selected="true"> Transactions</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="second-tab" data-bs-toggle="tab" href="#second" role="tab" aria-controls="second" aria-selected="false">No Charge</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="third-tab" data-bs-toggle="tab" href="#third" role="tab" aria-controls="third" aria-selected="false">Rejected Orders</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="fourth-tab" data-bs-toggle="tab" href="#fourth" role="tab" aria-controls="fourth" aria-selected="false">Orders</a>
                        </li>
                    </ul>
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="first" role="tabpanel">

                        <div class="table-responsive">
                        <table id="copy-print-csv" class="table v-middle">
                                <thead>
                                    <tr>
                                        <th>OrderNo.</th>
                                        <th>EnteredBy</th>
                                        <th>OrderedDate</th>
                                        <th>Product</th>
                                        <th>Qty</th>												
                                        <th>Rate</th>
                                        <th>Pay Method</th>
                                        <th>Category</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sales_today_branch as $list)
                                    <tr>
                                        <td>#{{$list->invoice_number}}</td>
                                        <td>
                                        <?php
                                        $user_tr = \DB::table('users')->where('id', $list->user_id)->first();
                                        echo $user_tr->name;
                                        ?>
                                        
                                        </td>
                                        <td>{{$list->created_at}}</td>
                                        <td>
                                        {{@strtoupper($list->invoice_product_name)}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_unit_price)</td>
                                        <td>{{@strtoupper($list->agency)}}</td>
                                        <td>{{@strtoupper($list->invoice_category)}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_total_price)</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                    </div>


                        </div>
                        <div class="tab-pane fade" id="second" role="tabpanel">
                        <div class="table-responsive">       
                        <table id="apiCallbacks" class="table custom-table">

                                <thead>
                                    <tr>
                                        <th>Invoice No.</th>	
                                        <th>Product</th>
                                        <th>Qty</th>												
                                        <th>Rate</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branch_total_house_list as $list)
                                    <tr>
                                        <td>
                                        {{$list->invoice_number}}
                                        </td>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_unit_price)</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_total_price)</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
`                           </div>

                        </div>
                        <div class="tab-pane fade" id="third" role="tabpanel">
                            
                        <div class="table-responsive">
                        <table class="table table-bordered table-striped m-0">
                                <thead>
                                    <tr>
                                        <th>OrderNo.</th>
                                        <th>Product</th>
                                        <th>Qty</th>												
                                        <th>Rate</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branch_total_reject_list as $list)
                                    <tr>
                                        <td>{{$list->invoice_number}}</td>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                            {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                           
                        </div>

                        </div>
                        <div class="tab-pane fade" id="fourth" role="tabpanel">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">        
                        <table id="fixedHeader" class="table custom-table">
                                <thead>
                                    <tr>
                                        <th>InvoiceNo.</th>
                                        <th>EnteredBy </th>	
                                        <th>OrderedDate</th>
                                        <th>Sales Type</th>		
                                        <th>Total</th>											
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($ordersfromBranch as $list)
                                    <tr>
                                        <td>
                                        <a href="{{route('orderTransaction',$list->order_id)}}">#{{$list->order_id}}</a>
                                        </td>
                                        <td>
                                        <?php
                                        $user_ord = \DB::table('users')->where('id', $list->user_id)->first();
                                        echo $user_ord->name;
                                        ?>
                                        </td>
                                        <td>{{$list->created_at}}</td>
                                        <td>
                                            {{$list->category}}
                                        </td>
                                        <td>
                                        {{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->total_cost_order - $list->discount)
                                        </td>
                                        <td>
                                        <div class="actions">
                                            <a href="{{route('orderTransaction',$list->order_id)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="view order">
                                                <i class="icon-eye1 text-primary" aria-hidden="true"></i>
                                             </a>
                                        </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>

                        </div>
                        
                    </div>
                </div>
                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

</div>
</div>

<!-- Modal for Discount Orders -->
@include('inc.discount-items')

</div>
<!-- Content wrapper end -->




@endsection