@extends('layouts.app')

@section('content')


<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header-lg">
                    <h4>App Settings</h4>
                </div>
                <div class="card-body">

                    <div class="row gutters">
                        <div class="col-xl-8 col-lg-8 col-md-12 col-sm-12 col-12">
                            <div class="row gutters">
                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                    <img src="/assets/img/{{$app->app_logo}}" alt="Logo" style="max-width:57px;">
                                </div>
                                @if($app_info == null)
                                <form action="{{route('saveSettings')}}" method="post" enctype="multipart/form-data">
                                    @csrf

                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="file" class="form-control" name="image">
                                            <div class="field-placeholder">Application Logo</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>


                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" placeholder="App Name" name="app_name">
                                            <div class="field-placeholder">Application Name</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" placeholder="TIN" name="app_tin">
                                            <div class="field-placeholder">TIN Number</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <select id="unit-listing" class="select-single js-states" title="Select Term" name="currency" data-live-search="true">
                                                <option disabled selected>Select Currency</option>
                                                @foreach($currencies as $currencies)
                                                <option>{{$currencies -> currency}}</option>
                                                @endforeach
                                            </select>
                                            <div class="field-placeholder">Currency </div>
                                        </div>
                                        <!-- Field wrapper end -->
                                        <small>New Currency</small>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" placeholder="app_website">
                                            <div class="field-placeholder">Website</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" placeholder="prince.asamoah@ceqaltd.com" name="app_email">
                                            <div class="field-placeholder">Email</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                     <!-- Field wrapper start -->
                                    <div class="field-wrapper">
                                        
                                        <select class="select-single js-states" title="Select Term" data-live-search="true" name="station">
                                        
                                        <option disabled selected>Select Category</option>
                                                @foreach($warehouses as $warehouse)
                                                <option>{{$warehouse->warehouse_name}}</option>
                                                @endforeach
                                                @foreach($kitchens as $kitchen)
                                                <option>{{$kitchen->kitchen_name}}</option>
                                                @endforeach
                                        
                                        </select>
                                        
                                        <div class="field-placeholder">Store<span class="text-danger">*</span></div>
                                    </div>
                                    <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <textarea id="" cols="30" rows="10" name="app_description"></textarea>
                                            <div class="field-placeholder">Description</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                        <textarea id="" cols="30" rows="10" name="app_receipt_footer"></textarea>
                                            <div class="field-placeholder">Receipt Footer</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <button class="btn btn-primary mb-3">Save</button>
                                    </div>
                                </form>
                                @else
                                <form action="{{route('updateSettings', $app_info ->id)}}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="file" class="form-control" name="image">
                                            <div class="field-placeholder">Application Logo</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" placeholder="App Name" name="app_name" value="{{$app_info ->app_name}}">
                                            <div class="field-placeholder">Company Name</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <select id="unit-listing" class="select-single js-states" title="Select Term" name="currency" data-live-search="true">
                                                <option selected>{{$app_info ->currency}}</option>
                                                @foreach($currencies as $currencies)
                                                <option>{{$currencies -> currency}}</option>
                                                @endforeach
                                            </select>
                                            <div class="field-placeholder">Currency</div>
                                            <small class="text-primary"><a href="" data-bs-toggle="modal" data-bs-target="#currency">New Currency</a></small>
                                        </div>
                                        
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" placeholder="TIN" name="app_tin" value="{{$app_info ->app_tin}}">
                                            <div class="field-placeholder">TIN Number</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" placeholder="app_website" name="app_website" value="{{$app_info ->app_website}}">
                                            <div class="field-placeholder">Website</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" placeholder="prince.asamoah@ceqaltd.com" name="app_email" value="{{$app_info ->app_email}}">
                                            <div class="field-placeholder">Email</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                     <!-- Field wrapper start -->
                                    <div class="field-wrapper">
                                        
                                        <select class="select-single js-states" title="Select Term" data-live-search="true" name="station">
                                        <option selected>{{$app_info ->main_warehouse}}</option>
                                                @foreach($warehouses as $warehouse)
                                                <option>{{$warehouse->warehouse_name}}</option>
                                                @endforeach
                                                @foreach($kitchens as $kitchen)
                                                <option>{{$kitchen->kitchen_name}}</option>
                                                @endforeach
                                        
                                        </select>
                                        
                                        <div class="field-placeholder">Main Warehouse<span class="text-danger">*</span></div>
                                    </div>
                                    <!-- Field wrapper end -->
                                    </div>


                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <textarea id="" cols="30" rows="10" name="app_description">{{$app_info ->app_description}}</textarea>
                                            <div class="field-placeholder">Description</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                        <textarea id="" cols="30" rows="10" name="app_receipt_footer">{{$app_info ->app_receipt_footer}}</textarea>
                                            <div class="field-placeholder">Receipt Footer</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>


                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="file" class="form-control" name="favicon">
                                            <div class="field-placeholder">Fav Icon</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <button class="btn btn-primary mb-3">Save Settings</button>
                                    </div>
                                </form>
                                @endif
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12">
                            <div class="account-settings-block">
                                
                                <div class="settings-block">
                                    <div class="settings-block-title">Other Settings</div>
                                    <div class="settings-block-body">
                                        <div class="list-group">
                                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                                <div><?= $app->inventory_mgt == 1 ? "Disable" : "Enable" ?> POS stock checks</div>
                                                <div class="form-switch">
                                                    <input class="form-check-input" <?= $app->inventory_mgt == 1 ?  'checked': '' ?> type="checkbox" id="select-all">
                                                    <label class="form-check-label" for="showNotifications"></label>
                                                </div>
                                            </div>
                                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                                <div><?= $app->issue_check == 1 ? "Disable" : "Enable" ?> Issues stock checks</div>
                                                <div class="form-switch">
                                                    <input class="form-check-input" <?= $app->issue_check == 1 ?  'checked': '' ?> type="checkbox" id="issue-check">
                                                    <label class="form-check-label" for="showEmailNotifications"></label>
                                                </div>
                                            </div>
                                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                                <div><?= $app->production_check == 1 ? "Disable" : "Enable" ?> production stock checks</div>
                                                <div class="form-switch">
                                                    <input class="form-check-input" <?= $app->production_check == 1 ?  'checked': '' ?> type="checkbox" id="production-check">
                                                    <label class="form-check-label" for="showEmailNotifications"></label>
                                                </div>
                                            </div>
                                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                                <div>Activate Sales Target</div>
                                                <div class="form-switch">
                                                    <input class="form-check-input" type="checkbox" id="showEmailNotifications" checked>
                                                    <label class="form-check-label" for="showEmailNotifications"></label>
                                                </div>
                                            </div>
                                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                                <div>Enable Inventory Authorization</div>
                                                <div class="form-switch">
                                                    <input class="form-check-input" type="checkbox" id="showChatNotifications" checked>
                                                    <label class="form-check-label" for="showChatNotifications"></label>
                                                </div>
                                            </div>
                                          
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->



<!-- Modal start -->
<div class="modal fade" id="currency" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">New Currency</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <form action="{{route('Currency')}}" method="post">
                @csrf
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">                                  
                        <div class="field-wrapper">
                            <input type="text" placeholder="Enter Currency" name="currency">
                            <div class="field-placeholder">New Currency <span class="text-danger">*</span></div>
                        </div>
                </div>
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <button class="btn btn-primary">Submit</button>
                </div>
            </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->


<script type="text/javascript">  
    document.getElementById('select-all').onclick = function(){
        Swal.fire({
            title: 'Are you sure?',
            text: "Change status of Inventory Checker",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/change_inventory-status";
            }
            })
    }    
    
    
    document.getElementById('issue-check').onclick = function(){
        Swal.fire({
            title: 'Are you sure?',
            text: "Enabling stock check to prevent low level stock transfer",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/enable-issue-check";
            }
            })
    }   
    
    document.getElementById('production-check').onclick = function(){
        Swal.fire({
            title: 'Are you sure?',
            text: "Enabling stock check to prevent low level stock transfer",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/enable-production-check";
            }
            })
    }    
</script> 

@endsection