<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>ITEM STOCK LEDGER -  {{request()->date == null ? $dayClose->day_close : request()->start_date}}</title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">

        <!-- fontAwesome -->
        <link href="{{asset('assets/fontawesome/css/all.css')}}" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


        <script src="{{asset('assets/js/ajax.min.js')}}"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">


		
	</head>

<body onload="window.print();">






<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <a href="#" class="logo">
                <img src="/assets/img/{{$app->app_logo}}" alt="Logo" style="max-height:60px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: {{auth()->user()->name}} <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="invoice-details">
            <address class="m-0">
                <strong>{{auth()->user()->station}}</strong>
                                <div class="table-responsive">
											<table class="table table-sm">
												<tbody>
													<tr>
														<td><strong style="font-weight:600">Item Name</strong></td>
														<td>{{@ucwords(@strtolower($item->item_name))}}</td>
													</tr>
													<tr>
														<td><strong style="font-weight:600">Category</strong></td>
														<td>{{@ucwords(@strtolower($item->item_category))}}</td>
													</tr>
													<tr>
														<td><strong style="font-weight:600">UOM</strong></td>
														<td>{{$item->item_unit}}</td>
													</tr>
													<tr>
														<td><strong style="font-weight:600">Closing Stock</strong></td>
                                                        <td>@convert(($transactions_db->sum('stock_in') + $balance_b_f_) - $transactions_db->sum('stock_out'))</td>
													</tr>
                                                    <tr>
														<td><strong style="font-weight:600">Stock Value</strong></td>
                                                        <td>
                                                            <?php

                                                                $getAllCOst =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item->id)->get();

                                                                if (empty($getAllCOst)) {

                                                                $total_cost = 0;

                                                                    }else {

                                                                    $sumReCost = 0 ;
                                                                    $sumIssueCost = 0 ;

                                                                        foreach ($getAllCOst as $key => $cost) {

                                                                            $sumIssueCost += round($cost->stock_out, 2) * round($cost->cost, 2);
                                                                            $sumReCost += round($cost->stock_in, 2) * round($cost->cost, 2);

                                                                        }

                                                                        $total_cost =  (round($sumReCost, 2) - round($sumIssueCost, 2));
                                                                    }



                                                                ?>
                                                                <span class="text-primary"> {{empty($app->currency) ? "GHS" : $app->currency}} @convert($total_cost)</span>
                                                        </td>
													</tr>
												</tbody>
											</table>
                                        </div>
                                    </address>

                <div class="invoice-num">
                    <div>Report Date</div>
                    <div> {{request()->date == null ? $dayClose->day_close : request()->date}}</div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->


    <div class="table-responsive">
    <table class="table table-bordered table-striped m-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Stock In </th>
                        <th>Stock Out</th>
                        <th>Stock Balances</th>
                        <th>Rate <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                        <th>Item Value <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                    </tr>
                </thead>
                <tbody>
                @if($balance_b_f_ !== 0)
                    <tr>
                        <td></td>
                        <td></td>
                        <td>Balance B/F</td>
                        <td></td>
                        <td></td>
                        <td>@if($balance_b_f_ < 0)
                        <strong style="font-weight:700">@convert($balance_b_f_) </strong>
                        @else
                        <strong style="font-weight:700">@convert($balance_b_f_)</strong>
                        @endif</td>
                    </tr>
                    @endif
                    @foreach($transactions_db->chunk(20) as $rows)
                    @foreach($rows as $transactions)
                    @if(empty($transactions->stock_in) && empty($transactions->stock_out))
                        @continue
                    @endif
                    <tr>
                                        <td>{{$transactions->id}}</td> 
                                            <td>
                                            <?php 
                                                $date = \Carbon\Carbon::parse($transactions->created_at, 'UTC');
                                            ?>
                                                {!!$date->isoFormat('Do MMM YYYY, h:mm:ss a')!!}

                                            </td>
                                            <td>{!!@ucwords(@strtolower($transactions->description))!!}
                                                <p class="text-mute">{!! $transactions->note !!}</p>
                                            </td>
                                           
                                            <td>
                                            @if(!empty($transactions->stock_in) || null)
                                                @convert($transactions->stock_in)
                                            @endif
                                            </td>
                                            <td>
                                                @if(!empty($transactions->stock_out) || null)
                                                @convert($transactions->stock_out)
                                                @endif
                                            </td>
                                            <td>
                                                
                                                <?php
                                                
                                                    $ac_ids = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
                                                    ->WhereDate('date','>=', $from)
                                                    ->WhereDate('date','<=', $to)
                                                    ->where('id', '<=', $transactions->id)
                                                    ->pluck('id');

                                                    $debit = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
                                                    ->whereIn('id', $ac_ids)
                                                    ->sum('stock_in');

                                                    $credit = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
                                                    ->whereIn('id', $ac_ids)
                                                    ->sum('stock_out');
                                                ?>
                                                @if(!empty($transactions->stock_in) || null)
                                                <?php $tra_balance = (($debit+$balance_b_f_)-$credit)
                                                    ?>
                                                    @if($tra_balance < 0)
                                                        <span class="text-danger"> @convert(round($tra_balance,2))</span>
                                                    @else
                                                    @convert(round($tra_balance,2))
                                                    @endif
                                                @else
                                                <?php $tra_balance = (($debit+$balance_b_f_)-$credit) ?>
                                                    @if($tra_balance < 0)
                                                        <span class="text-danger"> @convert(round($tra_balance,2))</span>
                                                    @else
                                                    @convert(round($tra_balance, 2))
                                                    @endif

                                                @endif
                                                 
                                            </td>
                                            <td>
                                              @convert($cost = round($transactions->cost, 2))
                                            </td>
                                            <td>
                                            @if(!empty($transactions->stock_in) || null)
                                                @convert(round($cost, 2) * round($transactions->stock_in,2))
                                            @else
                                                @convert(round($cost,2) * round($transactions->stock_out,2))
                                            @endif
                                            </td>
                                        </tr>
                    @endforeach
                    @endforeach
                    
                </tbody>
            </table>
        </div>
    </div>

</div>
</div>
</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('assets/js/jquery.min.js')}}"></script>
		<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('assets/js/modernizr.js')}}"></script>
		<script src="{{asset('assets/js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('assets/vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('assets/vendor/megamenu/js/custom.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>

		<!-- Apex Charts -->
		<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/salesGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/ordersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/earningsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/visitorsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/customersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('assets/vendor/circliful/circliful.custom.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>

		<!-- Dropzone JS -->
		<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('assets/js/main.js')}}"></script>

	</body>

</html>
