@extends('layouts.fullscreen')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-header-lg">
                <h4>Stock History</h4>

                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

                <form action="{{route('StockFilterPrint')}}" id="print-stock" method="get">
                    <input type="text" name="item_id" value="{{request('item_id')}}" hidden>
                    <input type="date" class="form-control" value="{{empty(request('start_date')) ? $dayClose->day_close   :  request('start_date')}}" hidden name="start_date">
                    <input type="date" class="form-control" value="{{empty(request('end_date')) ? $dayClose->day_close   :  request('end_date')}}" hidden name="end_date">
                </form>
                
                    

                     <form action="{{route('StockFilter')}}" method="get">

                     <input type="text" name="item_id" value="{{request('item_id')}}" hidden>
                        <div class="d-flex justify-content-end">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper m-0">
                                <div class="input-group">
                                <button class="btn btn-outline-info" style="margin-right:10px" type="button" onclick="PrintAccount()"><i class="icon-printer"></i>Print</button>
                                <div style="margin-right:10px"><small>From</small></div>
                                <input type="date" class="form-control" name="start_date" max="{{$dayClose->day_close}}">
                                <div style="margin-right:10px; margin-left:10px"><small>to</small></div>
                                <input type="date" class="form-control" name="end_date" max="{{$dayClose->day_close}}">
                                    <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                    </span>
                                    <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                                </div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                    </form>
                </div>

            </div>
            <div class="card-body">

                <div class="invoice-container">


                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="invoice-details">
                                <address class="m-0">
                                <div class="table-responsive">
											<table class="table table-sm">
												<tbody>
													<tr>
														<td><strong style="font-weight:600">Item</strong></td>
														<td>{{@ucwords(@strtolower($item->item_name))}}</td>
													</tr>
													<tr>
														<td><strong style="font-weight:600">Category</strong></td>
														<td>{{@ucwords(@strtolower($item->item_category))}}</td>
													</tr>
													<tr>
														<td><strong style="font-weight:600">UOM</strong></td>
														<td>{{@ucwords(@strtolower($item->item_unit))}}</td>
													</tr>
													<tr>
														<td><strong style="font-weight:600">Closing Stock</strong></td>
                                                        <td>@convert(round(($transactions_db->sum('stock_in') + $balance_b_f_) - $transactions_db->sum('stock_out'),2))</td>
													</tr>

                                                    <tr>
														<td><strong style="font-weight:600">Stock Value</strong></td>
                                                        <td>
                                                            <?php

                                                                $getAllCOst =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item->id)->get();

                                                                if (empty($getAllCOst)) {

                                                                $total_cost = 0;

                                                                    }else {

                                                                    $sumReCost = 0 ;
                                                                    $sumIssueCost = 0 ;

                                                                        foreach ($getAllCOst as $key => $cost) {

                                                                            $sumIssueCost += round($cost->stock_out, 2) * round($cost->cost, 2);
                                                                            $sumReCost += round($cost->stock_in, 2) * round($cost->cost, 2);

                                                                        }

                                                                        $total_cost =  (round($sumReCost, 2) - round($sumIssueCost, 2));
                                                                    }



                                                                ?>
                                                                <span class="text-primary"> {{empty($app->currency) ? "GHS" : $app->currency}} @convert($total_cost)</span>
                                                        </td>
													</tr>
												</tbody>
											</table>
                                        </div>
                                    </address>

                                <div class="invoice-num">
                                    <div>{{empty(request('start_date')) ? $dayClose->day_close : request('start_date') . "/" . request('end_date')}}</div>
                                    <div>{{auth()->user()->station}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Row end -->

                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-12">
                            
                            <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Type</th>
                                            <th>Stock In </th>
                                            <th>Stock Out</th>
                                            <th>Stock Balances</th>
                                            <th>Rate <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                            <th>Item Cost <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    @if($balance_b_f_ !== 0)
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td>Balance B/F</td>
                                            <td></td>
                                            <td></td>
                                            <td>@if($balance_b_f_ < 0)
                                            <strong style="font-weight:700">@convert(round($balance_b_f_,2))</strong>
                                            @else
                                            <strong style="font-weight:700">@convert(round($balance_b_f_,2))</strong>
                                            @endif</td>
                                            <td></td>
                                           <td></td>
                                        </tr>
                                        @endif
                                       
                                        @foreach($transactions_db->chunk(10) as $rows)
                                        @foreach($rows as $transactions)
                                        @if(empty($transactions->stock_in) && empty($transactions->stock_out))
                                            @continue
                                        @endif
                                        <tr>
                                        <td>{{$transactions->id}}</td> 
                                            <td>
                                            <?php 
                                                $date = \Carbon\Carbon::parse($transactions->created_at, 'UTC');
                                            ?>
                                                {!!$date->isoFormat('Do MMM YYYY, h:mm:ss a')!!}

                                            </td>
                                            <td>{!!@ucwords(@strtolower($transactions->description))!!}
                                                <p class="text-mute">{!! $transactions->note !!}</p>
                                            </td>
                                           
                                            <td>
                                            @if(!empty($transactions->stock_in) || null)
                                                @convert(round($transactions->stock_in,2))
                                            @endif
                                            </td>
                                            <td>
                                                @if(!empty($transactions->stock_out) || null)
                                                @convert(round($transactions->stock_out,2))
                                                @endif
                                            </td>
                                           
                                            <td>
                                                
                                                <?php
                                                
                                                    $ac_ids = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
                                                    ->WhereDate('date','>=', $from)
                                                    ->WhereDate('date','<=', $to)
                                                    ->where('id', '<=', $transactions->id)
                                                    ->pluck('id');

                                                    $debit = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
                                                    ->whereIn('id', $ac_ids)
                                                    ->sum('stock_in');
                                                    $debit = round($debit, 2);

                                                    $credit = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
                                                    ->whereIn('id', $ac_ids)
                                                    ->sum('stock_out');

                                                    $credit = round($credit, 2);
                                                ?>
                                                @if(!empty($transactions->stock_in) || null)
                                                <?php $tra_balance = ((round($debit, 2)+round($balance_b_f_, 2))-round($credit, 2)) ?>
                                                    @if($tra_balance < 0)
                                                        <span class="text-danger"> @convert(round($tra_balance,2))</span>
                                                    @else
                                                         @convert(round($tra_balance,2))
                                                    @endif
                                                @else
                                                <?php $tra_balance = ((round($debit, 2)+round($balance_b_f_, 2))-round($credit, 2)) ?>
                                                    @if($tra_balance < 0)
                                                        <span class="text-danger"> @convert(round($tra_balance,2))</span>
                                                    @else
                                                        @convert(round($tra_balance, 2))
                                                    @endif

                                                @endif
                                                 
                                            </td>
                                           
                                            <td>
                                              @convert($cost = round($transactions->cost, 2))
                                            </td>
                                            <td>
                                            @if(!empty($transactions->stock_in) || null)
                                                @convert(round($cost, 2) * round($transactions->stock_in,2))
                                            @else
                                                @convert(round($cost,2) * round($transactions->stock_out,2))
                                            @endif
                                            </td>
                                            
                                        </tr>
                                        @endforeach
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                        </div>
                    </div>
                   
                </div>

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
						<!-- Row end -->


</div>

<script>
    function DeleteAccount(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "you are removing this transaction, you won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Remove !'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/account/transaction/delete/" + id;
            }
            })
    }


    function PrintAccount() {
        document.getElementById("print-stock").submit();
    }
</script>


@endsection