@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item"><a href="#"><a href="#">Item_stock_ledger</a></li>
                    </li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">   
        <!-- Top Actions - DateRange and Buttons -->
    
        <form action="{{route('IslTemporal')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <div style="margin-right:10px"><small>From</small></div>
                    <input type="date" class="form-control" name="start_date" max="{{$dayClose->day_close}}" value="{{$dayClose->day_close}}">
                    <div style="margin-right:10px; margin-left:10px"><small>to</small></div>
                    <input type="date" class="form-control" name="end_date" max="{{$dayClose->day_close}}" value="{{$dayClose->day_close}}">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
                
            </div>
        </form>
        </div>
        </div>
    </div>
    <!-- Breadcrumb container end -->


<!-- Row start -->
<div class="row">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-body">

                <div class="custom-tabs-container">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="first-tab" data-bs-toggle="tab" href="#first" role="tab" aria-controls="first" aria-selected="true">ISL - {{auth()->user()->station}}</a>
                        </li>
                    </ul>
                    <div class="tab-content" id="myTabContent">
                    <div style="margin-bottom:12px">
                        @if(!empty(request('start_date')))
                            Filtered ISL for: {{request('start_date')}} - {{request('start_date')}}
                        @endif
                    </div>
                        <div class="tab-pane fade show active" id="first" role="tabpanel">
                        <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                <thead>
                                    <tr>
                                        <th>Item</th>
                                        <th>Category</th>
                                        <th>UOM</th>
                                        <th>CreatedAt</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach($itemss->chunk(100) as $row)
                                @foreach($row as $item)
                                @if(in_array(auth()->user()->station, json_decode($item->inactive_station)) == true)
                                    @continue
                                @endif
                               
                                <tr>
                                  <td>
                                      <div class="media-box">
                                          <div class="media-box-body">
                                              <a href="#" class="text-truncate">{{@ucwords(@strtolower($item->item_name))}}</a>
                                              <p>{{$item->item_code}}</p>
                                          </div>
                                      </div>
                                  </td>
                                  <td>{{@ucwords(@strtolower($item->item_category))}}</td>	
                                  <td>{{$item->item_unit}}</td>
                                  <td>{{$item->created_at}}</td>
                                  <td>
                                  <div class="actions">
                                           <form action="{{route('StockFilter')}}" method="get">

                                            <input type="text" value="{{$item->id}}" name="item_id" hidden>

                                            <input type="text" name="item_id" value="{{$item->id}}" hidden>
                                                <input type="date" class="form-control" name="start_date" hidden value="{{request('start_date')}}" max="{{$dayClose->day_close}}">
                                                <input type="date" class="form-control" name="end_date" hidden value="{{request('end_date')}}" max="{{$dayClose->day_close}}">

                                            <button class="btn btn-outline-light btn-sm" title="" data-original-title="Edit">
                                             <i class="icon-book"></i>   History
                                            </button>

                                           </form>
                                           
									</div>
                                  </td>
                                </tr>
                               @endforeach
                               @endforeach
                            </tbody>
                        </table>
                        </div>
                        </div>
                       
                       
                    </div>
                </div>

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->




@endsection