@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">
    <form action="{{route('reloadLedger')}}" id="loadopening" method="get" hidden>
                            <input type="date" value="{{empty(request('start_date')) ? $dayClose->day_close : request('start_date')}}" name="date">
                        </form>

                        <form action="{{route('HiddenItems')}}" id="hiddenItems" method="get" hidden>
                            <input type="date" value="{{empty(request('start_date')) ? $dayClose->day_close : request('start_date')}}" name="date">
                        </form>
        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item">Item stock ledger</li>
                       
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">   
        <!-- Top Actions - DateRange and Buttons -->
    
        <form action="{{route('IslTemporal')}}" method="get">
            <div class="d-flex justify-content-end">
                @if(!empty(request('station')))
                    <input type="text" value="{{request('station')}}" name="station" hidden>
                @endif
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <div style="margin-right:10px"><small>From</small></div>
                    <input type="date" class="form-control" name="start_date" id="start" max="{{$dayClose->day_close}}" value="{{empty(request('start_date')) ? $dayClose->day_close : request('start_date')}}">
                    <div style="margin-right:10px; margin-left:10px"><small>to</small></div>
                    <input type="date" class="form-control" name="end_date" id="end" max="{{$dayClose->day_close}}" value="{{empty(request('start_date')) ? $dayClose->day_close : request('end_date')}}">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-eye1"></i>Show</button>
                        <button type="button" onclick="BuildReport()" class="btn btn-outline-primary"><i class="icon-grid"></i>Build Summary</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
                
            </div>
        </form>
        </div>
        </div>
    </div>
    <!-- Breadcrumb container end -->


<!-- Row start -->
<div class="row">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-body">

            <div class="alert alert-light alert-dismissible fade show" role="alert">
            It's a record-keeping document used to track the inflow and outflow of specific items or products within an organization. It provides a detailed account of the transactions and movements related to a particular item's stock, capturing information such as quantities, dates, sources, and destinations.
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>

                <div class="custom-tabs-container">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="first-tab" data-bs-toggle="tab" href="#first" role="tab" aria-controls="first" aria-selected="true">ISL - {{empty(request('station')) ? auth()->user()->station : request('station')}}</a>
                        </li>
                    </ul>
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="first" role="tabpanel">

                        <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#staticBackdrop" style="margin-bottom:12px">Built Reports</button>
                        
                        <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                <thead>
                                    <tr>
                                        <th>Item</th>
                                        <th>Category</th>
                                        <th>UOM</th>
                                        <th>CreatedAt</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach($items->chunk(100) as $row)
                                @foreach($row as $item)
                                @if(in_array(empty(request('station')) ? auth()->user()->station : request('station'), json_decode($item->inactive_station)) == true)
                                    @continue
                                @endif
                               
                                <tr>
                                  <td>
                                      <div class="media-box">
                                          <div class="media-box-body">
                                              <a href="#" class="text-truncate">{{@ucwords(@strtolower($item->item_name))}}</a>
                                              <p>{{$item->item_code}}</p>
                                          </div>
                                      </div>
                                  </td>
                                  <td>{{@ucwords(@strtolower($item->item_category))}}</td>	
                                  <td>{{$item->item_unit}}</td>
                                  <td>{{$item->created_at}}</td>
                                  <td>
                                  <div class="actions">

                                  @if(!empty(request('start_date')))
                                  <div class="actions">
                                           <form action="{{route('StockFilter')}}" method="get">

                                            <input type="text" value="{{$item->id}}" name="item_id" hidden>

                                            <input type="text" name="item_id" value="{{$item->id}}" hidden>
                                                <input type="date" class="form-control" name="start_date" hidden value="{{request('start_date')}}" max="{{$dayClose->day_close}}">
                                                <input type="date" class="form-control" name="end_date" hidden value="{{request('end_date')}}" max="{{$dayClose->day_close}}">

                                            <button class="btn btn-outline-light btn-sm" title="" data-original-title="Edit">
                                             <i class="icon-book"></i>   History
                                            </button>

                                           </form>
                                           
									</div>

                                  @else
                                           <form action="{{route('viewStockTransaction')}}" method="get">

                                            <input type="text" value="{{$item->id}}" name="item_id" hidden>

                                            <button class="btn btn-outline-light btn-sm" title="" data-original-title="Edit">
                                                <i class="icon-book"></i>   History
                                            </button>

                                           </form>
                                           
									</div>
                                    @endif
                                  </td>
                                </tr>
                               @endforeach
                               @endforeach
                            </tbody>
                        </table>
                        </div>

                        </div>
                       
                       
                    </div>
                </div>

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->



<!-- Modal start -->
<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="staticBackdropLabel">Built ISL Reports</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
        <ul class="list-group m-0" id="loadList">
            @foreach($builtReport as $builts)
            <li class="list-group-item d-flex justify-content-between align-items-center">
                Built Detailed Item Stock Ledger Report <br>
                Report date: {{$builts->date}} <br>
                Updated at: {{$builts->updated_at}}
                <span>
                    <form action="{{route('generateBuiltReport')}}" method="get">
                        <input type="text" value="{{encrypt($builts->date)}}" name="date" hidden>
                        <button class="btn btn-defalut"><i class="icon-eye1"></i></button>
                    </form>
                </span>
            </li>
            @endforeach
        </ul>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->


<script>
    function LoadeReopen(params) {
        document.getElementById("loadopening").submit();
    }


    function ShowHidden(params) {
        document.getElementById("hiddenItems").submit();
    }
</script>


<script>
function BuildReport() {
    var date = document.getElementById('start').value;


    let timerInterval
    Swal.fire({
    title: 'Report Builder In Progress!',
    html: 'Please hold on! <b></b> You will be notified  after completions.',
    timer: 3000,
    timerProgressBar: true,
    didOpen: () => {
        Swal.showLoading()
        const b = Swal.getHtmlContainer().querySelector('b')
        timerInterval = setInterval(() => {
        b.textContent = Swal.getTimerLeft()
        }, 100)
    },
    willClose: () => {
        clearInterval(timerInterval)
    }
    }).then((result) => {
    /* Read more about handling dismissals below */
    if (result.dismiss === Swal.DismissReason.timer) {
        console.log('I was closed by the timer')
    }
    })


    const xhttp = new XMLHttpRequest();
    xhttp.onload = function() {

        if (this.responseText == 200) {
            const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
            })

            Toast.fire({
            icon: 'success',
            title: 'Report Built Successfully'
            })

            $("#loadList").load(" #loadList");

        }else{
            console.log("failed")
        }
    }
    xhttp.open("GET", "/dashboard/build-report?date=" + date);
    xhttp.send();
}
</script>


@endsection