@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Tax Report</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('stockLedgerSort')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
            </div>
        </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


    <!-- Card start -->
    <div class="card">
        <div class="card-header">
            <div class="card-title">Expenses List</div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="copy-print-csv" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Expenses Type</th>
                        <th>Paid to</th>
                        <th>Amount paid</th>
                        <th>Reference</th>
                        <th>Payment Account</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($expenses_today as $expenses_today)
                        <tr>
                            <td>{{$expenses_today->e_type}}
                                <p><a href="" style="text-decoration:underline">Attchad Document</a></p>
                            </td>
                            <td>{{$expenses_today->e_paid_to}}</td>
                            <td>{{$expenses_today->e_amount}}</td>
                            <td>{{$expenses_today->e_reference}}</td>
                            <td>{{$expenses_today->payment_account}}</td>
                            <td>
                            <div class="actions">
                                <a href="#" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                    <i class="icon-edit1 text-info"></i>
                                </a>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-x-circle text-danger"></i>
                                </a>
                            </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
            </table>
            </div>
        </div>
    </div>
    <!-- Card end -->


                          

</div>
<!-- Content wrapper end -->


@endsection