<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>Tax Report - {{request()->date == null ? $dayClose->day_close : request()->date}}</title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">

        <!-- fontAwesome -->
        <link href="{{asset('assets/fontawesome/css/all.css')}}" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


        <script src="{{asset('assets/js/ajax.min.js')}}"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">
	</head>

    <style>
         @media print {
                #back{
                    visibility: hidden;
                }
            }
    </style>

<body onload="window.print();">

<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
            <a href="#" onclick="window.history.go(-1); return false" id="back" style="text-decoration:underline"><span class="badge bg-info">Return Back</span></a><br>
                <a href="#" class="logo">
                    <img src="/assets/img/{{$app->app_logo}}" alt="logo" style="max-width:70px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: {{auth()->user()->name}} <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0" style="width:70%">
                    <strong>{{$app->app_name}}</strong>,<br>
                    Tax Summary<br> 
                    OUTLET: <strong>{{empty(request('branch')) ? "ALL OUTLETS" : request('branch')}}</strong><br>
                </address>

                <div class="invoice-num">
                    <div>Report Date</div>
                    <div> {{request()->date == null ? $dayClose->day_close : request()->date}}</div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->


	<div class="table-container light-blue">
	<table class="table v-middle m-0">
        <thead>
        <tr>
            <th>Outlets</th>
            <th>Sales Excl. Tax <br> {{empty($app->currency) ? "GHS" : $app->currency}}</th>
            <th>NHIL Levy <strong>({{ $mTaxes->nhil * 100}}%)</strong></th>
            <th>Covid Levy <strong>({{ $mTaxes->covid * 100}}%)</strong></th>
            <th>Getfund Levy <strong>({{$mTaxes->getfund * 100}}%)</strong></th>
            <th>Tourism Levy <strong>({{$mTaxes->tourism * 100}}%)</strong></th>
            <th>VAT <strong>({{$mTaxes->vat*100}}%)</strong></th>
            <th>Total Tax</th>
        </tr>
        </thead>
        <tbody>
        
            @foreach($summary as $report)
            <tr>
                <td>{{$report->branch}}</td>
                <td>@convert( $vat_exclusive = (($report->total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat)) ))</td>
                <td> @convert( $NHIL_ = ($report->total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->nhil)</td>
                <td> @convert( $COVID_ = ($report->total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->covid)</td>
                <td> @convert( $GETFUND_ = ($report->total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->getfund)</td>
                <td> @convert( $TOURISM_ = ($report->total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->tourism)</td>
                <td> @convert( $VAT_ = ($vat_exclusive+$NHIL_+$COVID_+ $GETFUND_+$TOURISM_) * $mTax->vat)</td>
                <td> @convert( $VAT_+$NHIL_+$COVID_+ $GETFUND_+$TOURISM_)</td>
            </tr>
            @endforeach
            <tr>
                <td><strong>Grand Total</strong></td>
                <td> <span class="text-primary">@convert( $vat_exclusive_ = ($t_tax = ($total_sale)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat)) ))</span></td>
                <td> <span class="text-primary">@convert( $NHIL_ = ($total_sale)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->nhil)</span></td>
                <td><span class="text-primary"> @convert( $COVID_ = ($total_sale)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->covid)</span></td>
                <td> <span class="text-primary"> @convert( $GETFUND_ = ($total_sale)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->getfund)</span></td>
                <td> <span class="text-primary">@convert( $TOURISM_ = ($total_sale)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->tourism)</span></td>
                <td> <span class="text-primary">@convert( $VAT_ = ($vat_exclusive_+$NHIL_+$COVID_+ $GETFUND_+$TOURISM_) * $mTax->vat)</span></td>
                <td> <span class="text-primary">@convert( $VAT_+$NHIL_+$COVID_+ $GETFUND_+$TOURISM_)</span></td>
            </tr>
        </tbody>
	</table>
    </div>
</div>
</div>
</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('assets/js/jquery.min.js')}}"></script>
		<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('assets/js/modernizr.js')}}"></script>
		<script src="{{asset('assets/js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('assets/vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('assets/vendor/megamenu/js/custom.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>

		<!-- Apex Charts -->
		<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/salesGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/ordersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/earningsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/visitorsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/customersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('assets/vendor/circliful/circliful.custom.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>

		<!-- Dropzone JS -->
		<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('assets/js/main.js')}}"></script>

	</body>

</html>
