@extends('layouts.app')

@section('content')

	<!-- Content wrapper start -->
    <div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-header-lg">
                <h4>Authorize Quantity</h4>
                
            </div>
            <div class="card-body">

                <div class="invoice-container">

                    <div class="invoice-header">
                        <!-- Row start -->
                        <div class="row justify-content-between">
                            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                                <p>Voucher Information</p>
                            </div>
                        </div>
                        <!-- Row end -->
                    </div>

                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="invoice-details">
                                <address class="m-0">
                                    <strong>Voucher From:</strong><br>
                                    {{$details->station}}<br>
                                    <strong>by</strong> <strong style="font-weight:500">{{@ucwords(@strtolower($details->name))}}</strong>
                                </address>

                                <div class="invoice-num">
                                    <div>{{$details->issue_store}}</div>
                                    <div>Voucher No. - #{{$details->issue_transaction_id}} 
                                        <input type="text" value="{{$details->issue_transaction_id}}" id="transact" hidden>
                                    </div>
                                    <div>{{$details->issue_date}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Row end -->
                    <?php $check = DB::table('issue_lists')->where('transaction_no', $details->issue_transaction_id)->first() ?>
                    <form action="{{route('AcceptVoucherAdmin')}}" method="POST" id="authorizestock">
                        <input type="text" value="{{$details->issue_transaction_id}}" name="trans_id" hidden>
                        @csrf
                        <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-12">
                            
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Items</th>
                                            <th>Quantity Transfered</th>
                                            <th>Unit</th>
                                            <th>Authorize Qty</th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($voucher as $req)
                                        <tr>
                                            <td>
                                                <p>{{$req->issue_item}}</p>
                                            </td>
                                            <td>
                                             {{$req->issue_quantity}}
                                            </td>
                                        
                                            <td>{{$req->issue_unit}}</td>
                                            <td>
                                            @if($details->authorize_state == 1)
                                            <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_qty]" value="{{$req->authorize_qty}}">
                                            <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_date]" value="{{$req->issue_date}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_station]" value="{{$req->issue_store}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_recieved_station]" value="{{$req->station}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_item_id]" value="{{$req->issue_item_id}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_unit]" value="{{$req->issue_unit}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_item]" value="{{$req->issue_item}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_rate]" value="{{round($req->issue_rate,2)}}" hidden>
                                            @else
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_qty]" value="{{$req->issue_quantity}}">
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_date]" value="{{$req->issue_date}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_station]" value="{{$req->issue_store}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_recieved_station]" value="{{$req->station}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_item_id]" value="{{$req->issue_item_id}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_unit]" value="{{$req->issue_unit}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_item]" value="{{$req->issue_item}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_rate]" value="{{round($req->issue_rate,2)}}" hidden>
                                            @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                    <!-- Row end -->
                    

                    <!-- Row start -->
                    <div class="row gutters">

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="text-start">
                            @if($check->authorize_status == 1)
                            <button type="button" disabled class="btn btn-success"> <i class="icon-check2" aria-hidden="true"></i> Approved</button>
                            @else
                                <button type="button" class="btn btn-outline-primary" onclick="approve()"> <i class="icon-check2" aria-hidden="true"></i> Authorize</button>
                                <input type="submit" class="btn btn-outline-danger" value="Reject Voucher" name="reject">
                                @endif
                                <a href="{{route('PrintV', $details->issue_transaction_id)}}" class="btn btn-outline-primary ms-1"> <i class="icon-printer"></i> Print</a>
                            </div>
                        </div>

                    </div>
                    <!-- Row end -->

                    </form>
                
                </div>

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->


<script>
    function approve() {
        Swal.fire({
            title: 'Are you sure?',
            text: "you are authorizing an issued voucher, you may not be able to revert!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, authorize!'
            }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById("authorizestock").submit();
            }
            })
    }
</script> 



<script>
    function makeChanges() {
        Swal.fire({
            title: 'Are you sure?',
            text: "Do you want to make changes in your Requistion!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Make Change it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/request/make-change-requestion/" + document.getElementById('transact').value;
            }
            })
    }
</script>


@endsection