@extends('layouts.app')

@section('content')

	<!-- Content wrapper start -->
    <div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-header-lg">
                <h4>Authorize Quantity</h4>
                <div class="text-end">
                    <a href="#" class="btn btn-primary">New Voucher</a>
                </div>
            </div>
            <div class="card-body">

                <div class="invoice-container">

                    <div class="invoice-header">
                        <!-- Row start -->
                        <div class="row justify-content-between">
                            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                                <p>Voucher Information</p>
                            </div>
                        </div>
                        <!-- Row end -->
                    </div>

                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="invoice-details">
                                <address class="m-0">
                                    <strong>Voucher From:</strong><br>
                                    {{$details->station}}<br>
                                    BY: <strong>{{$details->name}}</strong>
                                </address>

                                <div class="invoice-num">
                                    <div>{{$details->issue_store}}</div>
                                    <div>Voucher No. - #{{$details->issue_transaction_id}} 
                                        <input type="text" value="{{$details->issue_transaction_id}}" id="transact" hidden>
                                    </div>
                                    <div>{{$details->issue_date}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Row end -->

                    <form action="{{route('AcceptVoucher')}}" method="POST">
                        @csrf
                        <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-12">
                            
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Items</th>
                                            <th>Quantity</th>
                                            @if($details->id !== auth()->user()->id)
                                            <th>Stock In Hand</th>
                                            @endif
                                            <th>Unit</th>
                                            @if($details->id !== auth()->user()->id)
                                            <th>Authorize Qty</th>
                                            <th>Issue Qty</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($voucher as $req)
                                        <tr>
                                            <td>
                                                <p>{{$req->issue_item}}</p>
                                            </td>
                                            <td>
                                             {{$req->issue_quantity}}
                                            </td>
                                            @if($details->id !== auth()->user()->id)
                                            <td>
                                            0.00
                                            </td>
                                            @endif
                                            <td>{{$req->issue_unit}}</td>
                                            @if($details->id !== auth()->user()->id)
                                            <td>
                                                {{$req->authorize_qty}}
                                            </td>
                                            <td>
                                            @if($details->issue_status == 1)
                                            <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_qty]" value="{{$req->issue_quantity}}" disabled>
                                            @else
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_qty]" value="{{$req->issue_quantity}}">
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_date]" value="{{$req->issue_date}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_station]" value="{{$req->issue_store}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_recieved_station]" value="{{$req->station}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_item_id]" value="{{$req->issue_item_id}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_unit]" value="{{$req->issue_unit}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_item]" value="{{$req->issue_item}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_rate]" value="{{$req->issue_rate}}" hidden>
                                            @endif
                                            </td>
                                            @endif
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                    <!-- Row end -->
                    

                    <!-- Row start -->
                    <div class="row gutters">

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="text-start">
                                @if($details->issue_status == 1)
                                <button type="button" class="btn btn-danger"> <i class="fa fa-check" aria-hidden="true"></i> Authorized</button>
                                @else
                                @if($details->id !== auth()->user()->id)
                                <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#exampleModalSmallVoucherAccept">Authorize Voucher</button>
                                @if($details->id == auth()->user()->id)
                                <button class="btn btn-primary ms-1" type="button"  onClick="makeChanges()">Make Changes</button>
                                @endif
                                @endif
                                @endif
                                <button type="button" class="btn btn-light ms-1">Print</button>
                            </div>
                        </div>

                    </div>
                    <!-- Row end -->

                    </form>
                
                </div>

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->



<script>
    function makeChanges() {
        Swal.fire({
            title: 'Are you sure?',
            text: "Do you want to make changes in your Requistion!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Make Change it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/request/make-change-requestion/" + document.getElementById('transact').value;
            }
            })
    }
</script>


@endsection