@extends('layouts.app')

@section('content')

        <!-- Content wrapper start -->
        <div class="content-wrapper">
                <form id="satellite">
                @csrf

                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

                        <!-- Card start -->
                        <div class="card">
                            <div class="card-header-lg">
                                <h4>Issue Voucher</h4>
                                <div class="text-end">
                                    <a href="{{route('voucherIncoming')}}" class="btn btn-outline-danger">Incoming Voucher</a>
                                    <a href="{{route('voucherList')}}" class="btn btn-outline-light">Issued Voucher</a>
                                </div>
                            </div>
                            
            <div class="card-body">
            <div class="alert alert-light alert-dismissible fade show" role="alert">
            It's a record used to document the issuance or allocation of inventory items or materials from the stock. It is typically used when items need to be taken out of the stock for various purposes such as sales, internal transfers, or consumption within the organization.
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
               <!-- Row start -->
                <div class="row justify-content-between">

                <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">

                    <!-- Row start -->
                    <div class="row gutters">

                        <div class="col-12">
                            <div class="form-section-header light-bg">Voucher Information</div>
                        </div>
                        <div class="col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" name="r_store" value="{{session()->get('issue_to')}}" readonly>
                                <div class="field-placeholder">Store <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                        <div class="col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">
                                    <input type="text" class="form-control" required readonly name="r_date" value="{{session()->get('issue_date')}}">
                                </div>
                                <div class="field-placeholder">Date<span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                    </div>
                    <!-- Row end -->

                </div>
                <div class="col-xl-5 col-lg-5 col-md-7 col-sm-7 col-12">

                    <!-- Row start -->
                    <div class="row gutters">

                        <div class="col-12">
                            <div class="form-section-header light-bg">Item Information</div>
                        </div>
                        
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <select class="select-single js-states" name="r_item" title="Select Term" data-live-search="true">
                                   <option disabled selected>- Select Item -</option>
                                    @foreach($item_issues as $item)
                                    <option value="{{$item -> item_name}} - {{$item -> id}}">{{@ucwords(@strtolower($item->item_name))}}</option>
                                    @endforeach
                                </select>
                                <div class="field-placeholder">Item <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">
                                    <input type="number" class="form-control" name="r_quantity" id="qty" step="0.001" required>
                                </div>
                                <div class="field-placeholder">Quantity <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <select id="unit-listing" class="select-single js-states" title="Select Term" name="r_unit" data-live-search="true">
                                    <option disabled selected>Use Default Unit</option>
                                    @foreach($units as $unit)
                                    <option>{{$unit -> abbreviation}}</option>
                                    @endforeach
                                </select>
                                <div class="field-placeholder">UOM</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                    </div>
                    <!-- Row end -->

                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <button class="btn btn-outline-primary"><i class="icon-shopping-cart1" aria-hidden="true"></i> Add to Cart</button> 
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                </div>

                </div>
                <!-- Row end -->
              </form>
                
                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-12" id="tabler">
                    @if(empty(session()->get('cart_voucher')))
                    <!-- Card start -->
                    <div class="card">
                        <div class="card-body">
                            <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                    No item added to cart. Kindly select Item and add to cart
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                            
                        </div>
                    </div>
                    <!-- Card end -->
                    @else  
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th colspan="7" class="pt-3 pb-3">Item Details</th>
                                    </tr>
                                    <tr>
                                        <th>Sr#</th>
                                        <th>Item Name</th>
                                        <th>Quantity</th>
                                        <th>Rate</th>
                                        <th>Unit</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach(session()->get('cart_voucher') as $re)
                                    <tr>
                                        <td>{{$re['id']}}</td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <select class="select-single js-states w-100" data-live-search="true">
                                                    <option>{{@ucwords(@strtolower($re['issue_item']))}}</option>
                                                </select>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" readonly value="@convert($re['issue_quantity'])" class="form-control" placeholder="Qty">
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" readonly value="@convert($re['issue_rate'])" class="form-control" placeholder="Rate">
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" value="{{$re['issue_unit']}}" class="form-control" readonly>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                       
                                        <td>
                                            <div class="table-actions">
                                                <button type="button" id="{{$re['id']}}" class="btn btn-outline-light" onclick="DeleteVoucher(this.id)">
                                                    <i class="icon-trash-2"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                
                                </tbody>
                            </table>
                        </div>
                    @endif
                    <div class="row gutters">
                        <textarea class="form-control" onchange="editNote()" name="r_note" id="noteText" cols="30" rows="4" name="r_note" placeholder="Memo here"></textarea>
                    </div>
                    </div>
                </div>
                <!-- Row end -->

                <!-- Row start -->
                <div class="row gutters">

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="form-actions-footer">
                            <div class="text-end">
                                <button type="button" class="btn btn-outline-primary" onclick="confirmReceiptPrint()">Save & Print</button>
                                <!-- <button type="button" class="btn btn-primary ms-1" onclick="confirmIssue()">Save</button> -->
                                <button type="button" class="btn btn-danger ms-1" onclick="confirmClose()">Close</button>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- Row end -->

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->



<script>
     $("#satellite").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('issuevocher.store')}}",
                dataType: "json",
                data: $('#satellite').serialize(),
                success: function(data){
                    $("#tabler").load(" #tabler");
                    document.getElementById('unit-listing').value = "";
                    document.getElementById('qty').value = "";
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Added to Cart, add new Item'
                    })

                    

                    if (data[0] === 1) {
                        Swal.fire({
                        icon: 'error',
                        title: 'Out of stock...',
                        text: 'Sorry, the Stock Level is low ',
                        footer:  'Something went wrong!'
                        })
                    }
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>' + data[0]
                    })
                }
            });
        });


        function editNote() {
            var note = document.getElementById('noteText').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/dashboard/customer-note/" + note);
            xhttp.send();
        }



    function DeleteVoucher(id) {
        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $("#tabler").load(" #tabler");
            }
            xhttp.open("GET", "/dashboard/voucher/delete-voucher/"+id);
            xhttp.send();
    }


        function confirmIssue() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('saveIssueVoucher')}}";
            }
            })
    }


    function confirmReceiptPrint(){
        Swal.fire({
            title: 'Are you sure?',
            text: "you are making stock transfer, You may be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/make-transfer/save-print";
            }
            })
    }



    function confirmClose() {
        Swal.fire({
            title: 'Are you sure?',
            text: "you are voiding this voucher, you can't revert",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, void!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('clearVoucher')}}";
            }
            })
    }
</script>

@endsection