@extends('layouts.app')

@section('content')

	<!-- Content wrapper start -->
    <div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-header-lg">
                <h4>Authorize Quantity</h4>
                @if($v_list->issue_status == 1)
                <div class="text-end">
                    <a href="#" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#exampleModalLong">Restore Rejected</a>
                    @include('modal.rejected-item')
                </div>
                @endif
            </div>
            <div class="card-body">

                <div class="invoice-container">

                    <div class="invoice-header">
                        <!-- Row start -->
                        <div class="row justify-content-between">
                            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                                <p>Voucher Information</p>
                            </div>
                        </div>
                        <!-- Row end -->
                    </div>

                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="invoice-details">
                                <address class="m-0">
                                    <strong>Voucher From:</strong><br>
                                    {{@ucwords(@strtolower($details->station))}}<br>
                                    <strong>by</strong> <strong style="font-weight:400">{{@ucwords(@strtolower($details->name))}}</strong>
                                </address>

                                <div class="invoice-num">
                                    <div>{{@ucwords(@strtolower($details->issue_store))}}</div>
                                    <div>Voucher No. - #{{$details->issue_transaction_id}} 
                                        <input type="text" value="{{$details->issue_transaction_id}}" id="transact" hidden>
                                    </div>
                                    <div>{{$details->issue_date}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Row end -->
                    <?php $issue = \DB::table('issue_lists')->where('transaction_no', $details->issue_transaction_id)->first() ?>
                    <form action="{{route('AcceptVoucher')}}" id="voucher" method="POST">
                    <input type="hidden" name="date" value="{{$details->issue_date}}">
                        @csrf
                        <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-12">
                            
                            <div class="table-responsive">
                                <table class="table table-bordered" id="original">
                                    <thead>
                                        <tr>
                                            <th>Items</th>
                                            <th>Quantity</th>
                                            <th>Unit</th>
                                            @if($details->id !== auth()->user()->id)
                                            <th>Authorize Qty</th>
                                            <th>Issue Qty</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($voucher as $req)
                                        <tr>
                                            <td>
                                                <p>{{@ucwords(@strtolower($req->issue_item))}}</p>
                                            </td>
                                            <td>
                                             {{$req->issue_quantity}}
                                            </td>
                                            <td>{{$req->issue_unit}}</td>
                                            @if($details->id !== auth()->user()->id)
                                            <td>
                                                {{(float)$req->authorize_qty}}
                                            </td>
                                            <td>
                                            @if($details->issue_status == 1)
                                            <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_qty]" value="{{$req->issue_quantity}}" readonly>
                                            <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_date]" value="{{$req->issue_date}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_station]" value="{{$req->issue_store}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_recieved_station]" value="{{$req->station}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_item_id]" value="{{$req->issue_item_id}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_unit]" value="{{$req->issue_unit}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_item]" value="{{$req->issue_item}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_rate]" value="{{$req->issue_rate}}" hidden>
                                            @else
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_qty]" value="{{$req->issue_quantity}}" readonly>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_date]" value="{{$req->issue_date}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_station]" value="{{$req->issue_store}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_recieved_station]" value="{{$req->station}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_item_id]" value="{{$req->issue_item_id}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_unit]" value="{{$req->issue_unit}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_item]" value="{{$req->issue_item}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_rate]" value="{{$req->issue_rate}}" hidden>
                                            @endif
                                            </td>
                                            
                                            <td>
                                            @if($v_list->issue_status == 1)<span class="badge bg-primary"> Accepted</span>@else
                                                <button type="button" onclick="removeItem(this.id)" id="{{$req->id}}" class="btn btn-outline-light btn-sm" title="Remove item from list"> <i class="icon-cancel"></i></button>
                                             @endif
                                            </td>
                                            
                                            @endif
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                    <!-- Row end -->
                    

                    <!-- Row start -->
                    <div class="row gutters">

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="text-start">
                                @if($v_list->issue_status == 1)
                                <button type="button" class="btn btn-outline-danger" disabled> <i class="icon-check1" aria-hidden="true"></i> Accepted</button>
                                @else
                                @if($details->id !== auth()->user()->id)
                                
                                @if($issue->issue_status == 0)
                                <button class="btn btn-outline-danger" type="button" disabled> <i class="icon-cancel"></i> Reject Issue</button>
                                @else
                                <button class="btn btn-outline-primary" type="button" onclick="AcceptVoucher()"> <i class="icon-check2"></i> Accept Issue</button>
                                <button class="btn btn-outline-danger" type="button" onclick="RejectVoucher()"> <i class="icon-cancel"></i> Reject Issue</button>
                                @endif
                                @endif
                                @endif


                                <a style="float:right" href="/dashboard/print-voucher-new/{{$details->issue_transaction_id}}" class="btn btn-outline-primary ms-1">
                                    <i class="icon-print"></i>
                                    Print</a>
                                @if(auth()->user()->role == "Administrator")
                                @if($v_list->issue_status == 1)
                                    <button type="button" id="{{$details->issue_transaction_id}}" onclick="ReverseTransaction(this.id)" class="btn btn-outline-info">Reverse Transaction</button>
                                @endif
                                @endif
                            </div>
                        </div>

                    </div>
                    <!-- Row end -->

                    <input type="hidden" value="{{$details->issue_transaction_id}}" name="transaction_no">
                    <input type="text" value="" name="status" id="status" hidden>
                   

                    </form>
                
                </div>

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->



<script>
    function makeChanges() {
        Swal.fire({
            title: 'Are you sure?',
            text: "Do you want to make changes in your Requistion!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Make Change it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/make-change-voucher/" + document.getElementById('transact').value;
            }
            })
    }



        function AcceptVoucher() {
            Swal.fire({
                title: 'Are you sure?',
                text: "By accepting voucher, you agree that stock have been issued to you!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Accept !'
                }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("voucher").submit();
                }
                })
        }


        function AcceptVoucher() {
            document.getElementById('status').value = 1;
            Swal.fire({
                title: 'Are you sure?',
                text: "By accepting voucher, you agree that stock have been issued to you!",
                icon: 'info',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Accept !'
                }).then((result) => {
                if (result.isConfirmed) {

                    document.getElementById("voucher").submit();
                }
                })
        }

        function RejectVoucher() {
            document.getElementById('status').value = 0;
            Swal.fire({
                title: 'Are you sure?',
                text: "By Rejecting voucher, You are will return stock!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Accept !'
                }).then((result) => {
                if (result.isConfirmed) {

                    document.getElementById("voucher").submit();
                }
                })
        }



    function removeItem(data) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Reject Item !'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/voucher/reject/"+ data;
            }
            })
    }


    function ReverseTransaction(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "Do you want to reverse this transaction!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, reverse !'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/voucher/reverse-transaction/"+ id;
            }
            })
    }

                  

</script>


@endsection