@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">


<!-- Breadcrumb container start -->
<div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="/">Home</a></li>
              <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
              <li class="breadcrumb-item"><a href="#">Voucher</a></li>
              @if(Route::currentRouteName() == "voucherIncoming")
              <li class="breadcrumb-item active" aria-current="page">Incoming Voucher</li>
              @else
              <li class="breadcrumb-item active" aria-current="page">Outgoing Voucher</li>
              @endif
            </ol>
        </nav>
    </div>


    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
            <!-- Top Actions - DateRange and Buttons -->
            @if(Route::currentRouteName() == "voucherIncoming")
            <form action="{{route('getIncomingVoucherReport')}}" method="get">
            @else
            <form action="{{route('getOutgoingVoucherReport')}}" method="get">
            @endif
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    @if(Route::currentRouteName() == "voucherIncoming")
                    <a href="{{route('voucherList')}}" class="btn btn-outline-primary">Issued Vouchers</a>
                    @else
                    <a href="{{route('voucherIncoming')}}" class="btn btn-outline-primary">Incoming Vouchers</a>
                    @endif
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-download1"></i>Reports</button>

                    </div>
                </div>
                <!-- Field wrapper end -->
            </div>
            </form>
        </div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->


<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <div class="card">
            <div class="card-body">
                
                <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                              <th>Trans. No.</th>
                              <th>Trans. Date</th>
                              @if(Route::currentRouteName() == "voucherIncoming")
                              <th>Transfer From</th>
                              @else
                              <th>Transfer to</th>
                              @endif													  
                              <th>By User</th>													  
                              <th>Status</th>
                              <th>Created at</th>
                              <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($lists as $list)
                            <tr>
                              <td>
                               #{{$list->transaction_no}}
                              </td>
                              <td>
                                {{$list->issue_date}}
                              </td>
                              <td>
                              @if(Route::currentRouteName() == "voucherIncoming")
                              {{$list->issue_from}}
                              @else
                              {{$list->issue_to}}
                              @endif
                              </td>													  
                              <td>{{$list->name}}</td>
                              <td>
                                  @if($list->issue_status == 0)
                                  <span class="badge bg-success"> Rejected </span>
                                  @elseif($list->issue_status == 1)
                                  <span class="badge bg-danger"> Accepted </span>
                                  @else
                                  <span class="badge bg-info"> Pending </span>
                                  @endif
                              </td>
                              <td>
                              <?php $comment = \DB::table('issue_lists')->where('transaction_no',$list->transaction_no)->first() ?>
                              {{$comment->created_at}}
                              </td>
                              <td>
                              <div class="actions">
                                      <a href="{{route('viewVoucher', $list->transaction_no)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                          <i class="icon-edit1 text-info"></i>
                                      </a>
                                  </div>
                              </td>
                            </tr>
                            @endforeach
                        </tbody>
                </table>
                </div>

            </div>
        </div>

    </div>
</div>
<!-- Row end -->
@include('modal.voucher-modal')
</div>
<!-- Content wrapper end -->


@endsection