@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">


    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="/dashboard">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Incoming Voucher</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
            <!-- Top Actions - DateRange and Buttons -->
            <form action="{{route('getIncomingVoucherReport')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-download1"></i> Reports</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
            </div>
            </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12">
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">Incoming Vouchers</div>
            </div>
            
            <div style="margin-left:20px; margin-top:12px">
                Date: <em>{{request()->date}}</em> , Outlet: <?= auth()->user()->station?>
            </div>
            
            <div class="card-body">
            <form action="{{route('save.wastage')}}" method="POST">
                @csrf
            <div class="table-responsive table-sm">
                 <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                              <th>Trans. No.</th>
                              <th>Date</th>
                              <th>Transfer To</th>													  
                              <th>By User</th>													  
                              <th>Status</th>
                              <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($lists as $list)
                            <tr>
                              <td>
                               #{{$list->transaction_no}}
                              </td>
                              <td>
                                {{$list->issue_date}}
                              </td>
                              <td>
                              {{$list->issue_to}}
                              </td>													  
                              <td>{{$list->name}}</td>
                              <td>
                                  @if($list->issue_status == 0)
                                  <span class="badge bg-success"> Rejected </span>
                                  @elseif($list->issue_status == 1)
                                  <span class="badge bg-danger"> Approved </span>
                                  @else
                                  <span class="badge bg-info"> Pending </span>
                                  @endif
                              </td>
                              <td>
                              <div class="actions">
                                      <a href="{{route('viewVoucher', $list->transaction_no)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                          <i class="icon-edit1 text-info"></i>
                                      </a>
                                  </div>
                              </td>
                            </tr>
                            @endforeach
                        </tbody>
                </table>

            </div>
        </div>
</div>
        <!-- Card end -->
    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection