@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12"> 
            <div class="card">
            <div class="container" style="margin-top:30px">
                         <h5>ADMINISTRATORS</h5>
                    </div>
                <div class="card-body">
                    
                    <div class="table-responsive">
                    <table id="basicExample" class="table custom-table">
                            <thead>
                                <tr>
                                  <th>Name</th>
                                  <th>Outlet</th>
                                  <th>Category</th>
                                  <th>Role</th>
                                  <th>Email</th>	
                                  <th>Action</th>												  
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($admins as $users)
                                <tr>
                                  <td>{{@strtoupper($users->name)}}</td>
                                  <td>
                                      {{@strtoupper($users->branch)}}
                                  </td>
                                  <td>{{@strtoupper($users->sales_person_category)}}</td>
                                  <td>{{@strtoupper($users->role)}}</td>
                                    <td>{{$users->email}}</td>
                                  <td>
                                      <div class="actions">
                                          <a href="{{route('editUser', $users->id)}}">
                                              <i class="icon-edit1 text-info"></i>
                                          </a>

                                          <a href="#" data-toggle="tooltip" id="{{$users->id}}" onclick="deleteUser(this.id)" data-placement="top" title="" data-original-title="Delete">
                                              <i class="icon-x-circle text-danger"></i>
                                          </a>
                                      </div>
                                  </td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->




    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
            <div class="container" style="margin-top:30px">
                       <h5>OTHER USERS</h5>
                    </div>
                <div class="card-body">
                
                    <div class="table-responsive">
                        <table id="copy-print-csv" class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Name</th>
                                  <th>Branch</th>
                                  <th>Category</th>
                                  <th>Role</th>
                                  <th>Email</th>	
                                  <th>Action</th>												  
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($allusers as $user_)
                                <tr>
                                  <td>{{@strtoupper($user_->name)}}</td>
                                  <td>
                                      {{@strtoupper($user_->branch)}}
                                  </td>
                                  <td>{{@strtoupper($user_->sales_person_category)}}</td>
                                  <td>{{@strtoupper($user_->role)}}</td>
                                  <td>{{$user_->email}}</td>
                                  <td>
                                      <div class="actions">
                                      <a href="{{route('editUser', $user_->id)}}">
                                              <i class="icon-edit1 text-info"></i>
                                          </a>
                
                                          <a href="#" data-toggle="tooltip" id="{{$user_->id}}" onclick="deleteUser(this.id)" data-placement="top" title="" data-original-title="Delete">
                                              <i class="icon-x-circle text-danger"></i>
                                          </a>
                                      </div>
                                  </td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

    <script>
        function deleteUser(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "you are deleting a user, Yyou won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete!'
                }).then((result) => {
                if (result.isConfirmed) {
                    const xhttp = new XMLHttpRequest();
                    xhttp.onload = function() {
                        $("#copy-print-csv").load(" #copy-print-csv");
                        Swal.fire(
                            'Deleted!',
                            'Your file has been deleted.',
                            'success'
                            )
                    }
                    xhttp.open("GET", "/dashboard/users/delete-user/"+id);
                    xhttp.send();
                    }
                })
        }
    </script>

</div>
<!-- Content wrapper end -->

@endsection