@extends('layouts.app')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">New Vendor</div>
            </div>
            <div class="card-body mt-4">
                
                <form class="needs-validation" novalidate method="POST" action="{{route('vendor.store')}}">
                    @csrf
                <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="vendor_name" required>
                                <div class="field-placeholder">Name<span class="text-danger">*</span></div>
                                
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="vendor_tax_number" required value="-">
                                <div class="field-placeholder">Tax Number</div>
                                
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="email" class="form-control" name="vendor_email" required>
                                <div class="field-placeholder">Email</div>
                                
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="number" class="form-control" name="vendor_phone" required value="">
                                <div class="field-placeholder">Phone Number<span class="text-danger">*</span></div>
                                
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <textarea name="vendor_address" class="form-control" cols="30" rows="5"></textarea>
                                <div class="field-placeholder">Address</div>
                                
                            </div>
                            <!-- Field wrapper end -->

                        </div>
            
                        <div class="col-12">
                            <button class="btn btn-primary" type="submit">Save</button>
                        </div>
                    </div>
                    <!-- Row end -->
                </form>

            </div>
        </div>
        <!-- Card end -->
    </div>

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        
        <!-- Card start -->
        <div class="card" id="tabler">
            <div class="card-header">
                <div class="card-title">Vendors</div>
            </div>
            <div class="card-body mt-4">
                
            <div class="table-responsive">
                <table id="copy-print-csv" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Name</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($vendors as $vendor)
                        <tr>
                        <td>{{@ucwords(@strtolower($vendor->vendor_name))}}</td>
                        <td>
                        <div class="actions">
                        <a href="#" id="{{$vendor->id}}" onclick="DeleteVendor(this.id)" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-x-circle text-danger"></i>
                                </a>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-edit1 text-primary"></i>
                                </a>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-book text-primary"></i>
                                </a>
                        </div>
                        </td>
                        </tr>
                        @endforeach
                    </tbody>
            </table>
            </div>

            </div>
        </div>
        <!-- Card end -->

    </div>

</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->


<script>
    function DeleteVendor(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This Vendor will be removed from list",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete Vendor!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#tabler").load(" #tabler");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Vendor deleted successfully'
                    })
                }
                xhttp.open("GET", "/dashboard/vendors/delete-vendor/"+id);
                xhttp.send();
            }
            })
            
    }
</script>

@endsection