@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header-lg">
                    <h4>{{$records->purchase_type}}</h4>
                    <div class="text-end">
                        <a href="#" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#PurchaseInvoice"><i class="icon-plus"></i> New Purchase</a>
                    </div>
                </div>
                <div class="card-body">

                    <div class="invoice-container">


                        <!-- Row start -->
                        <div class="row gutters">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="invoice-details">
                                    <address class="m-0">
                                        <strong>VENDOR</strong><br>
                                        {{@ucwords(@strtolower($vendor->vendor_name))}}
                                    </address>

                                    <div class="invoice-num">
                                        <div>Trans. ID - #{{$trans_data->purchase_transaction_id}}</div>
                                        <div>{{$trans_data->purchase_date}}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Row end -->

                        <!-- Row start -->
                        <div class="row gutters">
                            <div class="col-12">
                                
                                <div class="table-responsive">
                                <table class="table table-bordered m-0">
                                        <thead>
                                            <tr>
                                                <th>Item</th>
                                                <th>Category</th>
                                                <th>Quantity</th>
                                                <th>Rate</th>
                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 

                                            $sumTotal = 0;

                                            ?>
                                            @foreach($reciept_goods as $goods)
                                            <?php  
                                            $sumTotal += round(round($goods->purchase_quantity,2) * round($goods->purchase_rate, 2), 2);
                                            $total = round($sumTotal, 2);
                                            ?>
                                            <tr>
                                                <td>{{@ucwords(@strtolower($goods->purchase_item))}}</td>
                                                <td>{{@ucwords(@strtolower($goods->purchase_category))}}</td>
                                                <td>@convert($qty = round($goods->purchase_quantity, 2)) {{$goods->purchase_unit}}</td>
                                                <td> @convert($rate = round($goods->purchase_rate, 2))</td>
                                                <td> @convert(round($qty * $rate, 2))</td>
                                            </tr>
                                            
                                            @endforeach
                                            <tr>
                                            <td colspan="3">&nbsp;</td>
                                            <td>
                                                <p class="m-0">Amount</p>
                                                <p class="m-0">Discount</p>
                                                <p class="m-0">VAT</p>
                                                <p class="m-0">Bill Amount</p>
                                                <p class="m-0">Amount Paid</p>
                                                <p class="mt-2 text-danger">Balance Due</p>
                                            </td>
                                            <td>
                                                <p class="m-0">{{empty($app->currency) ? GHS : $app->currency}}@convert($total)</p>
                                                <p class="m-0">{{empty($app->currency) ? GHS : $app->currency}}0.00</p>
                                                <p class="m-0">{{empty($app->currency) ? GHS : $app->currency}}0.00</p>
                                                <p class="m-0">{{empty($app->currency) ? GHS : $app->currency}}@convert($total)</p>
                                                <p class="m-0" style="text-decoration:underline">{{empty($app->currency) ? GHS : $app->currency}}@convert($records->purchase_amount_paid)</p>
                                                <p class="mt-2 text-danger">{{empty($app->currency) ? GHS : $app->currency}}@convert($total - $records->purchase_amount_paid)</p>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>
                        <!-- Row end -->

                        <!-- Row start -->
                        <div class="row gutters" style="margin-top:12px">

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="text-start">
                                    <a class="btn btn-outline-primary" href="{{route('downloadPrintPurchase', $trans_data->purchase_transaction_id)}}"> <i class="icon-print"></i> Print</a>
                                </div>
                            </div>

                        </div>
                        <!-- Row end -->
                    
                    </div>

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->

@endsection