@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-header-lg">
                <h4>Goods Reciept Note</h4>
                <div class="text-end">
                    <a href="{{route('showAll.goods')}}" class="btn btn-outline-primary">Report</a>
                </div>
            </div>
            <div class="card-body">

            <div class="alert alert-light alert-dismissible fade show" role="alert">
            It's a document used in stock management to acknowledge the receipt of goods or materials from a supplier or internal source. It serves as a formal record of the goods received and provides important information for inventory control and accounting purposes.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>

            <form id="greceipt">
                @csrf

                @if($checkReceipt == null)
                <input type="text" name="g_r_transaction_id" id="trans" hidden value="<?=  rand(5034,10034580)+rand(4580,10034580) . date("Yd") . date('Hi');?>">
                @else
                <input type="text" name="g_r_transaction_id" id="trans" hidden value="{{$checkReceipt -> g_r_transaction_id}}">
                @endif
                <!-- Row start -->
                <div class="row justify-content-between">

                    <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">

                        <!-- Row start -->
                        <div class="row gutters">

                            <div class="col-12">
                                <div class="form-section-header light-bg">Trans. Information</div>
                            </div>
                            <div class="col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                @if($checkReceipt == null)
                                <select class="select-single js-states" title="Select Term" data-live-search="true" name="g_r_vendor">
                                    <option disabled selected>Select Vendor</option>
                                    @foreach($vendors as $vendor)
                                    <option vaue="{{$vendor->vendor_name}}">{{@ucwords(@strtolower($vendor->vendor_name))}}</option>
                                    @endforeach
                                </select>
                                @else
                                <select class="select-single js-states" title="Select Term" data-live-search="true" name="g_r_vendor">
                                        <option selected>{{$checkReceipt->g_r_vendor}}</option>
                                </select>
                                @endif
                                    <div class="field-placeholder">Vendor<span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>
                            <div class="col-12">
                                 <!-- Field wrapper start -->
                                 <div class="field-wrapper">
                                    <div class="input-group">
                                        <input type="date" required class="form-control" name="g_r_date" disabled value="<?= $dayClose->day_close ?>">
                                    </div>
                                    <div class="field-placeholder">Date<span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>
                           

                        </div>
                        <!-- Row end -->

                    </div>
                    
                    <div class="col-xl-5 col-lg-5 col-md-7 col-sm-7 col-12">
                     
                        <!-- Row start -->
                        <div class="row gutters">

                        <div class="col-12">
                                <div class="form-section-header light-bg">Item Information</div>
                            </div>

                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <select class="select-single js-states" required name="g_r_item" title="Select Term" data-live-search="true">
                                       <option disabled selected>- Select Item - </option>
                                        @foreach($items as $item)
                                        <option value="{{$item -> id}}">{{@ucwords(@strtolower($item -> item_name))}}</option>
                                        @endforeach
                                    </select>
                                    <div class="field-placeholder">Item <span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>
                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">
                                        <input type="number" name="g_r_quantity" required class="form-control" id="qty" step="0.000001">
                                    </div>
                                    <div class="field-placeholder">Quantity<span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>


                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">
                                        <input type="number" name="g_r_rate" step="0.00001" id="rate" required class="form-control">
                                    </div>
                                    <div class="field-placeholder">Rate <span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>

                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <select id="unit-listing" name="g_r_unit" class="select-single js-states" title="Select Term" data-live-search="true">
                                        <option disabled selected>Use Default Unit</option>
                                        @foreach($units as $unit)
                                           <option>{{$unit -> abbreviation}}</option>
                                        @endforeach
                                    </select>
                                    <div class="field-placeholder">UOM</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>



                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                <button class="btn btn-outline-primary"><i class="icon-shopping-cart1" aria-hidden="true"></i> Add to Cart</button> 
                                </div>
                                <!-- Field wrapper end -->
                            </div>

                        </div>
                        <!-- Row end -->

                    </div>

                </div>
                <!-- Row end -->
            </form>

                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-12">
                        <div class="table-responsive">
                            <table class="table table-bordered" id="tabler">
                                <thead>
                                    <tr>
                                        <th colspan="7" class="pt-3 pb-3">Item Details</th>
                                    </tr>
                                    <tr>
                                        <th>Sr#</th>
                                        <th>Item</th>
                                        <th>Rate <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                        <th>Quantity</th>
                                        <th>Total <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $sumTotalGoods = 0 ;?>
                                @foreach($receipts as $receipt)
                                <?php 
                                            
                                    $sumTotalGoods += round((round($receipt->g_r_rate,2) * round($receipt->g_r_quantity, 2)), 2);
                                    $total = round($sumTotalGoods, 2);
                                    
                                    ?>
                                    <tr>
                                        <td>{{$loop->iteration}}</td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <select class="select-single js-states w-100" data-live-search="true">
                                                    <option>{{@ucwords(@strtolower($receipt->g_r_item))}}</option>
                                                </select>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" class="form-control" value="@convert($receipt->g_r_rate)" placeholder="Rate" readonly>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="tex" class="form-control" value="@convert($receipt->g_r_quantity) {{$receipt->g_r_unit}}" placeholder="Qty" readonly>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" class="form-control" value="@convert(round($receipt->g_r_quantity * $receipt->g_r_rate, 2))" readonly>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                       
                                        <td>
                                            <div class="table-actions">
                                                <button class="btn btn-outline-light" type="button" id="{{$receipt->id}}" onclick="deleteDock(this.id)">
                                                    <i class="icon-trash-2"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach

                                    <tr>
                                        <td colspan="4">&nbsp;</td>
                                        <td>
                                            <p class="m-0">Amount</p>
                                            <p class="m-0">Discount</p>
                                            <p class="m-0">VAT</p>
                                            <h5 class="mt-2 text-danger">Bill Amount</h5>
                                        </td>
                                        <td>
                                            <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(round($sumTotalGoods, 2))</p>
                                            <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}00.00</p>
                                            <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}00.00</p>
                                            <h5 class="mt-2 text-danger">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(round($sumTotalGoods, 2))</h5>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <div>
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <textarea name="note" placeholder="Memo here" cols="30" rows="2" onchange="editNote()" name="g_r_note" id="noteText"></textarea>
                                    <div class="field-placeholder">Note</div>
                                </div>
                                <!-- Field wrapper end -->
                        </div>

                    </div>
                </div>
                <!-- Row end -->

                <!-- Row start -->
                <div class="row gutters">

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="form-actions-footer">
                            <div class="text-end">
                                <button class="btn btn-outline-primary" onclick="confirmReceiptPrint()">Save & Print</button>
                                <!-- <button class="btn btn-primary ms-1" onclick="confirmReceipt()">Save</button> -->
                                <button class="btn btn-danger ms-1" onclick="confirmClose()">Close</button>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- Row end -->

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->


<script>

    function deleteDock(id) {
        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $("#tabler").load(" #tabler");
            }
            xhttp.open("GET", "/dashboard/remove-dock/"+id);
            xhttp.send();
    }


    $("#greceipt").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('goodreceipt.store')}}",
                dataType: "json",
                data: $('#greceipt').serialize(),
                success: function(data){
                    document.getElementById('qty').value = "" ;
                    document.getElementById('rate').value = "" ;
                    $("#tabler").load(" #tabler");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Added to Cart, add new Item'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });


    function confirmReceipt() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You want to create a GRN, you may not be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('saveGoodsReceipt')}}";
            }
            })
    }


    function confirmReceiptPrint(){
        Swal.fire({
            title: 'Are you sure?',
            text: "You want to create a GRN, you may not be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Save & Print'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/create-goods-reciept-note/save-print/" + document.getElementById('trans').value;
            }
            })
    }


    function confirmClose() {
        Swal.fire({
            title: 'Are you sure?',
            text: "you want to void this GRN, you won't be able to revert this",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, void !'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('clearGoodsReceipt')}}";
            }
            })
    }



    function editNote() {
            var note = document.getElementById('noteText').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/dashboard/customer-note/" + note);
            xhttp.send();
        }

    </script>

@endsection