@extends('layouts.app')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">


<!-- Breadcrumb container start -->
<div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="/">Home</a></li>
              <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
              <li class="breadcrumb-item active" aria-current="page">Warehouses</li>
            </ol>
        </nav>
    </div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->


<!-- Row start -->
<div class="row gutters">

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">New Warehouse</div>
            </div>
            <div class="card-body mt-4">
                
                <form class="needs-validation" novalidate method="POST" action="{{route('warehouse.store')}}">
                @csrf   
                <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="warehouse_name" required>
                                <div class="field-placeholder">Warehouse Name<span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="warehouse_city">
                                <div class="field-placeholder">Town / City</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>


                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="warehouse_region">
                                <div class="field-placeholder">State / Region </div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="warehouse_country">
                                <div class="field-placeholder">Country</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>


                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="warehouse_year">
                                <div class="field-placeholder">Established Year</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
            
                        <div class="col-12">
                            <button class="btn btn-primary" type="submit">Save</button>
                        </div>
                    </div>
                    <!-- Row end -->
                </form>

            </div>
        </div>
        <!-- Card end -->
    </div>

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">Warehouses</div>
            </div>
            <div class="card-body mt-4">
                
            <div class="table-responsive">
                <table id="copy-print-csv" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Name</th>
                        <th>City</th>
                        <th>Established Yr.</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($warehouses as $warehouse)
                        <tr>
                        <td>{{$warehouse->warehouse_name}}</td>
                        <td>{{$warehouse->warehouse_city}}</td>
                        <td>{{$warehouse->warehouse_year}}</td>
                        <td>
                            <div class="actions">
                                <a href="#" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                    <i class="icon-edit1 text-info"></i>
                                </a>
                                <a href="{{route('deleteWarehouse', $warehouse->id)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-x-circle text-danger"></i>
                                </a>
                            </div>
                        </td>
                        </tr>
                        @endforeach
                    </tbody>
            </table>
            </div>

            </div>
        </div>
        <!-- Card end -->

    </div>

</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->

@endsection