<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Validator;
use App\Models\Branch;
use App\Models\OnHouse;
use App\Models\OnlineCustomer;
use Carbon\carbon;
use App\Models\CustomerStatement;
use App\Models\LoyaltyPoint;
use App\Models\LoyaltyRatio;
use App\Models\Invoice;
use App\Models\Customer;
use App\Models\Order;
use App\Models\Discount;
use App\Models\CompositionRecord;
use App\Models\CostOfSaleAnalysis;
use App\Models\InventoryReport;
use App\Models\TargetAnalysis;
use App\Models\BomReportOnSale;
use App\Models\StockTransaction;
use App\Models\ItemStockLedgerSummary;
use App\Models\BarTable;
use App\Jobs\Inventory;
use App\Models\FinalProduction;
use App\Models\CelebrityDiscountRecord;
use App\Models\User;
use App\Models\AccountTransaction;
use App\Models\StockChecker;
use Illuminate\Support\Facades\Cache;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('login/from-pos', function(Request $request){


    $rules = array(
        'email' => 'email|required|max:300',
        'role' => 'required|max:300',
    );
    
    
    $validator = Validator::make($request->all(), $rules);
    if ($validator->fails()) {
        return $validator->errors();
    }
    
    $credentials = $request->only('email', 'password');

    if (request('role') == "Administrator") {
        if (!Auth::attempt($credentials)) {
            return response([
                'status' => 419,
                'Message' => "Sorry! unauthorized user"
            ]);
        }

        // $user = User::where('email', request('email'))->firstOrFail();
        // $token = $user->createToken('auth_token')->plainTextToken;

        $user = Auth::user();
        $token = $user->createToken('auth_token')->plainTextToken;

        Auth::login($user);

        // Redirect the user to the desired page in your application
        return redirect()->route('dashboard')->with('token', $token);

        // if ($user) {
        //     Auth::login($user);
        // }


        return response([
            'message'=> "Hi" . $user->name,
            'access_token' => $token,
        ]);
    }else{
        return response([
            'status' => 419,
            'Message' => "Sorry! unauthorized user"
        ]);
    }
    
});




Route::get('/product-list', function(){
    return \DB::table('final_productions')
            ->get();
});


Route::get('/categories', function(){
    return \DB::table('item_categories')
    ->select('category_name','category_code')
    ->get();
});

Route::get('/branches', function(){
    return \DB::table('branches')
            ->get();
});


Route::get('/locations', function(){
    return \DB::table('dispatch_items')
            ->get();
});

Route::get('/user-roles', function(){
    return \DB::table('users')
	    ->selectRaw('role as role')
	    ->groupBy('role')
	    ->where('role' , '!=', NULL)
            ->pluck('role');
});


Route::get('/v1/reprint/{invoice_number}', function($invoice_number){
   $last_transaction = \DB::table('orders')->where('order_id',$invoice_number)->first();
   return redirect('/dashboard/print-lite-version/'. $invoice_number . "/" . $last_transaction->customer_id);
});


Route::get('/v1/discount/{code}', function($code){
   return \DB::table('celebrity_discounts')->where('discount_code', $code)->first();
});




Route::post('/v1/submit-discount-code', function(){

   $discount_codes = \DB::table('celebrity_discounts')->where('discount_code', request('discount_code'))->first();
   
   $order = \DB::table('orders')->where('order_id', request('invoice_number'))->first();
   
   CelebrityDiscountRecord::updateOrCreate([
   		
   		'discount_code' => $discount_codes ->discount_code,
   		'invoice_number' => request('invoice_number'),
   		
   		
   	], [
   		'order_total_cost' => $order -> total_cost_order,
   		'discount_amount' => $discount_codes -> discount_percentage
   	
   	]);
   	
   	return response([
   			
   			'status' => 200,
   			'Message' => "Success",
   		
   		]);
});


Route::get('/v1/last-transaction/{id}', function($id){
   $last_transaction = \DB::table('orders')->where('user_id',$id)->OrderBy('id', 'DESC')->first();
   return redirect('/dashboard/print-lite-version/'. $last_transaction->order_id . "/" . $last_transaction->customer_id);
});


Route::post('v1/orders-from-agencies', function(Request $request){
    
    $rules = array(
        'f_name' => 'required|max:300',
        'address' => 'required|max:300',
        'contact' => 'required|max:12',
        'agency_code' => 'required|max:20',
        'api_key' => 'required|max:20',
        'orders' => 'required',
        'transaction_number' => 'required|max:20'
    );
    
    $validator = Validator::make($request->all(), $rules);
    if ($validator->fails()) {
        return $validator->errors();
    }
    $data = json_decode($request->getContent());
    $search_branch = \DB::table('branches')->where('branch_code', $data->branch_code)->first();
    $api_key = "PIZZADOrable401";
    $getDayClose = \DB::table('close_days')->first();


    $f_name = $data -> f_name;
    $l_name = $data -> l_name;
    $address = $data -> address;
    $email = $data -> email;
    $contact = $data -> contact;
    $comment = $data -> comment;
    $agency_code = $data->agency_code;
    $transaction_number = $data->transaction_number;
    $orders = $data->orders;
    $private_key = $data->api_key;
    
    $verify_Agency_code = \DB::table('agencies')->where('agency_code', $agency_code)->first();
    if (empty($verify_Agency_code)) {
        return response([
            "status" => 419,
            "message" => "Invalid Agency Code"
        ]);
    }

    if ($api_key != $private_key) {
        return response([
            "status" => 419,
            "message" => "API Mismatch"
        ]);
    }

    try {
        // Perform DB Transaction
        \DB::beginTransaction();
    
    $data = new OnlineCustomer;
    $data -> customer_fname = $f_name; //CUSTOMER FIRST NAME - REQUIRED
    $data -> customer_lname = $l_name; //CUSTOMER LAST NAME - OPTIONAL
    $data -> delivery_location = $address; //CUSTOMER LOCATION - REQUIRED
    $data -> customer_eamil = $email; //CUSTOMER EMAIL - REQUIRED
    $data -> customer_phone = $contact; //CUSTOMER PHONE - REQUIRED
    $data -> order_branch = $search_branch->branch_name; //GET BRANCH FROM BRANCH CODE // REQUIRED
    $data -> date = $getDayClose->day_close; //REQUIRED DATE
    $data -> comment = $comment; //NOTE FROM CUSTOMER //OPTIONAL
    $data -> discount_code = ""; //OPTIONAL-DISCOUNT CARD
    $data -> invoice_number = substr($agency_code, 0,3). rand(5034580,10034580) . date("Yd") . date('Hi');
    $data -> agency_trans_number = $transaction_number;
    $data -> agency = $agency_code; //REQUIRED - AGENCY CODE
    $data -> agency_orders = json_encode($orders);
    $data -> save();
    
    \DB::commit();  
    return response([
            'status' => 1000,
            'message' => "order Successfull",
            'state' => "pending"
        ]);

    } catch (\Throwable $th) {
        \DB::rollback();
        return response([
            'status' => 501,
            "Message" => $th
        ]);
    }

});



Route::post('/v1/user-authentications', function(Request $request){

    $rules = array(
        'customer_phone' => 'required|max:300',
        'password' => 'required|max:300',
    );
    
    $validator = Validator::make($request->all(), $rules);
    if ($validator->fails()) {
        return $validator->errors();
    }


    if (!Auth::attempt($request->only('customer_phone','password'))) {

        return response([
            'status' => 419,
            'Message' => "Sorry! unauthorized user"
        ]);
    }

    $user = User::where('customer_phone', request('customer_phone'))->firstOrFail();
    $token = $user->createToken('auth_token')->plainTextToken;

    return response([
        'access_token' => $token,
    ]);


});



Route::get('/v1/search-customer/{search}', function(Request $request, $search){
    return $customers = \DB::table('customers')
            ->where('customer_name', 'like' , '%' . $search .'%')
            ->orwhere('customer_phone',  'like','%' . $search . '%')
            ->orWhere('customer_branch',  'like','%' . $search . '%')
            ->get();
});


Route::get('/v1/customer-sort-by/{branch}', function(Request $request, $branch){

    $getDayClose = \DB::table('close_days')->first(); // getDay close

    $newdate = date('Y-m-d', strtotime('-1 day', strtotime($getDayClose->day_close)));

    $branchcode = \DB::table('branches')->where('branch_name', $branch)->first();
    
    
    if (empty(Cache::get($branchcode->branch_code))) {
        $orders = \DB::table('orders')
        ->where('branch', $branch)
        ->whereDate('created_at', $newdate)->pluck('customer_id');

        Cache::put($branchcode->branch_code, $orders);
    }

    
    $customers_orders = Cache::get($branchcode->branch_code);

    if (empty(Cache::get($branchcode->branch_code . "customer"))) 
    {
        $customers = \DB::table('customers')
            ->whereIn('id', $customers_orders)
            ->get();

            Cache::put($branchcode->branch_code . "customer", $customers);
    }

    return Cache::get($branchcode->branch_code . "customer");
    
});


Route::get('/v1/search-walk-in-customer/{search}', function(Request $request, $search){
    return $customers = \DB::table('customers')->where('customer_name', "WALK-IN CUSTOMER")->first();
});

Route::get('/v1/search-loyalty-points/{search}', function(Request $request, $search){
    $cust = explode(",", $search);
    return $customers = \DB::table('loyalty_points')
            ->selectRaw('customer_id, sum(increase) as increase, sum(decrease) as decrease')
            ->groupBy('customer_id')
            ->whereIn('customer_id', $cust)
            ->get();
});

Route::get('/v1/customer/{id}', function(Request $request, $id){
    return \DB::table('customers')->where('id', $id)->first();
           
});


Route::get('/v1/report/{user}', function(Request $request, $user){
    $getDayClose = \DB::table('close_days')->first(); // getDay close
    return \DB::table('invoices')
                    ->where('invoice_status', 1)
                    ->where('user_id', $user)
                    ->where('invoice_category', '!=', "TRANSPORT")
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->get();
});

Route::get('/v1/report-held/{user}', function(Request $request, $user){
    $getDayClose = \DB::table('close_days')->first(); // getDay close
    return \DB::table('invoices')
                    ->where('invoice_status', 5)
                    ->where('user_id', $user)
                    ->where('invoice_category', '!=', "TRANSPORT")
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->get();
});


Route::get('/v1/report-held-orders/{user}', function(Request $request, $user){
    $getDayClose = \DB::table('close_days')->first(); // getDay close
    return \DB::table('orders')
                    ->where('status', 5)
                    ->where('user_id', $user)
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->get();
});


Route::get('/v1/report/discount/{user}', function(Request $request, $user){
    $getDayClose = \DB::table('close_days')->first(); // getDay close
    return \DB::table('discounts')
                    ->where('user_id', $user)
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->sum('amount_deducted');
});


Route::get('/v1/report/total-sale/{user}', function(Request $request, $user){
    $getDayClose = \DB::table('close_days')->first(); // getDay close
    return \DB::table('invoices')
                    ->where('invoice_status', 1)
                    ->where('user_id', $user)
                    ->where('invoice_category', '!=', "TRANSPORT")
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->sum('invoice_total_price');
});


Route::get('/v1/walk-in-customer', function(){
    $customer = Customer::updateOrCreate(
            ['customer_name' => "WALK-IN CUSTOMER"],[
            'customer_name' => "WALK-IN CUSTOMER"
        ]
    );

    return \DB::table('customers')->where('customer_name', "WALK-IN CUSTOMER")->first();
});



Route::get('/dashboard/print-lite-version/{inv}/{customer}', [App\Http\Controllers\PrinterController::class,'PrintLite'])->name('PrintLite');




Route::get('/v1/user-branch/{branch}', function(Request $request, $branch){

    return \DB::table('branches')->where('branch_name', $branch)->first();

});

Route::get('/v1/taxes', function(){

    return \DB::table('taxes')->first();

});


Route::get('/v1/users/{email}', function(Request $request, $email){

    return $users = \DB::table('users')->where('email', $email)->first();

});


Route::get('/v1/on-house/beneficiaries', function(Request $request){
   
    return  \DB::table('house_people')->get();

});


Route::get('/riders-report', function(){

        $getDayClose = \DB::table('close_days')->first();
        $riderinfo = \DB::table('riders')->where('rd_motor', request('search'))->first();

        return \DB::table('riders')
            ->select('*')
            ->join('dispatches', 'riders.id', 'dispatches.rider_id')
            ->where('dispatches.rider_id', $riderinfo -> rider_id)
            ->whereDate('dispatches.created_at', $getDayClose->day_close)
            ->get();
});


Route::post('/v1/save-onhouse-beneficiary', function(Request $request){

    $getDayClose = \DB::table('close_days')->first(); // getDay close
    $time = date('H:i:s'); // current time 

    $data = request();

    $name = $data->name;
    $comment = $data->comment;
    $id = $data -> user_id;
    $invoice_number = $data -> invoice_number;


    $person = \DB::table('house_people')->where('name', $name)->first();
    
    $data = new OnHouse;
    $data->user_id = $id;
    $data->person_id = $person ->id;
    $data->name = $name;
    $data->order_number = $invoice_number;
    $data ->phone = $person -> phone;
    $data-> comment = $request -> comment;
    $data-> created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
    $data->save();

    return response([
        'status' => 1000,
        'message' => "Saved successfully"
    ]);
});




Route::get('/v1/clear-cache',  function(Request $request){
		Cache::flush();
});





Route::get('/v1/get-waiter-transaction', function(){

     $getDayClose = \DB::table('close_days')->first();
     
     return BarTable::where('date', $getDayClose -> day_close)->where('table_settlement', 0)->get();
});

Route::get('/v1/get-waiter-transaction-confirm', function(){

     $getDayClose = \DB::table('close_days')->first();
     
     return BarTable::where('date', $getDayClose -> day_close)->where('table_settlement', 1)->get();
});


Route::get('/v1/confirm-payment/{user}/{id}', function($user, $id){

     $waiter = BarTable::find($id);
     $user = User::find($user);
     $waiter -> table_settlement = 1;
     $waiter -> settled_by = $user->name ;
     $waiter -> settled_at = \Carbon\Carbon::now();
     $waiter -> save();
     
     return response([
     		'status' => 200,
     		'Message' => "Payment Confirmed"
     ]);
});

Route::post('/v1/submit-order', function(Request $request){

        $data = request();
        
        if($data->token !== "Andasv9"){
          return response([
              "Message" => "Software update available. Kindly update software to proceed"
          ]);
        }
        
        
          
        if(empty(session()->get('getDayClose'))){
        		
        	session()->put('getDayClose', \DB::table('close_days')->first());
        	$getDayClose = session()->get('getDayClose');
        }else{
        
        	$getDayClose = session()->get('getDayClose');
        }
        
        $time = date('H:i:s'); // current time 
        
        $branch_code = \DB::table('branches')->where('branch_name', $data->branch)->first();
        $saleliite = \DB::table('kitchens')->where('kitchen_code', $branch_code->branch_code)->first();
        

        $invoice_number = $data->invoice_number;
	    $branch = $data->branch;
	    $user = $data->user_id;
	    $customer = $data->customer_id;
	    $amount_paid = $data->amount_paid;
	    $payment_method = $data->payment_method;
	    $discount = $data->discount;
	    $discount_type = $data->discount_type;
	    $sales_person_category = $data->sales_person_category;
        $customer_contact = $data->customer_contact;
	    $loyal = $data->loyal;
	    $order_type = $data->order_type;
	   
        // tax
        $taxes = \DB::table('taxes')->first();
        $generalTax = $taxes->covid+$taxes->nhil+$taxes->getfund;

        $generateInvoice = $data->invoice_number;
        $transfer = $data->orders; //transfer from Dump Invoice Table

        $user_id_ = $data->user_id;
        $get_role = User::find($user_id_);
        $role = $get_role->role;
        

        
        if(empty(session()->get('app'))){
        	session()->put('app', \DB::table('settings')->first());
        	
        	$app = session()->get('app');
        }else{
        
        	$app = session()->get('app');
        }
        

        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        
        if($role == "Call Center"){
           abort(419,"unathorized Access");
        }

        if (empty($transfer) || null) {
            return back()->with('status', 'No Item Added to Cart');
        }else{
        // SUM ORDER
        foreach ($transfer as $inv) {
        
           $checkduplicate = \DB::table('invoices')->where('invoice_number', $generateInvoice)->where('invoice_product_name', $inv['invoice_product_name'])->first();
        
	      if(!empty($checkduplicate) || $checkduplicate !== null){
        	return redirect()->to('/dashboard/print-lite-version/' .  $generateInvoice ."/" . $customer);
        }

        if ( $inv['item_category'] !== "TRANSPORT" ) {
        
        if(empty(Cache::get('product'. $inv['id']))){
        
            	 Cache::put('product'.$inv['id'], \DB::table('final_productions')->where('FinalProductionID', $inv['id'])->first());
            	 
            	 $validateProduct = Cache::get('product'.$inv['id']);
            	 
            	 
            
            }else{
            
            
                 $validateProduct = Cache::get('product'.$inv['id']);
            
            }


            if (empty($validateProduct) || $validateProduct == Null) {
                
                return response([
                    "Messages" => "419 sales syncronization, Kindly Sync Product on system to proceed"
                ]);

            }else {
            
            // CHECK IF INVENTORY CHECKER IS ENABLED
            
            if(empty(Cache::get('bom'.$inv['id']))){
            
            	 Cache::put('bom'.$inv['id'], \DB::table('material_product_compositons')->where('product_id', $inv['id'])->get());
            	 
            	 $materials = Cache::get('bom'.$inv['id']);
            
            }else{
            
            
                 $materials = Cache::get('bom'.$inv['id']);
            
            
            }
             
        foreach ($materials as $key => $stock) {

		if(empty(Cache::get('stock'. $stock-> composition_id))){
		
		 Cache::put('stock'. $stock-> composition_id, \DB::table('items')->where('id', $stock-> composition_id)->first());
            	 
            	 $unit = Cache::get('stock'.$stock-> composition_id);
		
		
		}else{
		
		 $unit = Cache::get('stock'.$stock-> composition_id);
		
		}
		
		
		
		if(empty(Cache::get('stockcheck'. $branch_code->branch_code . $stock-> composition_id))){
		
		 $stockchecking = ItemStockLedgerSummary::where('item_id', $stock-> composition_id)->where('station', $saleliite->kitchen_name)->where('date', $getDayClose->day_close)->first();
		 
		  Cache::put('stockcheck'. $branch_code->branch_code . $stock-> composition_id, $stockchecking);
		  $stockchecking = Cache::get('stockcheck'. $branch_code->branch_code . $stock-> composition_id);

        if (empty($stockchecking) || $stockchecking == Null) {
            
            $opening_stock =  \DB::table('stock_transactions')->where('station', $saleliite->kitchen_name)->where('item_id', $stock-> composition_id)
            ->whereDate('date', '<', $getDayClose->day_close)
                                ->sum('stock_in') - \DB::table('stock_transactions')->where('station', $saleliite->kitchen_name)->where('item_id', $stock-> composition_id)
                                ->whereDate('date', '<', $getDayClose->day_close)
                                ->sum('stock_out');


                                \App\Models\ItemStockLedgerSummary::updateOrCreate([
                                    'station' => $saleliite->kitchen_name,
                                    'date' => $getDayClose->day_close,
                                    'item_id' => $stock-> composition_id],
                                    [
                                    'item_name' => $unit -> item_name,
                                    'item_unit' => $unit -> item_unit,
                                    'item_code' => $unit -> item_code,
                                    'item_category' => $unit -> item_category,
                                    'inactive_station' => $unit -> inactive_station,
                                    'opening_stock' =>  $opening_stock,
                                    'stock_in' => 0,
                                    'stock_out' => 0,
                                    ]);
                            }
                    }
                    

		if($app->inventory_mgt == 1){
                
                 if(empty(Cache::get($branch_code->branch_code . "" . $stock-> composition_id))){
                	
                	Cache::put($branch_code->branch_code . "" . $stock-> composition_id, \DB::table('item_stock_ledger_summaries')->where('station', $saleliite->kitchen_name)->where('item_id', $stock-> composition_id)->whereDate('date', $getDayClose->day_close)->first());
                	
                	$balance_b_f  =  Cache::get($branch_code->branch_code . "" . $stock-> composition_id);
                	
                	
                	}else{
                	
                	$balance_b_f = Cache::get($branch_code->branch_code . "" . $stock-> composition_id);
                	
                	}
		
		
		
                $stock_in =  \DB::table('stock_transactions')->where('station', $saleliite->kitchen_name)->where('item_id', $stock-> composition_id)->whereDate('date', $getDayClose->day_close)->sum('stock_in');
                $stock_out =  \DB::table('stock_transactions')->where('station', $saleliite->kitchen_name)->where('item_id', $stock-> composition_id)->whereDate('date', $getDayClose->day_close)->sum('stock_out');

                $closing = ($balance_b_f->opening_stock + $stock_in) - $stock_out ;

                if ($unit->item_stock_check == 1) {
        
                    if ((($closing - ($stock->unit_measure * $inv['invoice_quantity'])) < 0 )) {
                        return response([
                            'Message' => $unit->item_name . " is out of stock" ,
                        ]);
                    }

                 }
                }
                
                
                \App\Models\StockTransaction::create([
                            'user_id' => $user_id_,
                            'item_id' =>  $stock-> composition_id,
                            'description' => 'Sales',
                            'note' => 'Sales from ' . $data->branch  . '<br>' . '<a href=' . '/dashboard/order/transaction-details/' . $generateInvoice .'>' . $generateInvoice .'</a>' ,
                            'unit' =>  $unit->item_unit,
                            'station' =>  $saleliite->kitchen_name,
                            'date' => $getDayClose->day_close,
                            'stock_out' => $stock->unit_measure * $inv['invoice_quantity'],
                            'cost' => ($stock->cost/$stock->unit_measure),
                            'transactions_id' => $generateInvoice
                    ]);

            }
            	
          
            	if ( $inv['invoice_status'] == "General" || $inv['invoice_status'] == 1) {
                     $state = 1;
                }elseif ( $inv['invoice_status']== "On The House" ||  $inv['invoice_status'] == 2) {
                     $state = 2;
                     
                }else{
                    $state = 1;
                }

                $new_invoice = new Invoice;
                $new_invoice->user_id = $data->user_id;
                $new_invoice->customer_id = $data->customer_id;
                $new_invoice->product_id = $validateProduct->FinalProductionID;
                $new_invoice->branch = $data->branch;
                $new_invoice->invoice_product_name = $validateProduct->Name;
                $new_invoice->invoice_status = $state;
                $new_invoice->invoice_sales_person_category = $inv['invoice_sales_person_category'];
                $new_invoice->invoice_quantity = $inv['invoice_quantity'];
                $new_invoice->invoice_unit_price = $validateProduct->UnitPrice;
                $new_invoice->invoice_total_price = $validateProduct->UnitPrice * $inv['invoice_quantity'];
                $new_invoice->user_role = $role;
                $new_invoice->invoice_number = $generateInvoice;
                $new_invoice->agency =  $role == "Call Center" ? Null : $payment_method;
                $new_invoice->role_status =  $role == "Call Center" ? 1 : 0;
                $new_invoice->invoice_category = $inv['item_category'];
                $new_invoice->created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
                $new_invoice->save();
                
                
            }
        }else {
        
        	if ( $inv['invoice_status'] == "General" || $inv['invoice_status'] == 1) {
                     $state = 1;
                }elseif ( $inv['invoice_status']== "On The House" ||  $inv['invoice_status'] == 2) {
                     $state = 2;
                }else{
                    $state = 1;
                }

                $new_invoice = new Invoice;
                $new_invoice->user_id = $data->user_id;
                $new_invoice->customer_id = $data->customer_id;
                $new_invoice->product_id = $inv['id'];
                $new_invoice->branch = $data->branch;
                $new_invoice->invoice_product_name = $inv['invoice_product_name'];
                $new_invoice->invoice_status = $state;
                $new_invoice->invoice_sales_person_category = $inv['invoice_sales_person_category'];
                $new_invoice->invoice_quantity = $inv['invoice_quantity'];
                $new_invoice->invoice_unit_price = $inv['invoice_unit_price'];
                $new_invoice->invoice_total_price = $inv['invoice_total_price'];
                $new_invoice->user_role = $role;
                $new_invoice->invoice_number = $generateInvoice;
                $new_invoice->agency =  $role == "Call Center" ? Null : $payment_method;
                $new_invoice->role_status =  $role == "Call Center" ? 1 : 0;
                $new_invoice->invoice_category = $inv['item_category'];
                $new_invoice->created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
                $new_invoice->save();
        }
        }

        $totalCart = \DB::table('invoices')->where('invoice_number', $generateInvoice)->sum('invoice_total_price');
        
          if (!empty($discount) || $discount !== NULL) {
            if ($discount_type == "Percentage") {
                 $discount = ($data->discount/100) * $totalCart;
            }else {
                $discount =  $data->discount;
            }
        }else { 
            $discount = 0;
        }


        // RECORD ITEM TRANSACTION AS ORDER
        $order_ = new Order;
        $order_ -> order_id = $generateInvoice;
        $order_ -> user_id = $data->user_id;
        $order_ -> customer_id = $data->customer_id;
        $order_ -> branch =  $data->branch;
        $order_ -> order_type =  $order_type == null ? "PICK UP" : $order_type;
        $order_ -> status = $data->user_id == null ? 1 : 0;
        $order_ -> category = $data->sales_person_category;
        $order_ -> total_cost_order = $totalCart;
        $order_ -> amount_paid = $data->amount_paid;
        $order_ -> discount = $discount;
        $order_ -> user_role = $role;
        $order_ -> payment_method = $payment_method;
        $order_ -> channel = 1;
        $order_ -> created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
        $order_ ->save();
        
        
        $waiter = new BarTable;
        $waiter -> user_id = $data->user_id;
        $waiter -> branch =  $data->branch;
        
	$waiter -> table_name = "NO TABLE ASSIGNED";
	$waiter -> table_served_by = $data->waiter;
	$waiter -> invoice_number = $generateInvoice;
	$waiter -> date = $getDayClose->day_close;
	$waiter -> table_settlement = 0;
	$waiter -> created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
	$waiter ->save();

    // Discount
    $discounting = \DB::table('discounts')->where('order_id', $data->invoice_number)->first();
    if (empty($discounting)) {
        $discounted_amount = 0;
    }else {
        if ($discount->type == "Percentage") {
            $discounted_amount = ($discount->discount)/100;
        }else {
            $discounted_amount = (($discount->discount/($discount->amount_paid + $discount->amount_deducted))*100)/100;
        }
    }
    


    //   Discount
    if (!empty($discount_type) || $discount_type !== NULL) {
        if ($discount_type == "Percentage") {
            $useDiscount = Discount::updateOrCreate(
                ['order_id' => $invoice_number],
                [
                    'user_id' => $user,
                    'order_number' => $order_->id,
                    'type' => $discount_type,
                    'order_id' => $generateInvoice,
                    'discount' =>  $discount,
                    'category' => $sales_person_category,
                    'branch' => $branch,
                    'amount_paid' => $totalCart - $discount,
                    'amount_deducted' => $discount,
                    'created_at'=> date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"))
                ]);
        }else {
            $useDiscount = Discount::updateOrCreate(
                ['order_id' => $invoice_number],
                [
                    'user_id' => $user,
                    'type' => $discount_type,
                    'order_id' => $invoice_number,
                    'discount' =>  $discount,
                    'category' => $sales_person_category,
                    'branch' => $branch,
                    'amount_paid' => $totalCart - $discount,
                    'amount_deducted' => $discount,
                    'created_at'=> date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"))
                ]);
        }
        
    }
    
    session()->forget(['app', 'getDayClose']);


    // if ($customer_contact !== null) {
       
    //     $from = $app->sms_header;
    //     $to = $customer_contact;
        
    //     $receipt_link =  config('app.url') . "/dashboard/print-lite-version/" .  $generateInvoice ."/" . $customer ;
        
        
    //     $response = Http::asForm()->post('https://firebasedynamiclinks.googleapis.com/v1/shortLinks?key=AIzaSyAkSBDDTpMarsIzwL8AGv8A2PNAdND61DY', [
    //             'longDynamicLink' => 'https://reeco.page.link/?link=' . $receipt_link,
    //             ]);
                
    //     $message = "Your payment of GHS" . $data->amount_paid . " has been received at Reecopack Ghana. Check full payment receipt here: " . $response['shortLink'] . " Thank you for buying from us!";
    //     $url = "https://sms.arkesel.com/sms/api?action=send-sms&api_key=Y2JkS3VpYWJjTUVjSUJhQmlQZUQ=&to=" . $to . "&from=" . $from . "&sms=" . $message;
    //     $response = Http::retry(3, 200)->get($url);

    // }



    // if ($customer_contact !== null) {
       
    //     $from = $app->sms_header;
    //     $to = $customer_contact;
        
    //     $receipt_link =  config('app.url') . "/dashboard/print-invoice/" .  $generateInvoice ."/" . $customer ;
        
        
    //     $response = Http::asForm()->post('https://firebasedynamiclinks.googleapis.com/v1/shortLinks?key=AIzaSyBYPTUp7zXTybD6cqJHaG3kwgqPgBiHAP4', [
    //             'longDynamicLink' => 'https://luxx.page.link/?link=' . $receipt_link,
    //             ]);
                
    //     $message = "Thank you for trusting us with your laundry! View payment receipt: " . $response['shortLink'] . ".  We look forward to serving you again soon!";
    //     $url = "https://sms.arkesel.com/sms/api?action=send-sms&api_key=Y2JkS3VpYWJjTUVjSUJhQmlQZUQ=&to=" . $to . "&from=" . $from . "&sms=" . $message;
    //     $response = Http::retry(3, 200)->get($url);

    // }


     \DB::commit();  
    
        return redirect()->to('/dashboard/print-lite-version/' .  $generateInvoice ."/" . $customer);
        

        }

    } catch (\Throwable $th) {
        \DB::rollback();
        return response([
            'status' => 501,
            "Message" => $th
        ]);
    }
        
});



Route::post('/v1/submit-order-held', function(Request $request){

        $data = request();
        
        if($data->token !== "Andasv9"){
          return response([
              "Message" => "Software update available. Kindly update software to proceed"
          ]);
        }
        
        
          
        if(empty(session()->get('getDayClose'))){
        		
        	session()->put('getDayClose', \DB::table('close_days')->first());
        	$getDayClose = session()->get('getDayClose');
        }else{
        
        	$getDayClose = session()->get('getDayClose');
        }
        
        $time = date('H:i:s'); // current time 
        
        $branch_code = \DB::table('branches')->where('branch_name', $data->branch)->first();
        $saleliite = \DB::table('kitchens')->where('kitchen_code', $branch_code->branch_code)->first();
        

        $invoice_number = $data->invoice_number;
	    $branch = $data->branch;
	    $user = $data->user_id;
	    $customer = $data->customer_id;
	    $amount_paid = $data->amount_paid;
	    $payment_method = $data->payment_method;
	    $discount = $data->discount;
	    $discount_type = $data->discount_type;
	    $sales_person_category = $data->sales_person_category;
	    $loyal = $data->loyal;
	   
        // tax
        $taxes = \DB::table('taxes')->first();
        $generalTax = $taxes->covid+$taxes->nhil+$taxes->getfund;

        $generateInvoice = $data->invoice_number;
        $transfer = $data->orders; //transfer from Dump Invoice Table

        $user_id_ = $data->user_id;
        $get_role = User::find($user_id_);
        $role = $get_role->role;
        

        
        if(empty(session()->get('app'))){
        	session()->put('app', \DB::table('settings')->first());
        	
        	$app = session()->get('app');
        }else{
        
        	$app = session()->get('app');
        }
        

        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        
        if($role == "Call Center"){
           abort(419,"unathorized Access");
        }

        if (empty($transfer) || null) {
            return back()->with('status', 'No Item Added to Cart');
        }else{
        // SUM ORDER
        foreach ($transfer as $inv) {
        
           $checkduplicate = \DB::table('invoices')->where('invoice_number', $generateInvoice)->where('invoice_product_name', $inv['invoice_product_name'])->first();
        
	      if(!empty($checkduplicate) || $checkduplicate !== null){
        	return redirect()->to('/dashboard/print-lite-version/' .  $generateInvoice ."/" . $customer);
        }

        if ( $inv['item_category'] !== "TRANSPORT" ) {
        
        if(empty(Cache::get('product'. $inv['id']))){
        
            	 Cache::put('product'.$inv['id'], \DB::table('final_productions')->where('FinalProductionID', $inv['id'])->first());
            	 
            	 $validateProduct = Cache::get('product'.$inv['id']);
            	 
            	 
            
            }else{
            
            
                 $validateProduct = Cache::get('product'.$inv['id']);
            
            }


            if (empty($validateProduct) || $validateProduct == Null) {
                
                return response([
                    "Messages" => "419 sales syncronization, Kindly Sync Product on system to proceed"
                ]);

            }else {
            
            // CHECK IF INVENTORY CHECKER IS ENABLED
            
            if(empty(Cache::get('bom'.$inv['id']))){
            
            	 Cache::put('bom'.$inv['id'], \DB::table('material_product_compositons')->where('product_id', $inv['id'])->get());
            	 
            	 $materials = Cache::get('bom'.$inv['id']);
            
            }else{
            
            
                 $materials = Cache::get('bom'.$inv['id']);
            
            
            }
             
                foreach ($materials as $key => $stock) {

		if(empty(Cache::get('stock'. $stock-> composition_id))){
		
		 Cache::put('stock'. $stock-> composition_id, \DB::table('items')->where('id', $stock-> composition_id)->first());
            	 
            	 $unit = Cache::get('stock'.$stock-> composition_id);
		
		
		}else{
		
		 $unit = Cache::get('stock'.$stock-> composition_id);
		
		}
		
		
		
		if(empty(Cache::get('stockcheck'. $branch_code->branch_code . $stock-> composition_id))){
		
		 $stockchecking = ItemStockLedgerSummary::where('item_id', $stock-> composition_id)->where('station', $saleliite->kitchen_name)->where('date', $getDayClose->day_close)->first();
		 
		  Cache::put('stockcheck'. $branch_code->branch_code . $stock-> composition_id, $stockchecking);
		  $stockchecking = Cache::get('stockcheck'. $branch_code->branch_code . $stock-> composition_id);

        if (empty($stockchecking) || $stockchecking == Null) {
            
            $opening_stock =  \DB::table('stock_transactions')->where('station', $saleliite->kitchen_name)->where('item_id', $stock-> composition_id)
            ->whereDate('date', '<', $getDayClose->day_close)
                                ->sum('stock_in') - \DB::table('stock_transactions')->where('station', $saleliite->kitchen_name)->where('item_id', $stock-> composition_id)
                                ->whereDate('date', '<', $getDayClose->day_close)
                                ->sum('stock_out');


                                \App\Models\ItemStockLedgerSummary::updateOrCreate([
                                    'station' => $saleliite->kitchen_name,
                                    'date' => $getDayClose->day_close,
                                    'item_id' => $stock-> composition_id],
                                    [
                                    'item_name' => $unit -> item_name,
                                    'item_unit' => $unit -> item_unit,
                                    'item_code' => $unit -> item_code,
                                    'item_category' => $unit -> item_category,
                                    'inactive_station' => $unit -> inactive_station,
                                    'opening_stock' =>  $opening_stock,
                                    'stock_in' => 0,
                                    'stock_out' => 0,
                                    ]);
                            }
                    }
                    

		if($app->inventory_mgt == 1){
                
                 if(empty(Cache::get($branch_code->branch_code . "" . $stock-> composition_id))){
                	
                	Cache::put($branch_code->branch_code . "" . $stock-> composition_id, \DB::table('item_stock_ledger_summaries')->where('station', $saleliite->kitchen_name)->where('item_id', $stock-> composition_id)->whereDate('date', $getDayClose->day_close)->first());
                	
                	$balance_b_f  =  Cache::get($branch_code->branch_code . "" . $stock-> composition_id);
                	
                	
                	}else{
                	
                	$balance_b_f = Cache::get($branch_code->branch_code . "" . $stock-> composition_id);
                	
                	}
		
		
		
                $stock_in =  \DB::table('stock_transactions')->where('station', $saleliite->kitchen_name)->where('item_id', $stock-> composition_id)->whereDate('date', $getDayClose->day_close)->sum('stock_in');
                $stock_out =  \DB::table('stock_transactions')->where('station', $saleliite->kitchen_name)->where('item_id', $stock-> composition_id)->whereDate('date', $getDayClose->day_close)->sum('stock_out');

                $closing = ($balance_b_f->opening_stock + $stock_in) - $stock_out ;

                if ($unit->item_stock_check == 1) {
        
                    if ((($closing - ($stock->unit_measure * $inv['invoice_quantity'])) < 0 )) {
                        return response([
                            'Message' => $unit->item_name . " is out of stock" ,
                        ]);
                    }

                 }
                }
                
                
                \App\Models\StockTransaction::create([
                            'user_id' => $user_id_,
                            'item_id' =>  $stock-> composition_id,
                            'description' => 'Sales',
                            'note' => 'Sales from ' . $data->branch  . '<br>' . '<a href=' . '/dashboard/order/transaction-details/' . $generateInvoice .'>' . $generateInvoice .'</a>' ,
                            'unit' =>  $unit->item_unit,
                            'station' =>  $saleliite->kitchen_name,
                            'date' => $getDayClose->day_close,
                            'stock_out' => $stock->unit_measure * $inv['invoice_quantity'],
                            'cost' => ($stock->cost/$stock->unit_measure),
                            'transactions_id' => $generateInvoice
                    ]);

            }
            	
    

                $new_invoice = new Invoice;
                $new_invoice->user_id = $data->user_id;
                $new_invoice->customer_id = $data->customer_id;
                $new_invoice->product_id = $validateProduct->FinalProductionID;
                $new_invoice->branch = $data->branch;
                $new_invoice->invoice_product_name = $validateProduct->Name;
                $new_invoice->invoice_status = 5;
                $new_invoice->invoice_sales_person_category = $inv['invoice_sales_person_category'];
                $new_invoice->invoice_quantity = $inv['invoice_quantity'];
                $new_invoice->invoice_unit_price = $validateProduct->UnitPrice;
                $new_invoice->invoice_total_price = $validateProduct->UnitPrice * $inv['invoice_quantity'];
                $new_invoice->user_role = $role;
                $new_invoice->invoice_number = $generateInvoice;
                $new_invoice->agency =  $role == "Call Center" ? Null : $payment_method;
                $new_invoice->role_status =  $role == "Call Center" ? 1 : 0;
                $new_invoice->invoice_category = $inv['item_category'];
                $new_invoice->created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
                $new_invoice->save();
                
                
            }
        }else {

                $new_invoice = new Invoice;
                $new_invoice->user_id = $data->user_id;
                $new_invoice->customer_id = $data->customer_id;
                $new_invoice->product_id = $inv['id'];
                $new_invoice->branch = $data->branch;
                $new_invoice->invoice_product_name = $inv['invoice_product_name'];
                $new_invoice->invoice_status = 5;
                $new_invoice->invoice_sales_person_category = $inv['invoice_sales_person_category'];
                $new_invoice->invoice_quantity = $inv['invoice_quantity'];
                $new_invoice->invoice_unit_price = $inv['invoice_unit_price'];
                $new_invoice->invoice_total_price = $inv['invoice_total_price'];
                $new_invoice->user_role = $role;
                $new_invoice->invoice_number = $generateInvoice;
                $new_invoice->agency =  $role == "Call Center" ? Null : $payment_method;
                $new_invoice->role_status =  $role == "Call Center" ? 1 : 0;
                $new_invoice->invoice_category = $inv['item_category'];
                $new_invoice->created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
                $new_invoice->save();
        }
        }

        $totalCart = \DB::table('invoices')->where('invoice_number', $generateInvoice)->sum('invoice_total_price');
        
          if (!empty($discount) || $discount !== NULL) {
            if ($discount_type == "Percentage") {
                 $discount = ($data->discount/100) * $totalCart;
            }else {
                $discount =  $data->discount;
            }
        }else { 
            $discount = 0;
        }


        // RECORD ITEM TRANSACTION AS ORDER
        $order_ = new Order;
        $order_ -> order_id = $generateInvoice;
        $order_ -> user_id = $data->user_id;
        $order_ -> customer_id = $data->customer_id;
        $order_ -> branch =  $data->branch;
        $order_ -> status = 5;
        $order_ -> category = $data->sales_person_category;
        $order_ -> total_cost_order = $totalCart;
        $order_ -> amount_paid = $data->amount_paid;  
        $order_ -> discount = $discount;
        $order_ -> user_role = $role;
        $order_ -> payment_method = $payment_method;
        $order_ -> channel = 1;
        $order_ -> created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
        $order_ ->save();
        
        
        $waiter = new BarTable;
        $waiter -> user_id = $data->user_id;
        $waiter -> branch =  $data->branch;
        
	$waiter -> table_name = "NO TABLE ASSIGNED";
	$waiter -> table_served_by = $data->waiter;
	$waiter -> invoice_number = $generateInvoice;
	$waiter -> date = $getDayClose->day_close;
	$waiter -> table_settlement = 0;
	$waiter -> created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
	$waiter ->save();

    // Discount
    $discounting = \DB::table('discounts')->where('order_id', $data->invoice_number)->first();
    if (empty($discounting)) {
        $discounted_amount = 0;
    }else {
        if ($discount->type == "Percentage") {
            $discounted_amount = ($discount->discount)/100;
        }else {
            $discounted_amount = (($discount->discount/($discount->amount_paid + $discount->amount_deducted))*100)/100;
        }
    }
    


    //   Discount
    if (!empty($discount_type) || $discount_type !== NULL) {
        if ($discount_type == "Percentage") {
            $useDiscount = Discount::updateOrCreate(
                ['order_id' => $invoice_number],
                [
                    'user_id' => $user,
                    'order_number' => $order_->id,
                    'type' => $discount_type,
                    'order_id' => $generateInvoice,
                    'discount' =>  $discount,
                    'category' => $sales_person_category,
                    'branch' => $branch,
                    'is_held' => 1,
                    'amount_paid' => $totalCart - $discount,
                    'amount_deducted' => $discount,
                    'created_at'=> date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"))
                ]);
        }else {
            $useDiscount = Discount::updateOrCreate(
                ['order_id' => $invoice_number],
                [
                    'user_id' => $user,
                    'type' => $discount_type,
                    'order_id' => $invoice_number,
                    'discount' =>  $discount,
                    'category' => $sales_person_category,
                    'branch' => $branch,
                    'is_held' => 1,
                    'amount_paid' => $totalCart - $discount,
                    'amount_deducted' => $discount,
                    'created_at'=> date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"))
                ]);
        }
        
    }
    
    session()->forget(['app', 'getDayClose']);


    \DB::commit();  
    
        return redirect()->to('/dashboard/print-lite-version/' .  $generateInvoice ."/" . $customer);
        

        }

    } catch (\Throwable $th) {
        \DB::rollback();
        return response([
            'status' => 501,
            "Message" => $th
        ]);
    }
        
});



Route::post('/v1/create-new-product', function(Request $request){
    
    $data = request();
    $name_p = $data->Name;
    $product_p = $data->UnitPrice;
    
    $production = new FinalProduction;
    $production -> Name = $name_p;
    $production -> production_category = "Miscellaneous";
    $production -> UnitPrice = $product_p;
    $production -> activated_branches = "[]";
    $production ->save();
    
    
    return response([
            'status' => 201,
            'Message' => "success",
            'Product_id' => $production->id
        ]);
    
    });


Route::post('/v1/submit-order-delivery', function(Request $request){
        
            $data = request();
                
            $getDayClose = \DB::table('close_days')->first(); // getDay close
            $time = date('H:i:s'); // current time 
            
            $branch_code = \DB::table('branches')->where('branch_name', $data->branch)->first();
            $saleliite = \DB::table('kitchens')->where('kitchen_code', $branch_code->branch_code)->first();
            

            $invoice_number = $data->invoice_number;
            $branch = $data->branch;
            $user = $data->user_id;
            $customer = $data->customer_id;
            $amount_paid = $data->amount_paid;
            $payment_method = $data->payment_method;
            $discount = $data->discount;
            $discount_type = $data->discount_type;
            $sales_person_category = $data->sales_person_category;
            $loyal = $data->loyal;
        
            // tax
            $taxes = \DB::table('taxes')->first();
            $generalTax = $taxes->covid+$taxes->nhil+$taxes->getfund;

            $generateInvoice = $data->invoice_number;
            $transfer = $data->orders; //transfer from Dump Invoice Table

            $user_id_ = $data->user_id;
            $get_role = User::find($user_id_);
            $role = $get_role->role;
            $app = \DB::table('settings')->first();

            try {
                // Perform DB Transaction
                \DB::beginTransaction();

            if (empty($transfer) || null) {
                return back()->with('status', 'No Item Added to Cart');
            }else{
            // SUM ORDER
            foreach (json_decode($transfer) as $inv) {
            
          
            $checkduplicate = \DB::table('invoices')->where('invoice_number', $generateInvoice)->where('invoice_product_name', $inv->invoice_product_name)->first();
            
            if(!empty($checkduplicate) || $checkduplicate !== null || $checkduplicate->isEmpty()){
                return redirect()->to('/dashboard/print-lite-version/' .  $generateInvoice ."/" . $customer);
            }

            if ( $inv->item_category !== "TRANSPORT" ) {
            return 123;

                $validateProduct = \DB::table('final_productions')->where('FinalProductionID', $inv->id)->first();

                if (empty($validateProduct) || $validateProduct == Null) {
                    
                    return response([
                        "Messages" => "419 sales syncronization, Kindly Sync Product on system to proceed"
                    ]);

                }else {
            
                    $new_invoice = new Invoice;
                    $new_invoice->user_id = $data->user_id;
                    $new_invoice->customer_id = $data->customer_id;
                    $new_invoice->product_id = $validateProduct->FinalProductionID;
                    $new_invoice->branch = $data->branch;
                    $new_invoice->invoice_product_name = $validateProduct->Name;
                    $new_invoice->invoice_status = 3;
                    $new_invoice->invoice_sales_person_category = $inv['invoice_sales_person_category'];
                    $new_invoice->invoice_quantity = $inv['invoice_quantity'];
                    $new_invoice->invoice_unit_price = $validateProduct->UnitPrice;
                    $new_invoice->invoice_total_price = $validateProduct->UnitPrice * $inv['invoice_quantity'];
                    $new_invoice->user_role = $role;
                    $new_invoice->invoice_number = $generateInvoice;
                    $new_invoice->agency =  $role == "Call Center" ? Null : $payment_method;
                    $new_invoice->role_status =  $role == "Call Center" ? 1 : 0;
                    $new_invoice->invoice_category = $inv['item_category'];
                    $new_invoice->created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
                    $new_invoice->save();
                    
                }

            }else {
            
                    $new_invoice = new Invoice;
                    $new_invoice->user_id = $data->user_id;
                    $new_invoice->customer_id = $data->customer_id;
                    $new_invoice->product_id = $inv['id'];
                    $new_invoice->branch = $data->branch;
                    $new_invoice->invoice_product_name = $inv['invoice_product_name'];
                    $new_invoice->invoice_status = 3;
                    $new_invoice->invoice_sales_person_category = $inv['invoice_sales_person_category'];
                    $new_invoice->invoice_quantity = $inv['invoice_quantity'];
                    $new_invoice->invoice_unit_price = $inv['invoice_unit_price'];
                    $new_invoice->invoice_total_price = $inv['invoice_total_price'];
                    $new_invoice->user_role = $role;
                    $new_invoice->invoice_number = $generateInvoice;
                    $new_invoice->agency =  $role == "Call Center" ? Null : $payment_method;
                    $new_invoice->role_status =  $role == "Call Center" ? 1 : 0;
                    $new_invoice->invoice_category = $inv['item_category'];
                    $new_invoice->created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
                    $new_invoice->save();
            }
            }

            $totalCart = \DB::table('invoices')->where('invoice_number', $generateInvoice)->sum('invoice_total_price');
            
            if (!empty($discount) || $discount !== NULL) {
                if ($discount_type == "Percentage") {
                    $discount = ($data->discount/100) * $totalCart;
                }else {
                    $discount =  $data->discount;
                }
            }else { 
                $discount = 0;
            }


            // RECORD ITEM TRANSACTION AS ORDER
            $order_ = new Order;
            $order_ -> order_id = $generateInvoice;
            $order_ -> user_id = $data->user_id;
            $order_ -> customer_id = $data->customer_id;
            $order_ -> branch =  $data->branch;
            $order_ -> status = $data->user_id == null ? 1 : 0;
            $order_ -> category = $data->sales_person_category;
            $order_ -> total_cost_order = $totalCart;
            $order_ -> amount_paid = $data->amount_paid;
            $order_ -> discount = $discount;
            $order_ -> user_role = $role;
            $order_ -> channel = 1;
            $order_ -> created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
            $order_ ->save();

        // Discount
        $discounting = \DB::table('discounts')->where('order_id', $data->invoice_number)->first();
        if (empty($discounting)) {
            $discounted_amount = 0;
        }else {
            if ($discount->type == "Percentage") {
                $discounted_amount = ($discount->discount)/100;
            }else {
                $discounted_amount = (($discount->discount/($discount->amount_paid + $discount->amount_deducted))*100)/100;
            }
        }



        //   Discount
        if (!empty($discount_type) || $discount_type !== NULL) {
            if ($discount_type == "Percentage") {
                $useDiscount = Discount::updateOrCreate(
                    ['order_id' => $invoice_number],
                    [
                        'user_id' => $user,
                        'order_number' => $order_->id,
                        'type' => $discount_type,
                        'order_id' => $generateInvoice,
                        'discount' =>  $discount,
                        'category' => $sales_person_category,
                        'branch' => $branch,
                        'amount_paid' => $totalCart - $discount,
                        'amount_deducted' => $discount,
                        'created_at'=> date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"))
                    ]);
            }else {
                $useDiscount = Discount::updateOrCreate(
                    ['order_id' => $invoice_number],
                    [
                        'user_id' => $user,
                        'type' => $discount_type,
                        'order_id' => $invoice_number,
                        'discount' =>  $discount,
                        'category' => $sales_person_category,
                        'branch' => $branch,
                        'amount_paid' => $totalCart - $discount,
                        'amount_deducted' => $discount,
                        'created_at'=> date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"))
                    ]);
            }
            
        }


        \DB::commit();  
            return redirect()->to('/dashboard/print-lite-version/' .  $generateInvoice ."/" . $customer);

            }

        } catch (\Throwable $th) {
            \DB::rollback();
            return response([
                'status' => 501,
                "Message" => $th
            ]);
        }
   
});








Route::post('save-order', function(Request $request){
    $data = json_decode($request->getContent());
    return $data->code;
    
    foreach ($data as $key => $data) {
        $new_order = new OnlineOrder;
        $new_order -> item_id = $data->product_id;
        $new_order -> item_code = $data->product_code;
        $new_order -> item_name = $data->item_name;
        $new_order -> item_quantity_purchased = $data->quantity;
        $new_order -> item_total = (float)$data->quantity * (float)$data->price;
        $new_order -> item_unit_price = $data->price;
        $new_order -> item_category = $data->category;
        $new_order -> branch = $data->branch;
        $new_order -> date = $getDayClose->day_close;
        $new_order -> invoice_number = "MAP".$data->transID;
        $new_order -> delivery_location = $data -> location;
        $new_order -> customer_phone = $data-> phone;
        $new_order -> save();
    }
});



Route::post('/v1/save-new-customer', function(Request $request){
   $data = request();
   $getDayClose = \DB::table('close_days')->first();

    $rules = array(
        'customer_name' => 'required|max:300',
        'customer_contact' => 'required|max:12',
    );

    $validator = Validator::make($request->all(), $rules);
    if ($validator->fails()) {
        return $validator->errors();
    }

   $cust_name = $data->customer_name;
   $cust_contact = $data->customer_contact;
   $cust_address = $data->customer_address;
   $cust_note = $data->customer_note;
   $api_key = $data->api_key;
   $user = $data->user_id;

   if ($api_key !== "PIZZADOrable401") {
       abort(419, "unauthorised access");
   }

   $user_n = User::find($user);

    $customer = Customer::updateOrCreate(
        [ 'customer_phone' => $cust_contact],
             [ 'customer_name' => $cust_name,
            'customer_address' =>  $cust_address,
            'customer_date' => $getDayClose->day_close,
            'customer_enteredby' => $user_n->name,
            'customer_branch' =>  $user_n->branch,
            'customer_note' =>  $cust_note,
            'customer_code' => $cust_name . "-". rand(100,50000)
        ]);

        return $customer -> id;
});


Route::get('/v1/delivery-orders-call-center/{search}', function(Request $request, $search){
        // getDay close
        $getDayClose = \DB::table('close_days')->first();
        return $orders = \DB::table('orders')
            ->select('customers.customer_name', 'customers.customer_phone','orders.order_id', 'orders.branch', 'orders.created_at', 'orders.dispatch_status', 'orders.customer_id','orders.total_cost_order')
            ->join('customers','orders.customer_id','customers.id')
            ->where('orders.customer_id', '!=', null)
            ->where('orders.status', 0)
            ->whereDate('orders.created_at', $getDayClose->day_close)
            ->where('orders.order_id', 'LIKE', '%'.request('search').'%')
            ->orWhere('customers.customer_phone', 'LIKE', '%'.request('search').'%')
            ->orWhere('orders.branch', 'LIKE', '%'.request('search').'%')
            ->get();
        
});

Route::post('test/{publicKey}', function(Request $request, $publicKey){
    
    $public = "dgddgw212484";

    if ($publicKey != $public) {
        $res = [
            "authorization" => "not authorized",
            "status" => 201
        ];
        return response($res);
    }
    
    $data = json_decode($request->getContent());
    foreach ($data as $key => $data) {
        $branch = new Branch;
        $branch->user_id = 1;
        $branch->branch_name = $data->branch_name;
        $branch->branch_location = $data->branch_location;
        $branch->branch_contact = $data->branch_contact;
        $branch->branch_code = $data->branch_code;
        $branch->branch_momo = $data->branch_momo;
        $branch->tin_number = "C0027974286";
        $branch->save();
    }

    $res = [
        "status" => "success",
        "statusCode" => 201,
    ];

    return response($res);
    
});