<?php

use Illuminate\Support\Facades\Route;
use App\Models\ItemStockLedger;
use App\Models\InventoryReport;
use App\Models\User;
use App\Models\Invoice;
use App\Models\Discount;
use App\Models\Order;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\CloseDay;
use App\Models\DayCloseRecord;
use App\Models\Currency;
use App\Models\CompositionRecord;
use Illuminate\Support\Facades\Artisan;
use App\Models\CostOfSaleAnalysis;



/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {

    $station = auth()->user()->station;
    $dayClose = \DB::table('close_days')->first();

    if (auth()->user()->role == "Accountant") {
        return redirect()->route('BookkeepingRe');
    }


    $out_of_stock = \DB::select(\DB::raw("SELECT * FROM item_stock_ledger_summaries WHERE (opening_stock + stock_in) - stock_out  < 0  AND date = '$dayClose->day_close' AND station = '$station' "));


    $items = \DB::table('items')
        ->orderBy('item_name', 'ASC')
        ->get();

        if (auth()->user()->role == "Administrator") {
            $expenses_total = NULL;
        }else {
            $expenses_total = \DB::table('expenses')
            ->WhereDate('e_date', $dayClose->day_close)
            ->where('e_name', auth()->user()->station)
            ->sum('e_amount');
        }

        $requisition_list = \DB::table('request_lists')
                ->where('request_from', auth()->user()->station)
                ->where('status', 2)
                ->where('date', $dayClose->day_close)
                ->get();


        if (auth()->user()->role == "Administrator") {
            $sales = Invoice::where('invoice_status', 1)
                ->whereDate('created_at', $dayClose->day_close)->sum('invoice_total_price');  
                
        
            $orders = Order::whereDate('created_at', $dayClose->day_close)->count(); 
                $discount = Discount::whereDate('created_at', $dayClose->day_close)
                ->where('is_held', 0)
                ->sum('amount_deducted');
        }else {
            $sales = Invoice::where('invoice_status', 1)
                ->where('branch', auth()->user()->branch)
                ->whereDate('created_at', $dayClose->day_close)
                ->sum('invoice_total_price');  
                
        
            $orders = Order::whereDate('created_at', $dayClose->day_close)->where('branch', auth()->user()->branch)->count(); 

            $discount = Discount::whereDate('created_at', $dayClose->day_close)
                ->where('branch', auth()->user()->branch)
                ->where('is_held', 0)
                ->sum('amount_deducted');
        }
        

            

    return view('dashboard', [
        'out_of_stock' => $out_of_stock,
        'items' => $items,
        'requisition_list' => $requisition_list,
        'expenses_total' => $expenses_total,
        'sales' => $sales,
        'orders' => $orders,
        'discount' => $discount
    ]);

})->middleware(['auth'])->name('dashboard');




Route::post('/dashboard/day-close', function (Request $request) {
    
    $date = $request->date;
    $newdate = date('Y-m-d', strtotime('+1 day', strtotime($date)));

   
    try {
        // Perform DB Transaction
        \DB::beginTransaction();

       $opening = \DB::table('items')->get();

        foreach ($opening as $key => $report) {
              
                $stock_qty =  \DB::table('stock_transactions')->where('station', request('station'))
                                            ->where('item_id', $report->id)
                                            ->WhereDate('date', '<', $date)
                                            ->sum('stock_in') - \DB::table('stock_transactions')->where('station', request('station'))
                                                ->WhereDate('date', '<', $date)
                                                ->where('item_id', $report->id)
                                                ->sum('stock_out');

        
        \App\Models\ItemStockLedgerSummary::updateOrCreate([
            'station' => request('station'),
            'date' => $newdate,
            'item_id' => $report->id ],
            [
            'item_name' => $report-> item_name,
            'item_unit' => $report-> item_unit,
            'item_code' => $report-> item_code,
            'item_category' => $report-> item_category,
            'inactive_station' => $report-> inactive_station,
            'opening_stock' => $stock_qty,
            ]);
    
       }


       $DaycloseStatus = \DB::table('day_close_records')->where('station', $request->station)->first();
       if (empty($DaycloseStatus)) {
           $data = new DayCloseRecord;
           $data -> date = $newdate;
           $data -> station = $request->station;
           $data -> save();
   
       }else {
           if ($DaycloseStatus->date == $newdate) {
               return [0, $request->station];
           }else {
           \DB::table('day_close_records')
           ->where('station', $request->station)
           ->update([
               'date' => $newdate,
           ]);
        }
    }
       

    \DB::commit(); 
    return [$request->station];

        } catch (\Throwable $th) {
            \DB::rollback();
            $res = response([
                'status' => 501,
                "message" => $th
            ]);

         return back()->with('statuspass', "Oops Something Happend, Transaction unsuccessufull");
            
        } 
    

})->middleware(['auth'])->name('day.close');

Route::get('/speed-clear-all-cache',[App\Http\Controllers\KitchenController::class,'clearSystemCache'])->name('clearSystemCache');


Route::post('/getSales',[App\Http\Controllers\KitchenController::class,'Sales'])->name('Sales');


Route::get('/getSales-report',[App\Http\Controllers\KitchenController::class,'SalesReport'])->name('SalesReport');


Route::get('/complete-dayclose', function(){

    $time = date('H:i:s'); // current time 
    $dayClose = \DB::table('close_days')->first();

    $cos = \DB::table('cost_of_sale_analyses')->where('date', $dayClose->day_close)->delete();
    $items_cost = \DB::table('invoices')
     ->selectRaw('invoice_product_name as name,branch as branch, invoice_category as invoice_category, product_id as product_id, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
             ->where('invoice_category', '!=', "TRANSPORT")
     ->groupBy('invoice_product_name')
     ->groupBy('invoice_category')
     ->groupBy('branch')
     ->groupBy('invoice_unit_price')
     ->groupBy('product_id')
     ->whereIn('invoice_status', [1,2])
     ->whereDate('created_at', $dayClose->day_close)
     ->get();

    $mTax = \DB::table('taxes')->first();
    $gTax = $mTax->covid+$mTax->nhil+$mTax->getfund+$mTax->tourism;

     foreach ($items_cost as $key => $validateProduct) {
          // Records for Cost of Salels
          CostOfSaleAnalysis::create([
             'item_name' => $validateProduct->name,
             'item_id' => $validateProduct->product_id,
             'branch' => $validateProduct->branch,
             'user_id' => auth()->id(),
             'category' =>  $validateProduct->invoice_category,
             'quantity' => $validateProduct->quantity,
             'gross_amount' => $validateProduct->total,
             'net_amount' => (($validateProduct->total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat)) ),
             'cost' => \DB::table('material_product_compositons')->where('product_id', $validateProduct->product_id)->pluck('cost')->sum() *  $validateProduct->quantity,
             'adjusted_cost' => \DB::table('material_product_compositons')->where('product_id', $validateProduct->product_id)->pluck('adjusted_cost')->sum() *  $validateProduct->quantity,
             'date' =>  $dayClose->day_close
         ]);
     }


     $income_finance = \DB::table('accounts')->where('account_type', "Income")
                        ->where('account_state', 1)
                        ->pluck('id');

                        $income_cos = \DB::table('accounts')->where('account_type', "Cost of sales")
                        ->where('account_state', 1)
                        ->pluck('id');

                        $expenses = \DB::table('accounts')->where('account_type', "Expenses")
                        ->where('account_state', 1)
                        ->pluck('id');

    $total_income  = \DB::table('account_transactions')->whereIn('account_id', $income_finance)->WhereDate('date', $dayClose->day_close)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $income_finance)->WhereDate('date', $dayClose->day_close)->sum('credit');
    $total_cos  = \DB::table('account_transactions')->whereIn('account_id', $income_cos)->WhereDate('date', $dayClose->day_close)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $income_cos)->WhereDate('date', $dayClose->day_close)->sum('credit');
    $total_expenses  = \DB::table('account_transactions')->whereIn('account_id', $expenses)->WhereDate('date', $dayClose->day_close)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $expenses)->WhereDate('date', $dayClose->day_close)->sum('credit');

    $retained_profit = ((abs($total_income) - $total_cos) - $total_expenses);


    $retained_earning = \DB::table('accounts')->where('account_name',  "Retained Earnings")->first();

   
        \App\Models\AccountTransaction::create([
            'user_id' => auth()->id(), 
            'account_code' => $retained_earning->account_code, 
            'account_id' => $retained_earning->id,
            'transaction_code' => session()->get('invoice_number'), 
            'date' => date('Y-m-d H:i:s', strtotime("$dayClose->day_close $time")), 
            'note' => "Profit (Loss)", 
            'description' => "Profit (Loss) for the period",
            'credit' =>  $retained_profit,
            'added_by' => auth()->user()->name,
            'transaction_mode' => request('sales_channel')
        ]);
    

    $date = $dayClose->day_close;
    $newdate = date('Y-m-d', strtotime('+1 day', strtotime($date)));


    \DB::table('close_days')->update([
        'day_close' => $newdate,
        'app_state' => 1
    ]);

    \App\Models\UserActivity::create([
        'changed_date' => \Carbon\carbon::now(),
        'user_id'=>auth()->id(),
        'event' => "Ended the day for ". $dayClose->day_close,
    ]);

    \Artisan::call('cache:clear');
    \Artisan::call('view:clear');

    return redirect('/')->with('status', 'Day Close Completed for Selected Branches. All future transactions will be entered for next business day');

})->middleware(['auth'])->name('CompletDayClose');


Route::post('/reopen-day', function(){

        $dayclose_check = \DB::table('close_days')->update([
            'day_close' => request('date'),
        ]);

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "Reopened business day for ". request('date'),
        ]);

        return [request('date')];

})->name('day.previous');

// Unit Route
Route::prefix('dashboard')->group(function () {

    Route::get('/remove-unit/{id}', [App\Http\Controllers\UnitController::class, 'destroy'])->name('unit.destroy');
    Route::get('/new-unit', [App\Http\Controllers\UnitController::class, 'index'])->name('unit.index');
    Route::post('/new-unit/save', [App\Http\Controllers\UnitController::class, 'store'])->name('unit.store');

});

// Tax Route
Route::prefix('dashboard')->group(function () {
    Route::post('/tax-save', [App\Http\Controllers\TaxController::class, 'create'])->name('TaxInsert');
});


// MAKEREQUEST Route
Route::prefix('dashboard')->group(function () {

    Route::get('/make-request', [App\Http\Controllers\MakeRequestController::class, 'indexWarehouse'])->name('warehouse.request');
    Route::get('/request/satellite', [App\Http\Controllers\MakeRequestController::class, 'indexSatellite'])->name('satellite.request');
    Route::get('/request/central', [App\Http\Controllers\MakeRequestController::class, 'indexCentral'])->name('central.request');
    Route::get('/request/incoming', [App\Http\Controllers\MakeRequestController::class, 'IncomingRequest'])->name('IncomingRequest');
    Route::get('/request/outgoing', [App\Http\Controllers\MakeRequestController::class, 'OutgoingRequest'])->name('OutgoingRequest');
    Route::get('/request/incoming/view-requisition/{transaction}', [App\Http\Controllers\MakeRequestController::class, 'ViewRequest'])->name('ViewRequest');
    Route::get('/request/incoming/sorting', [App\Http\Controllers\MakeRequestController::class, 'getIncomingRequestReport'])->name('getIncomingRequestReport');
    Route::get('/request/outgoing/sorting', [App\Http\Controllers\MakeRequestController::class, 'getOutgoingRequestReport'])->name('getOutgoingRequestReport');
    Route::get('/request/delete/{makeRequest}', [App\Http\Controllers\MakeRequestController::class, 'RemoveRequest'])->name('RemoveRequest');
    Route::get('/request/incoming/view-requisition/print/{transaction}', [App\Http\Controllers\MakeRequestController::class, 'ViewRequestPrint'])->name('ViewRequestPrint');

});


// Satellite and central Request Route
Route::prefix('dashboard')->group(function () {
    Route::get('/request/approve-by-admin-date', [App\Http\Controllers\IssueVoucherController::class, 'AdminApproveDate'])->name('VadminApproval');
    Route::post('/request/satellite-store', [App\Http\Controllers\SatelliteRequisitionController::class, 'store'])->name('satelliteRequest.store');
    Route::get('/request/satellite/destroy', [App\Http\Controllers\SatelliteRequisitionController::class, 'destroy'])->name('clearRequestSatellite');
    Route::get('/request/satellite/save-update', [App\Http\Controllers\SatelliteRequisitionController::class, 'saveSatelliteRequest'])->name('saveSatelliteRequest');
    Route::post('/request/authorize', [App\Http\Controllers\SatelliteRequisitionController::class, 'authorizeRequisition'])->name('authorizeRequisition');
    Route::get('/request/make-change-requestion/{transaction}', [App\Http\Controllers\SatelliteRequisitionController::class, 'makeChanges'])->name('makeChanges');
    Route::get('/request/satellite/save-update/print', [App\Http\Controllers\SatelliteRequisitionController::class, 'saveSatelliteRequestPrint'])->name('saveSatelliteRequestPrint');
    Route::get('/request/delete-requisition/{satelliteRequisition}', [App\Http\Controllers\SatelliteRequisitionController::class, 'deleteRequest']);
});


//Expenses
Route::prefix('dashboard')->group(function () {

        Route::get('/loyalty-ratio',[App\Http\Controllers\LoyaltyRatioController::class,'index'])->name('LoyaltyRatio');
        Route::post('/loyalty-ratio/amount-save',[App\Http\Controllers\LoyaltyRatioController::class,'store'])->name('LoyaltySubmit');



       Route::get('/delete-type/{ExpenseType}', [App\Http\Controllers\ExpenseController::class, 'ExpenseTypeRemove'])->name('ExpenseTypeRemove');

       Route::post('/expenses-type', [App\Http\Controllers\ExpenseController::class, 'ExpenseType'])->name('ExpenseType');
       Route::get('/expenses', [App\Http\Controllers\ExpenseController::class, 'index'])->name('expenses.index');
       Route::post('/expenses/new-expenses', [App\Http\Controllers\ExpenseController::class, 'create'])->name('expenses.create');
       Route::get('/expenses/report', [App\Http\Controllers\ExpenseController::class, 'show'])->name('expenses.show');

       Route::get('/expenses/report-by-date', [App\Http\Controllers\ExpenseController::class, 'ExpensesReportDate'])->name('ExpensesReportDate');
       Route::get('/expenses/report-by-date-print', [App\Http\Controllers\ExpenseController::class, 'PrintExpenses'])->name('PrintExpenses');
       Route::get('/expenses/bookkeeping-report-by-date-print', [App\Http\Controllers\ExpenseController::class, 'PrintExpensesMain'])->name('PrintExpensesMain');


       Route::get('/expenses/bookkepping-report-by-date', [App\Http\Controllers\ExpenseController::class, 'ExpensesReportMain'])->name('ExpensesReportMain');

       
       
    });
    

// Goods Receipt Route
Route::prefix('dashboard')->group(function () {

    Route::get('/run-wac', [App\Http\Controllers\GoodReceiptController::class, 'RunWac'])->name('RunWac');

    Route::post('/save-goods', [App\Http\Controllers\GoodReceiptController::class, 'store'])->name('goodreceipt.store');
    Route::get('/create-goods-reciept-note/save', [App\Http\Controllers\GoodReceiptController::class, 'saveGoodsReceipt'])->name('saveGoodsReceipt');
    Route::get('/create-goods-reciept-note/save-print/{transaction}', [App\Http\Controllers\GoodReceiptController::class, 'saveGoodsReceiptPrint'])->name('saveGoodsReceiptPrint');
    Route::get('/create-goods-reciept-note/clear', [App\Http\Controllers\GoodReceiptController::class, 'clearGoodsReceipt'])->name('clearGoodsReceipt');
    Route::get('/goods-receipt-note/list', [App\Http\Controllers\GoodReceiptController::class, 'showAll'])->name('showAll.goods');

    Route::get('/return-goods/{transaction}', [App\Http\Controllers\GoodReceiptController::class, 'returnGoods'])->name('returnGoods');


    Route::get('/goods-receipt-note/list-print', [App\Http\Controllers\GoodReceiptController::class, 'showAllPrint'])->name('showAll.goodsPrint');

    Route::get('/goods-receipt-note/{transaction}/downloadandprint', [App\Http\Controllers\GoodReceiptController::class, 'downloadPrint'])->name('downloadPrint');
    Route::get('/goods-receipt-note/view-date/sort', [App\Http\Controllers\GoodReceiptController::class, 'GRNListDate'])->name('GRNListDate');

    Route::get('/goods-receipt-note/view-date/sort-vendor', [App\Http\Controllers\GoodReceiptController::class, 'GRNListDateFiler'])->name('GRNListDateFiler');

    Route::get('/goods-receipt-note/view-date/sort-print', [App\Http\Controllers\GoodReceiptController::class, 'GRNListDatePrint'])->name('GRNListDatePrint');

    
    Route::get('/goods-receipt-note/{transaction}', [App\Http\Controllers\GoodReceiptController::class, 'show'])->name('goods.show');
    Route::get('/remove-dock/{goodReceipt}', [App\Http\Controllers\GoodReceiptController::class, 'DeleteDock']);

    
    
});


// Item Route
Route::prefix('dashboard')->group(function () {

    Route::get('/speed-clear-all-cache',[App\Http\Controllers\GeneralController::class,'clearSystemCache'])->name('clearSystemCache');

    Route::get('/print-lite-version/{inv}/{user}', [App\Http\Controllers\GeneralController::class,'PrintLite'])->name('PrintLite');
    Route::get('/print-invoice/{inv}/{user}', [App\Http\Controllers\GeneralController::class,'PrintLiteInvoice'])->name('PrintLiteInvoice');

    Route::post('/load-products/main',[App\Http\Controllers\ProductController::class,'load'])->name('loadProductProduct');

    Route::post('/add-product-items-save',[App\Http\Controllers\ProductController::class,'store'])->name('addProductMain');
    Route::get('/outlets', [App\Http\Controllers\GeneralController::class, 'index'])->name('outlets.index');
    Route::post('/branches/save-new',[App\Http\Controllers\GeneralController::class,'store'])->name('store.branch');
    Route::get('/branches/edit-branch/{branch}',[App\Http\Controllers\GeneralController::class,'edit'])->name('EditBranch');
    Route::get('/delete-branch/{branch}',[App\Http\Controllers\GeneralController::class,'destroy'])->name('destroy.branch');

    Route::post('/branches/save-update/{branch}',[App\Http\Controllers\BranchController::class,'update'])->name('SaveBranchChange');


    Route::get('/audit-activities/show', [App\Http\Controllers\UserActivityController::class, 'index'])->name('UserActivity.index');

    
    Route::get('/sales/transactions-cashier', [App\Http\Controllers\ItemController::class, 'salesTransactionsCashier'])->name('cashierReport');
    Route::get('/sales/transactions/customer/{customer}', [App\Http\Controllers\ItemController::class, 'salesTransactions'])->name('salesTransactions');


    Route::get('/reverse/manufacturing/{ManufacturingHistory}', [App\Http\Controllers\ItemController::class, 'reverseManufacturing'])->name('reverseManufacturing');
    Route::get('/reverse/manufacturing-sort', [App\Http\Controllers\ItemController::class, 'ManCorrectDate'])->name('ManCorrectDate');

    Route::get('/menu-item/bill-material',[App\Http\Controllers\ItemController::class,'productSettings'])->name('productSettings');

    Route::post('/stock-item-save/{id}',[App\Http\Controllers\ItemController::class,'updateItem'])->name('updateItem');

    
    
    Route::get('/menu-item/bill-material/export',[App\Http\Controllers\ItemController::class,'exportBOM'])->name('exportBOM');

    Route::get('/transaction/top-customer',[App\Http\Controllers\ItemController::class,'TopCustomer'])->name('TopCustomer');
    
    Route::post('/add-product-items',[App\Http\Controllers\ItemController::class,'makechangesMenu'])->name('makechangesMenu');
    Route::post('/edit-product-here/{id}',[App\Http\Controllers\ProductController::class,'productEdit'])->name('EditProduct');


    Route::get('/activate-items',[App\Http\Controllers\ItemController::class,'ActivateItems'])->name('ActivateItems');


    Route::get('/cashout-riders', [App\Http\Controllers\GeneralController::class, 'Cashout'])->name('Cashout');

    

    Route::post('/edit-product-here/{id}',[App\Http\Controllers\ProductController::class,'productEdit'])->name('EditProduct');
    Route::post('/product-composing-save',[App\Http\Controllers\MaterialProductCompositonController::class,'create'])->name('MaterialProductCompositon');
    Route::post('/activate-product/branches',[App\Http\Controllers\ProductController::class,'activateProduct'])->name('activateProduct');



    
    Route::get('/items/product-services', [App\Http\Controllers\ItemController::class, 'EditMenu'])->name('EditMenu');
    Route::get('/stocks', [App\Http\Controllers\ItemController::class, 'index'])->name('item.index');
    Route::post('/item-save',[App\Http\Controllers\ItemController::class,'store'])->name('addProduct');
    Route::post('/item/make-changes/{appdata}',[App\Http\Controllers\ItemController::class,'ChangeProduct'])->name('ChangeProduct');
    Route::get('/remove-item-from-store/{item}', [App\Http\Controllers\ItemController::class, 'destroy'])->name('item.destroystore');
    Route::get('/item-add-composing/{id}/{name}',[App\Http\Controllers\ItemController::class,'addCompositionToProduct'])->name('addCompositionToProduct');
    Route::get('/get-unit/{id}',[App\Http\Controllers\ItemController::class,'getUnit']);
    Route::get('/items/manufacturing-products',[App\Http\Controllers\ItemController::class,'manufacturing'])->name('manufacturing');
    Route::post('/items/manufacturing/prepare-product',[App\Http\Controllers\ItemController::class,'ManufacturingPrepare'])->name('ManufacturingPrepare');

    Route::post('/items/manufacturing/prepare-product-single',[App\Http\Controllers\ItemController::class,'manufactureSingle'])->name('manufactureSingle');

    
    Route::get('/items/history',[App\Http\Controllers\ItemController::class,'ItemHistory'])->name('productHistory');
    Route::get('/item-history/{item}',[App\Http\Controllers\ItemController::class,'FItemHistoryLoad']);
    Route::get('/items/history-print/{item_id}',[App\Http\Controllers\ItemController::class,'ItemHistoryPrint'])->name('ItemHistoryPrint');


    Route::get('/items/manufacturing-cost-print',[App\Http\Controllers\ItemController::class,'ManufacturingDatePrint'])->name('ManufacturingDatePrint');

    Route::post('/load-products',[App\Http\Controllers\ItemController::class,'load'])->name('loadProduct');
});

Route::post('/update-profile/{user}',[App\Http\Controllers\UserController::class,'updateUserProfile'])->name('updateUserProfile');







// DayClose
Route::prefix('dashboard')->group(function () {

    Route::get('/new-dayclose',[App\Http\Controllers\CloseDayController::class,'index'])->name('closeday.index');
    Route::post('/new-dayclose/save',[App\Http\Controllers\CloseDayController::class,'store'])->name('newDay.store');




    // KITCHEN ORDER DISPLAY FOR ALL OUTLET BASED
Route::get('/orders-display', function () {

    $getDayClose = \DB::table('close_days')->first();

    $collection = \DB::table('invoices')
     ->where('drive_thru_status', 0)
     ->where('branch', auth()->user()->branch)
     ->whereDate('created_at', $getDayClose->day_close)
     ->orderBy('created_at', 'ASC')
     ->paginate(1000);

     $grouped = $collection->groupBy('invoice_number');
     return view('delivery-orders-display', [
         'order' => $grouped
     ]);

})->middleware('auth')->name('KicthenDisplay');



    // CONFIRM ORDER IS READY
    Route::get('/complete/complete-transaction-waiting/{order}', function ($order) {

        $getDayClose = \DB::table('close_days')->first();
    
        Invoice::where('branch', auth()->user()->branch)
        ->where('drive_thru_status', 0)
        ->where('invoice_number', $order)
        ->whereDate('created_at', $getDayClose->day_close)
        ->update([
            'drive_thru_status' => 2
        ]);

        return 123;
    
    })->middleware('auth')->name('ReadyComplete');




        // PACKAGING ORDER DISPLAY FOR OUTLET BASED
    Route::get('/orders-display-packaging', function () {

    $getDayClose = \DB::table('close_days')->first();

        $collection = \DB::table('invoices')
        ->where('drive_thru_status', 2)
        ->where('branch', auth()->user()->branch)
        ->whereDate('created_at', $getDayClose->day_close)
        ->orderBy('created_at', 'ASC')
        ->paginate(1000);

        $grouped = $collection->groupBy('invoice_number');
        return view('packaging-orders-display', [
            'order' => $grouped
        ]);

    })->middleware('auth')->name('PackagingDisplay');





    // CONFIRM ORDER IS READY PACKAGEING
    Route::get('/complete/complete-transaction-waiting-packing/{order}', function ($order) {

        $getDayClose = \DB::table('close_days')->first();
    
        Invoice::where('branch', auth()->user()->branch)
        ->where('drive_thru_status', 2)
        ->where('invoice_number', $order)
        ->whereDate('created_at', $getDayClose->day_close)
        ->update([
            'drive_thru_status' => 1
        ]);

        return 123;
    
    })->middleware('auth')->name('PackagingDisplayReady');


});





// Item BOM Route
Route::prefix('dashboard')->group(function () {

    Route::get('/remove-BOM/{itemBOM}',[App\Http\Controllers\ItemBOMController::class,'destroy'])->name('DeleteBOM');
    Route::post('/item-save/bill-of-material',[App\Http\Controllers\ItemBOMController::class,'store'])->name('bom.store');
    Route::post('/mass-update-bom',[App\Http\Controllers\ItemBOMController::class,'changeBOM'])->name('changeBOM');
    Route::get('/report-item-specific-bom',[App\Http\Controllers\ItemBOMController::class,'itemBomReport'])->name('itemBomReport');
    Route::post('/import-bill-of-material',[App\Http\Controllers\ItemController::class,'ImportBillOfMaterial'])->name('ImportBillOfMaterial');

    Route::get('/new-proforma',[App\Http\Controllers\ProformaController::class,'index'])->name('proforma.index');
    Route::post('/delivery-location-to-dump',[App\Http\Controllers\InvoiceController::class,'locationPrice'])->name('locationPrice');
    Route::post('/generate-invoice/make-payment/delivery',[App\Http\Controllers\InvoiceController::class,'generateInvoicePayDelivery'])->name('generateInvoicePayDelivery');

    Route::post('/add-cart',[App\Http\Controllers\InvoiceController::class,'addCart'])->name('InvoiceDump');
    Route::post('/add-discount',[App\Http\Controllers\DiscountController::class,'store'])->name('OrderDiscount');
    Route::get('/create/invoice-dump/new-transaction',[App\Http\Controllers\InvoiceController::class,'destroy'])->name('deleteDump');
    Route::post('/accept-payment/tingg',[App\Http\Controllers\GeneralController::class,'AcceptPayment'])->name('AcceptPayment');

    Route::get('/place-order-hold-transaction',[App\Http\Controllers\InvoiceController::class,'HoldTransaction'])->name('HoldTransaction');
});

// COS Analysis Route
Route::prefix('dashboard')->group(function () {
    Route::get('/cost-of-sales-analysis/report-plain-view',[App\Http\Controllers\CostOfSaleAnalysisController::class,'PrintSalesAnalysis'])->name('PrintSalesAnalysis');
    Route::get('/cost-of-sales-analysis/report-plain-view/by-branch',[App\Http\Controllers\CostOfSaleAnalysisController::class,'PrintSalesAnalysisBranch'])->name('PrintSalesAnalysisBranch');

    Route::get('/cost-of-sales-analysis/report',[App\Http\Controllers\CostOfSaleAnalysisController::class,'index'])->name('cos.index');
    Route::get('/cost-of-sales-analysis/report-sort',[App\Http\Controllers\CostOfSaleAnalysisController::class,'costOfSalesAnalysis'])->name('costOfSalesAnalysis');

    Route::get('/cost-of-sales-analysis/detailed-report',[App\Http\Controllers\CostOfSaleAnalysisController::class,'costOfSalesAnalysisDetailed'])->name('costOfSalesAnalysisDetailed');
    Route::get('/cost-of-sales-analysis/detailed-report/sort',[App\Http\Controllers\CostOfSaleAnalysisController::class,'costOfSalesAnalysisDetailedSort'])->name('costOfSalesAnalysisDetailedSort');
    Route::get('/cost-of-sales-analysis/detailed-report/sort-by-branch/report',[App\Http\Controllers\CostOfSaleAnalysisController::class,'costOfSalesAnalysisDetailedSortBranch'])->name('costOfSalesAnalysisDetailedSortBranch');
    Route::get('/cost-of-sales-analysis/report-bybranch',[App\Http\Controllers\CostOfSaleAnalysisController::class,'costOfSalesAnalysisDetailedSortBranchOfficer'])->name('costOfSalesAnalysisDetailedSortBranchOfficer');
    
    Route::get('/cost-of-sales-analysis/re-run',[App\Http\Controllers\CostOfSaleAnalysisController::class,'AdjsutCostOfSales'])->name('costOfSalesAnalysisReRun');

    
});

// Stock Ledger Route
Route::prefix('dashboard')->group(function () {

    Route::get('/physical-cart/remove/{id}', [App\Http\Controllers\ItemStockLedgerController::class, 'DestroyPhysical'])->name('DestroyPhysical');
    
    Route::get('/report/detailed-item-stock-ledger', [App\Http\Controllers\ItemStockLedgerController::class, 'generateBuiltReport'])->name('generateBuiltReport');


    Route::get('/report/inventory/item-stock-ledger-print', [App\Http\Controllers\ItemStockLedgerController::class, 'PrintLedgerDateAllreport'])->name('PrintLedgerDateAllreport');


    Route::get('/report/inventory/item-stock-ledger', [App\Http\Controllers\ItemStockLedgerController::class, 'PhysicalStockReport'])->name('PhysicalStockReport');

    Route::get('/isl-all-outlet', [App\Http\Controllers\ItemStockLedgerController::class, 'LedgerAllBranch'])->name('LedgerAllBranch');


    Route::get('/delete-ledger-item/{ledger}', [App\Http\Controllers\ItemStockLedgerController::class, 'destroy'])->name('RemoveItem');

    Route::post('/item-stock-ledger/stock-import', [App\Http\Controllers\ItemStockLedgerController::class, 'importStock'])->name('ImportStock');

    Route::post('/import-stock',[App\Http\Controllers\ItemStockLedgerController::class,'importOpeningStock'])->name('importOpeningStock');

    Route::get('/item-stock-ledger/report', [App\Http\Controllers\ItemStockLedgerController::class, 'index'])->name('itemstockledger.index');

    Route::get('/item-stock-ledger/report-isl-view_transaction', [App\Http\Controllers\ItemStockLedgerController::class, 'viewStockTransaction'])->name('viewStockTransaction');

    Route::get('/item-stock-ledger/report-isl', [App\Http\Controllers\ItemStockLedgerController::class, 'showISL'])->name('itemstockledger.isl');
    Route::get('/build-report', [App\Http\Controllers\ItemStockLedgerController::class, 'BuildReport'])->name('BuildReport');
    Route::get('/item-stock-ledger/Hideen-items', [App\Http\Controllers\ItemStockLedgerController::class, 'HiddenItems'])->name('HiddenItems');

    
    Route::get('/item-stock-ledger/print-stock-isl', [App\Http\Controllers\ItemStockLedgerController::class, 'PrintStockHistory'])->name('PrintStockHistory');

    Route::get('/item-stock-ledger/print-stock-isl-show', [App\Http\Controllers\ItemStockLedgerController::class, 'PrintStockHistoryDate'])->name('PrintStockHistoryDate');

    Route::get('/item-stock-ledger/report-isl-stock-filter-print', [App\Http\Controllers\ItemStockLedgerController::class, 'StockFilterPrint'])->name('StockFilterPrint');

    Route::get('/item-stock-ledger/report-isl-stock-filter', [App\Http\Controllers\ItemStockLedgerController::class, 'StockFilter'])->name('StockFilter');
    Route::get('/item-stock-ledger/report-isl-stock-filter-wastage-report', [App\Http\Controllers\ItemStockLedgerController::class, 'productHistoryDescription'])->name('productHistoryDescription');


Route::get('/item-stock-ledger/report/sorting-summary', [App\Http\Controllers\ItemStockLedgerController::class, 'stockLedgerSortSummary'])->name('stockLedgerSortSummary');

Route::get('/item-stock-ledger/reloadLedger-manufacturing', [App\Http\Controllers\ItemStockLedgerController::class, 'manufacturingReload'])->name('manufacturingReload');

Route::get('/item-stock-ledger/reloadLedger', [App\Http\Controllers\ItemStockLedgerController::class, 'reloadLedger'])->name('reloadLedger');


Route::get('/item-stock-ledger/reload-day-close', [App\Http\Controllers\ItemStockLedgerController::class, 'OpenStockReloadNewDay'])->name('OpenStockReloadNewDay');

Route::get('/item-stock-ledger/reload-opening-stock', [App\Http\Controllers\ItemStockLedgerController::class, 'OpenStockReload'])->name('OpenStockReload');
Route::get('/item-stock-ledger/reload-physical-stock', [App\Http\Controllers\ItemStockLedgerController::class, 'OpenStockReloadManual'])->name('OpenStockReloadManual');

    Route::get('/item-stock-ledger/report/sorting', [App\Http\Controllers\ItemStockLedgerController::class, 'stockLedgerSort'])->name('stockLedgerSort');

    Route::get('/item-stock-ledger/report/sorting-isl-tem', [App\Http\Controllers\ItemStockLedgerController::class, 'IslTemporal'])->name('IslTemporal');

    
    Route::get('/trash-bucket/sorting', [App\Http\Controllers\ItemStockLedgerController::class, 'trashSort'])->name('trashSort');
    Route::get('/item-stock-ledger/stock-limits', [App\Http\Controllers\ItemStockLedgerController::class, 'stockLimit'])->name('stockLimit');
    Route::post('/stock-limit/create', [App\Http\Controllers\ItemStockLedgerController::class, 'saveStockLimt'])->name('saveStockLimt');
    Route::get('/item-stock-ledger/closing-stocks', [App\Http\Controllers\ItemStockLedgerController::class, 'closingStocks'])->name('closingStocks');
    Route::get('/item-stock-ledger/closing-stocks-print-view', [App\Http\Controllers\ItemStockLedgerController::class, 'closingStocksPrint'])->name('closingStocksPrint');
    
    Route::get('/item-stock-ledger/closing-stocks/sort', [App\Http\Controllers\ItemStockLedgerController::class, 'ClosingStockDate'])->name('ClosingStockDate');


    Route::get('/item-stock-ledger/report/view-printable-report', [App\Http\Controllers\ItemStockLedgerController::class, 'PrintLedger'])->name('PrintLedger');
    Route::get('/item-stock-ledger/report-summary/view-printable-report', [App\Http\Controllers\ItemStockLedgerController::class, 'PrintLedgerSummary'])->name('PrintLedgerSummary');
    Route::get('/item-stock-ledger/report-summary/view-printable-report-date', [App\Http\Controllers\ItemStockLedgerController::class, 'PrintLedgerSummaryDate'])->name('PrintLedgerSummaryDate');


    Route::post('/update-opening-stock/upsave', [App\Http\Controllers\ItemStockLedgerController::class, 'updateOpening'])->name('openingSto');

    Route::get('/update-opening-stock', [App\Http\Controllers\ItemStockLedgerController::class, 'openingStock'])->name('openingStock');
    

    Route::get('/trash-buscket', [App\Http\Controllers\ItemStockLedgerController::class, 'trash'])->name('itemstockledger.trash');
    Route::post('/trash-busket/save', [App\Http\Controllers\ItemStockLedgerController::class, 'saveWastage'])->name('save.wastage');
    Route::get('/physical-stock/save', [App\Http\Controllers\ItemStockLedgerController::class, 'savephysicalStock'])->name('save.physical');
    Route::post('/physical-stock/save/adjustment', [App\Http\Controllers\ItemStockLedgerController::class, 'savephysicalStockAdjust'])->name('savephysicalStockAdjust');

    Route::post('/adjusted-stock/save', [App\Http\Controllers\ItemStockLedgerController::class, 'saveAdjustedStock'])->name('save.Adjust');
    
    Route::get('/adjusted-stock/save-by-date', [App\Http\Controllers\ItemStockLedgerController::class, 'AdjustDate'])->name('AdjustDate');


    Route::get('/physical-stock', [App\Http\Controllers\ItemStockLedgerController::class, 'physicalStock'])->name('itemstockledger.physicalstock');
    Route::get('/physical-stock/sort', [App\Http\Controllers\ItemStockLedgerController::class, 'physicalStockDate'])->name('physicalStockDate');

    Route::post('/add-list/adjustment', [App\Http\Controllers\ItemStockLedgerController::class, 'AddlistAdjustment'])->name('Adjustment.store');
    Route::get('/clear/phyiscal', [App\Http\Controllers\ItemStockLedgerController::class, 'clearPhysical'])->name('clearPhysical');

   
    Route::get('/adjustment', [App\Http\Controllers\ItemStockLedgerController::class, 'adjustment'])->name('adjustment');

    Route::get('/wastage/cost', [App\Http\Controllers\ItemStockLedgerController::class, 'WastageCost'])->name('WastageCost');
    Route::get('/wastage/cost/print-report', [App\Http\Controllers\ItemStockLedgerController::class, 'PrintLedgerSummaryWastage'])->name('PrintLedgerSummaryWastage');


    Route::get('/wastage/cost/sorting-summary', [App\Http\Controllers\ItemStockLedgerController::class, 'stockLedgerSortSummaryWastage'])->name('stockLedgerSortSummaryWastage');


});


// Issue Vocher Route
Route::prefix('dashboard')->group(function () {


    
    Route::get('/make-change-voucher/{transaction}', [App\Http\Controllers\IssueVoucherController::class, 'makeChanges'])->name('makeChangesVoucher');

    Route::get('/make-transfer/save-print', [App\Http\Controllers\IssueVoucherController::class, 'SavePrintVoucher'])->name('SavePrintVoucher');
    Route::get('/print-voucher-new/{transaction}', [App\Http\Controllers\IssueVoucherController::class, 'PrintV'])->name('PrintV');

    Route::get('/voucher/view-list/incoming', [App\Http\Controllers\IssueVoucherController::class, 'voucherIncoming'])->name('voucherIncoming');
    Route::get('/voucher/view-list', [App\Http\Controllers\IssueVoucherController::class, 'voucherList'])->name('voucherList');
    Route::get('/voucher/new-voucher', [App\Http\Controllers\IssueVoucherController::class, 'index'])->name('issuevocher.index');
    Route::post('/voucher/store', [App\Http\Controllers\IssueVoucherController::class, 'store'])->name('issuevocher.store');
    Route::get('/voucher/store-confirm', [App\Http\Controllers\IssueVoucherController::class, 'confirmIssue'])->name('saveIssueVoucher');
    Route::get('/voucher/transaction/{transaction}', [App\Http\Controllers\IssueVoucherController::class, 'viewVoucher'])->name('viewVoucher');
    Route::get('/voucher/transaction-authorize/{transaction}', [App\Http\Controllers\IssueVoucherController::class, 'viewVoucherAuthorize'])->name('viewVoucherAuthorize');
    
    Route::get('/voucher/reject/{item}', [App\Http\Controllers\IssueVoucherController::class, 'RejectVoucherItem'])->name('RejectVoucherItem');
    Route::get('/voucher/reverse-transaction/{invoice_number}', [App\Http\Controllers\IssueVoucherController::class, 'ReverseVoucher'])->name('ReverseVoucher');

    // Route::post('/change-status',[App\Http\Controllers\InvoiceController::class,'changeInvoiceStatus'])->name('changeInvoiceStatus');


    Route::get('/search', [App\Http\Controllers\GeneralController::class, 'SearchProduct'])->name('SearchProduct')->middleware(['auth', 'verified']);



    Route::get('/search-order', function(Request $request){
        $detail_order = \DB::table('invoices')->where('invoice_number', request('search'))->get();
        $customer = \DB::table('orders')->where('order_id', request('search'))->first();
        
        if (!$customer) {
            return back()->with('status', 'Receipt Not found');
        }
        $customer_id = $customer -> customer_id;
        return view('order-transactions', [
            'orders' => $detail_order,
            'invoice_number' => request('search'),
            'customer_id' => $customer_id
        ]);
    })->name('SearchOrder')->middleware('auth');

    Route::get('/orders',[App\Http\Controllers\OrderController::class,'AllOrders'])->name('AllOrders');

    Route::post('/change-status',[App\Http\Controllers\OrderController::class,'changeInvoiceStatus'])->name('changeInvoiceStatus');
    Route::get('/customer/transaction/view-customer/{id}',[App\Http\Controllers\CustomerController::class,'transactionsDetails'])->name('orders.customer');
    Route::get('/customer-listing',[App\Http\Controllers\CustomerController::class,'showCustomer'])->name('showCustomer');
    Route::get('/customer-list/transactions-today',[App\Http\Controllers\CustomerController::class,'showNewAndTransactions'])->name('showNewAndTransactions');
    Route::post('/import-customer',[App\Http\Controllers\CustomerController::class,'ImportCustomer'])->name('importCustomer');
    Route::post('/save-customer',[App\Http\Controllers\CustomerController::class,'store'])->name('customer');
    Route::get('/customer-list/transactions-by-all',[App\Http\Controllers\CustomerController::class,'customerReportDate'])->name('customerReportDate');

    
    Route::get('/order/transaction-details/{order}',[App\Http\Controllers\OrderController::class,'show'])->name('orderTransaction');
    Route::get('/invoice/{order}/{customer_id}',[App\Http\Controllers\OrderController::class,'PrintInvoice'])->name('PrintInvoice');

    Route::post('/save-reviews',[App\Http\Controllers\RemarkController::class,'store'])->name('saveRemark');


    Route::get('/search-transaction-all-orders', function(Request $request){
        
            $transactions = \DB::table('orders')
            ->where('branch', request('branch'))
            ->WhereDate('created_at','>=', request('start_date'))
            ->WhereDate('created_at','<=', request('end_date'))
            ->get();
      
        
        return view('all-orders-tr', [
            'all_sales' => $transactions
        ]);
    })->name('SearchOrderTransactions')->middleware('auth');


    Route::post('/voucher/accept-voucher', [App\Http\Controllers\IssueVoucherController::class, 'AcceptVoucher'])->name('AcceptVoucher');
    Route::post('/voucher/accept-rejected-item', [App\Http\Controllers\IssueVoucherController::class, 'AcceptRejected'])->name('AcceptRejected');

    Route::get('/voucher/accept-voucher/reload', [App\Http\Controllers\IssueVoucherController::class, 'IssueRecieveRun'])->name('IssueRecieveRun');

    
    Route::post('/voucher/accept-voucher-admin', [App\Http\Controllers\IssueVoucherController::class, 'AcceptVoucherAdmin'])->name('AcceptVoucherAdmin');
    Route::get('/voucher/list/authorised-pending-transactions', [App\Http\Controllers\IssueVoucherController::class, 'voucherAuthorize'])->name('voucherAuthorize');
    Route::get('/voucher/list/authorised-transactions', [App\Http\Controllers\IssueVoucherController::class, 'approvedVoucherAdmin'])->name('approvedVoucherAdmin');

    Route::get('/voucher/approved-by-admin-date', [App\Http\Controllers\IssueVoucherController::class, 'Apporvedbydate'])->name('Apporvedbydate');

    Route::get('/voucher/clear-voucher', [App\Http\Controllers\IssueVoucherController::class, 'clearVoucher'])->name('clearVoucher');
    Route::get('/voucher/incoming/sorting', [App\Http\Controllers\IssueVoucherController::class, 'getIncomingVoucherReport'])->name('getIncomingVoucherReport');
    Route::get('/voucher/outgoing/sorting', [App\Http\Controllers\IssueVoucherController::class, 'getOutgoingVoucherReport'])->name('getOutgoingVoucherReport');
    Route::get('/voucher/delete-voucher/{id}', [App\Http\Controllers\IssueVoucherController::class, 'destroyVoucher']);

    Route::get('/voucher/recieved-report-print', [App\Http\Controllers\InventoryReportController::class, 'IssueRecievedPrint'])->name('IssueRecievedPrint');

    Route::get('/voucher/recieved-report', [App\Http\Controllers\InventoryReportController::class, 'issueRecieved'])->name('issueRecieved');

    Route::get('/voucher/recieved-report/sort-by', [App\Http\Controllers\InventoryReportController::class, 'IssueReceiveDate'])->name('IssueReceiveDate');

    Route::get('/voucher/register-report', [App\Http\Controllers\InventoryReportController::class, 'issueRegister'])->name('issueRegister');
    Route::get('/voucher/register-report-by-date', [App\Http\Controllers\InventoryReportController::class, 'issueRegisterDate'])->name('issueRegisterDate');
    Route::get('/voucher/register-report/store-wise', [App\Http\Controllers\InventoryReportController::class, 'StoreWiseIssueRegister'])->name('StoreWiseIssueRegister');
   
    Route::get('/voucher/register-report/store-wise-date', [App\Http\Controllers\InventoryReportController::class, 'storewiseDate'])->name('storewiseDate');
    Route::get('/voucher/register-report/store-wise-date-by-item', [App\Http\Controllers\InventoryReportController::class, 'IssueRegisterStoreWise'])->name('IssueRegisterStoreWise');
    Route::get('/voucher/register-report/print-show-report', [App\Http\Controllers\InventoryReportController::class, 'IssueRegisterPrint'])->name('IssueRegisterPrint');

    Route::get('/manufacturing-cost', [App\Http\Controllers\InventoryReportController::class, 'manufacturingCost'])->name('manufacturingCost');
    Route::get('/manufacturing-cost/sort', [App\Http\Controllers\InventoryReportController::class, 'ManufacturingCostDate'])->name('ManufacturingCostDate');
    
 
});


// Unit Conversion Route
Route::prefix('dashboard')->group(function () {
    Route::post('/conversion-unit/save', [App\Http\Controllers\UnitConversionController::class, 'store'])->name('conversionUnit.store');
    Route::get('/conversion-unit/delete/{unitConversion}', [App\Http\Controllers\UnitConversionController::class, 'destroy'])->name('conversionUnit.destroy');

});


// Supplier Docks Route
Route::prefix('dashboard')->group(function () {
    Route::get('/goods-recieve-note', [App\Http\Controllers\SupplierDocksController::class, 'index'])->name('warehousedocks.index');

});


Route::get('/complete/held-transaction/{order_id}',[App\Http\Controllers\GeneralController::class,'CompletePay'])->name('CompletePay')->middleware('auth');


// Purchases
Route::prefix('dashboard')->group(function () {
    Route::get('/purchases/bill', [App\Http\Controllers\PurchaseController::class, 'index'])->name('purchase.index');
    Route::post('/save-purchase-item', [App\Http\Controllers\PurchaseController::class, 'store'])->name('purchase.store');
    Route::post('/purchases/save-print', [App\Http\Controllers\PurchaseController::class, 'savePurchasePrint'])->name('savePurchasePrint');
    Route::get('/purchases/save-purchases', [App\Http\Controllers\PurchaseController::class, 'savePurchase'])->name('savePurchase');
    Route::get('/purchases/adjust-rates', [App\Http\Controllers\PurchaseController::class, 'AdjustPurchase'])->name('AdjustPurchase');
    Route::post('/purchases/adjust-rates/save', [App\Http\Controllers\PurchaseController::class, 'AdjustPurchaseSave'])->name('save.adjustprice');

    Route::post('/purchases/adjust-rates/update-cost', [App\Http\Controllers\PurchaseController::class, 'UpdateRate'])->name('UpdateRate');

    

    Route::get('/report-purchase-print', [App\Http\Controllers\PurchaseController::class, 'PrintPurchasesType'])->name('PrintPurchasesType');

    
    Route::post('/save-purchase-item-activate', [App\Http\Controllers\PurchaseController::class, 'ActivateProduct'])->name('ActivateProduct');

    
    
    Route::get('/purchase-invoice/{transaction}', [App\Http\Controllers\PurchaseController::class, 'show'])->name('purchase.show');
    Route::get('/purchases/{transaction}/downloadandprint', [App\Http\Controllers\PurchaseController::class, 'downloadPrintPurchase'])->name('downloadPrintPurchase');
    Route::get('/purchase-dock/remove/{purchase}', [App\Http\Controllers\PurchaseController::class, 'destroy'])->name('DeletePurchase');
    Route::get('/purchases/clear', [App\Http\Controllers\PurchaseController::class, 'clearPurchase'])->name('clearPurchase');
    Route::get('purchase/bill/list', [App\Http\Controllers\PurchaseController::class, 'showAll'])->name('showAll.purchase');

    Route::get('/purchases/view-date/sort-by-type', [App\Http\Controllers\PurchaseController::class, 'PurchaseListDateType'])->name('PurchaseListDateType');

    Route::get('/purchases/view-date/sort', [App\Http\Controllers\PurchaseController::class, 'PurchaseListDate'])->name('PurchaseListDate');
    
    Route::get('/customer-note/{note}', function(Request $request, $note){
            $request->session()->put('purchase_note', $note);
    });

    Route::post('/settings/app-settings/update/{setting}', [App\Http\Controllers\SettingController::class, 'update'])->name('updateSettings');
    Route::get('/settings/app-settings', [App\Http\Controllers\SettingController::class, 'index'])->name('index.settings');
    Route::post('/settings/app-settings/save', [App\Http\Controllers\SettingController::class, 'store'])->name('saveSettings');
    Route::get('/change_inventory-status', [App\Http\Controllers\SettingController::class, 'ChangeSTatus'])->name('ChangeSTatus');
    Route::get('/enable-issue-check', [App\Http\Controllers\SettingController::class, 'ChangeSTatusIssue'])->name('ChangeSTatusIssue');
    Route::get('/enable-production-check', [App\Http\Controllers\SettingController::class, 'ChangeSTatusProduction'])->name('ChangeSTatusProduction');


    

});



// vendor Routes
Route::prefix('dashboard')->group(function () {
    Route::get('/vendors/delete-vendor/{vendors}', [App\Http\Controllers\VendorsController::class, 'destroy'])->name('DeleteVendor');

    Route::get('/vendors', [App\Http\Controllers\VendorsController::class, 'index'])->name('vendor.index');
    Route::post('/vendors/save', [App\Http\Controllers\VendorsController::class, 'store'])->name('vendor.store');

    
});


Route::prefix('dashboard')->group(function () {

    Route::get('/account/control-account/{id}', [App\Http\Controllers\ControlAccountController::class, 'show'])->name('ControlSub');
    Route::get('/account/cash-and-bank', [App\Http\Controllers\ControlAccountController::class, 'CashBanking'])->name('CashBanking');
    Route::get('/account/petty-cash', [App\Http\Controllers\ControlAccountController::class, 'PettyCash'])->name('PettyCash');

    Route::get('/account/reports', [App\Http\Controllers\AccountController::class, 'BookkeepingRe'])->name('BookkeepingRe');

    
    

    Route::post('/account/save-control-account', [App\Http\Controllers\ControlAccountController::class, 'store'])->name('SaveControlAccount');

    Route::get('/accounts/list-account/chart-of-account', [App\Http\Controllers\PaymentAccountController::class, 'chartAccount'])->name('chartAccount');

    Route::get('/create-invoice-delivery',[App\Http\Controllers\CustomerController::class,'newSale'])->name('newSales');

    Route::get('/customer-statement/{customer_id}',[App\Http\Controllers\CustomerController::class,'index'])->name('index.customer');
    Route::get('/customer-list',[App\Http\Controllers\CustomerController::class,'show'])->name('show.customer');
    Route::post('/accounts/payment-methods-create', [App\Http\Controllers\PaymentAccountController::class, 'NewPaymentMethod'])->name('NewPaymentMethod');
    Route::get('/accounts/new-payment-methods', [App\Http\Controllers\PaymentAccountController::class, 'paymentIndex'])->name('paymentIndex');
    Route::get('/account/delete-payment-method/{PaymentMethod}', [App\Http\Controllers\PaymentAccountController::class, 'paymentDestroy'])->name('paymentDestroy');
    

    Route::get('/accounts/summary-of-account', [App\Http\Controllers\PaymentAccountController::class, 'summaryAccount'])->name('summaryAccount');
    Route::get('/accounts/list-account', [App\Http\Controllers\PaymentAccountController::class, 'index'])->name('payaccount.index');
    Route::post('/accounts/create-account-type', [App\Http\Controllers\PaymentAccountController::class, 'create'])->name('accounttype.index');
    Route::get('/account-type/remove/{accountType}', [App\Http\Controllers\PaymentAccountController::class, 'destroy'])->name('accounttype.destroy');

    Route::post('/account/new-account', [App\Http\Controllers\AccountController::class, 'create'])->name('account.index');
    Route::get('/account/account-books/{account}', [App\Http\Controllers\AccountController::class, 'transactions'])->name('AccountBooks');

    Route::get('/account/control-account/{account}', [App\Http\Controllers\AccountController::class, 'AccountBooksSub'])->name('AccountBooksSub');


    
    Route::get('/account/account-books/print/{account}', [App\Http\Controllers\AccountController::class, 'printAccountBooks'])->name('printAccountBooks');
    
    Route::get('/account/account-books/print/{account}', [App\Http\Controllers\AccountController::class, 'printAccountBooks'])->name('printAccountBooks');
    Route::get('/account/create-vendor-account', [App\Http\Controllers\AccountController::class, 'VendorAccount'])->name('VendorAccount');

    
    Route::get('/account-books/filter', [App\Http\Controllers\AccountController::class, 'AccountFilter'])->name('AccountFilter');
    Route::get('/account-books/filter/print', [App\Http\Controllers\AccountController::class, 'AccountFilterPrint'])->name('AccountFilterPrint');

    Route::get('/account-books/bookkeeping/filter-report', [App\Http\Controllers\AccountController::class, 'AccountFilterMain'])->name('AccountFilterMain');

    Route::get('/account-books/bookkeeping/bank-summary-report', [App\Http\Controllers\AccountController::class, 'BankAccountSummary'])->name('BankAccountSummary');

    
    Route::get('/account/delete-account/{account}', [App\Http\Controllers\AccountController::class, 'destroy'])->name('DeleteAccount');
    Route::post('/account/update/{account}', [App\Http\Controllers\AccountController::class, 'update'])->name('account.update');


    Route::post('/account/transfer-funds/{account}', [App\Http\Controllers\AccountController::class, 'FundsTransfer'])->name('FundsTransfer');
    Route::post('/account/deposit/{account}', [App\Http\Controllers\AccountController::class, 'Deposit'])->name('Deposit');

    Route::get('/account/cashflow', [App\Http\Controllers\AccountController::class, 'cashFlow'])->name('cashFlow');
    
    Route::post('/account/link-sales', [App\Http\Controllers\AccountController::class, 'linkSalesToAccount'])->name('linkSalesToAccount');


    Route::get('/account/trial-balance', [App\Http\Controllers\AccountController::class, 'TrialBalance'])->name('trial.index');
    Route::get('/account/trial-balance/print', [App\Http\Controllers\AccountController::class, 'TrialBalancePrint'])->name('TrialBalancePrint');

    Route::get('/account/non-linked-transaction', [App\Http\Controllers\AccountController::class, 'NonLinked'])->name('NonLinked');

    Route::get('/account/transactions', [App\Http\Controllers\AccountController::class, 'AccountTransaction'])->name('AccountTransaction');
    Route::get('/account/transaction/delete/{id}', [App\Http\Controllers\AccountController::class, 'DeleteTransaction'])->name('DeleteTransactions');

    Route::get('/account/transactions/new-income', [App\Http\Controllers\AccountController::class, 'income'])->name('income');
    Route::post('/account/transactions/create/income', [App\Http\Controllers\AccountController::class, 'incomeReceive'])->name('incomeReceive');

    Route::get('/account/transactions/new-payment-to-supplier', [App\Http\Controllers\AccountController::class, 'paySupplier'])->name('paySupplier');


    Route::get('/account/link-sales-to-account', [App\Http\Controllers\AccountController::class, 'LinkSales'])->name('LinkSales');

   
});


// Warehouse Routes
Route::prefix('dashboard')->group(function () {

    Route::get('/warehouse', [App\Http\Controllers\WarehouseController::class, 'index'])->name('warehouse.index');
    Route::post('/warehouse/save', [App\Http\Controllers\WarehouseController::class, 'store'])->name('warehouse.store');
    Route::get('/warehouse/remove/{warehouse}', [App\Http\Controllers\WarehouseController::class, 'destroy'])->name('deleteWarehouse');

    Route::get('/cost-changing', function(){
        $app = \DB::table('settings')->first();
        $dayClose = \DB::table('close_days')->first();

        $items = \DB::table('item_stock_ledgers')->where('station', $app->main_warehouse)
        ->whereDate('date', request('date'))->get();

        foreach ($items as $key => $items) {
            

             \DB::table('item_stock_ledgers')
            ->whereDate('date', $dayClose->day_close)
            ->where('item_id', $items->item_id)
            ->update([
                'item_cost' => $items->item_cost
            ]);

            \DB::table('issue_vouchers')
            ->whereDate('issue_date', '>', request('date'))
            ->where('issue_item_id', $items->item_id)
            ->update([
                'issue_rate' => $items->item_cost,
                'issue_total_cost' => \DB::raw('issue_quantity *' . $items->item_cost)
            ]);


        }


        return back()->with('status','Price Adjusted successfully');

        
    })->name('AdCost');
    
});


// Warehouse Routes
Route::prefix('dashboard')->group(function () {

    Route::get('/category', [App\Http\Controllers\CategoryController::class, 'index'])->name('category.index');
    Route::post('/category/save', [App\Http\Controllers\CategoryController::class, 'store'])->name('category.store');
    Route::get('/category/delete/{category}', [App\Http\Controllers\CategoryController::class, 'destroy'])->name('DeleteCategory');

});

// Kitchen Routes
Route::prefix('dashboard')->group(function () {
    Route::post('/kitchens/save', [App\Http\Controllers\KitchenController::class, 'store'])->name('kitchen.store');
    Route::get('/kitchens/central', [App\Http\Controllers\KitchenController::class, 'index'])->name('kitchen.index');
    Route::get('/kitchens/satellite', [App\Http\Controllers\KitchenController::class, 'indexSatellite'])->name('kitchen.satellite');
    Route::get('/kitchens/satellite/delete-kitchen/{kitchen}', [App\Http\Controllers\KitchenController::class, 'deleteKitchen'])->name('deleteKitchen');

    Route::get('/report/summary-sales', [App\Http\Controllers\KitchenController::class, 'SalesReportSummary'])->name('SalesReportSummary');

    
    Route::get('/revenue/summary', [App\Http\Controllers\KitchenController::class, 'revenueSummary'])->name('revenueSummary');
    Route::get('/revenue/tax-summary-report', [App\Http\Controllers\KitchenController::class, 'revenueSummaryTax'])->name('revenueSummaryTax');
    Route::get('/profit-sales/report', [App\Http\Controllers\KitchenController::class, 'ProfitSales'])->name('ProfitSales');

    Route::get('/income-statement', [App\Http\Controllers\KitchenController::class, 'IncomeStatement'])->name('IncomeStatement');

    Route::get('/income-statement/detailed/{category}', [App\Http\Controllers\KitchenController::class, 'IncomeStatementCategory'])->name('IncomeStatementCategory');

    Route::get('/account/transactions/{branch}', [App\Http\Controllers\KitchenController::class, 'invoiceTransactions'])->name('invoiceTransactions');


    Route::get('/balance-sheet', [App\Http\Controllers\KitchenController::class, 'BalanceSheet'])->name('BalanceSheet');

});


// Users Routes
Route::prefix('dashboard')->group(function () {


    Route::get('/dispatch',[App\Http\Controllers\DispatchItemController::class,'index'])->name('index.dispatchItem');
    Route::post('/save-dispatch-location',[App\Http\Controllers\DispatchItemController::class,'loadLocations'])->name('loadLocations');
    Route::post('/dispatch-items/delete-all',[App\Http\Controllers\DispatchItemController::class,'DeleteDispatchItem'])->name('DeleteDispatchItem');
    Route::post('/save-dispatch-location/update-price/{dispatachtem}',[App\Http\Controllers\DispatchItemController::class,'updateDispatch'])->name('updateDispatch');
    Route::post('/dispatch/save-data',[App\Http\Controllers\DispatchItemController::class,'store'])->name('store.dispatchItem');

    Route::get('/remove-product-from-list/{id}',[App\Http\Controllers\ProductController::class,'removeItem'])->name('removeItem');

    Route::get('/ceqa-dashboard/brands', [App\Http\Controllers\BrandController::class,'index'])->name('brand.index');
    Route::get('/ceqa-dashboard/brands/destroy/{brand_name:id}', [App\Http\Controllers\BrandController::class,'destroy'])->name('brand.destroy');
    
    Route::post('/ceqa-dashboard/brands/save', [App\Http\Controllers\BrandController::class,'create'])->name('brand.create');
    Route::post('/ceqa-dashboard/brands/update/{brand}', [App\Http\Controllers\BrandController::class,'update'])->name('brand.update');

    Route::get('/product-composing/delete-composition-item/{materialProductCompositon}',[App\Http\Controllers\MaterialProductCompositonController::class,'destroy'])->name('removeProductComposition');
    
    Route::post('/update-profile-assigned-to-inventory/{user}',[App\Http\Controllers\UserController::class,'AssignStore'])->name('AssignStore');

    Route::post('/change-account/{user}',[App\Http\Controllers\UserController::class,'changePasswordUser'])->name('changePasswordUser');
    Route::get('/users', [App\Http\Controllers\UserController::class, 'index'])->name('user.index')->middleware('auth');;
    Route::post('/change-password/{id}',[App\Http\Controllers\UserController::class,'changePassword'])->name('changePassword');
    Route::get('/users/view-profile/{user}',[App\Http\Controllers\UserController::class,'edit'])->name('editUser');
   
    Route::post('/users/save-user',[App\Http\Controllers\UserController::class,'Newregister'])->name('Newregister');
    Route::get('/branches/view-branch-sales',[App\Http\Controllers\BranchController::class,'branchSale'])->name('branchSales')->middleware('auth');

    Route::post('/product-composing-save',[App\Http\Controllers\MaterialProductCompositonController::class,'create'])->name('MaterialProductCompositon')->middleware('auth');

    Route::post('/branches/save-update/{branch}',[App\Http\Controllers\GeneralController::class,'update'])->name('SaveBranchChange')->middleware('auth');;

    Route::get('/held-transactions', [App\Http\Controllers\GeneralController::class, 'HeldTransaction'])->name('HeldTransaction')->middleware('auth');
    Route::get('/held-transactions/completed', [App\Http\Controllers\GeneralController::class, 'HeldTransactionComplete'])->name('HeldTransactionComplete')->middleware('auth');

    
    Route::post('/held-transactions-pay', [App\Http\Controllers\GeneralController::class, 'ConfirmHeldPay'])->name('ConfirmHeldPay')->middleware('auth');
    
    
    Route::get('/report/branch-summary-by-user/{id}',[App\Http\Controllers\GeneralController::class,'PrintSummaryBranchUser'])->name('PrintSummaryBranchUser')->middleware('auth');
    Route::get('/report/branch-summary',[App\Http\Controllers\GeneralController::class,'PrintSummaryBranch'])->name('PrintSummaryBranch')->middleware('auth');
    Route::get('/sales-report',[App\Http\Controllers\GeneralController::class,'salesReport'])->name('salesReport')->middleware('auth');
    Route::get('/report',[App\Http\Controllers\GeneralController::class,'reportByDate'])->name('dateReport')->middleware('auth');
    Route::get('/report/sales-person/category-view-by-date',[App\Http\Controllers\GeneralController::class,'getDeliveryReportDate'])->name('getDeliveryReportDate');

    Route::get('/department-view-all',[App\Http\Controllers\GeneralController::class,'allDepartmentSummary'])->name('allDepartmentSummary')->middleware('auth');;
    Route::get('/department-summary/date-view',[App\Http\Controllers\GeneralController::class,'showDepartmentItemDate'])->name('showDepartmentItemDate')->middleware('auth');;
    Route::get('/item-view-all',[App\Http\Controllers\GeneralController::class,'allItemSummary'])->name('allItemSummary')->middleware('auth');;


    Route::get('/discounts/gift-card-and-coupons',[App\Http\Controllers\CelebrityDiscountController::class,'index'])->name('celebrity.index');
    Route::post('/discounts/celebrity/store-discount',[App\Http\Controllers\CelebrityDiscountController::class,'store'])->name('store.celebdiscount');
    Route::get('/celeb-discount/delete/{celebrityDiscount}',[App\Http\Controllers\CelebrityDiscountController::class,'destroy'])->name('destroy.celebrity');
    Route::get('/discounts/celebrity-records/{discount_code}',[App\Http\Controllers\CelebrityDiscountRecordController::class,'show'])->name('celebRecords');


    Route::get('/department-summary-by-date',[App\Http\Controllers\GeneralController::class,'departmentSummaryDate'])->name('departmentSummaryDate');
    Route::get('/users/delete-user/{user}',[App\Http\Controllers\UserController::class,'destroy'])->name('DeleteUser');

    Route::get('/item-summary-by-date',[App\Http\Controllers\GeneralController::class,'itemSummaryDate'])->name('itemSummaryDate');
    Route::get('/display-item-summary-from-department/{department}',[App\Http\Controllers\GeneralController::class,'showDepartmentItem'])->name('showDepartmentItem');

    Route::get('/report-by-user',[App\Http\Controllers\GeneralController::class,'dateReportByUser'])->name('dateReportByUser')->middleware('auth');
    Route::get('/report/branch',[App\Http\Controllers\GeneralController::class,'branchSalesReport'])->name('branchSalesReport')->middleware('auth');
    Route::get('/report/branch-summary/sort',[App\Http\Controllers\GeneralController::class,'PrintSummaryBranchDate'])->name('PrintSummaryBranchDate')->middleware('auth');
    Route::get('/department-view-all/branch',[App\Http\Controllers\GeneralController::class,'allDepartmentSummaryBranch'])->name('allDepartmentSummaryBranch')->middleware('auth');
    Route::get('/item-view-all/branch',[App\Http\Controllers\GeneralController::class,'allItemSummaryBranches'])->name('allItemSummaryBranches')->middleware('auth');
    Route::get('/report/sales-person/category-with-date',[App\Http\Controllers\GeneralController::class,'getDeliveryReportDating'])->name('getDeliveryReportRouteDate')->middleware('auth');
    Route::get('/display-department-summary-by-date',[App\Http\Controllers\GeneralController::class,'departmentSummarybyDate'])->name('departmentSummarybyDate');
    Route::get('/display-item-summary-by-date',[App\Http\Controllers\GeneralController::class,'itemSummarybyDate'])->name('ItemSummarybyDate');
    Route::get('/display-item-summary/with',[App\Http\Controllers\GeneralController::class,'showDepartmentItemWithDate'])->name('showDepartmentItemWithDate');
    Route::get('/display-item-summary-by-date',[App\Http\Controllers\GeneralController::class,'itemSummarybyDate'])->name('ItemSummarybyDate');
    Route::get('/report',[App\Http\Controllers\GeneralController::class,'reportByDate'])->name('dateReport')->middleware('auth');
    Route::get('/department-view-all',[App\Http\Controllers\GeneralController::class,'allDepartmentSummary'])->name('allDepartmentSummary');
    Route::get('/item-view-all',[App\Http\Controllers\GeneralController::class,'allItemSummary'])->name('allItemSummary');




    Route::get('/display-department-summary-2/{branch}',[App\Http\Controllers\GeneralController::class,'departmentSummaryBranch'])->name('departmentSummaryBranch')->middleware('auth');
    Route::get('/display-items-branch/{branch}',[App\Http\Controllers\GeneralController::class,'itemSummaryBranch'])->name('itemSummaryBranch')->middleware('auth');
    Route::get('/report/sales-person/category',[App\Http\Controllers\GeneralController::class,'getDeliveryReport'])->name('getDeliveryReportRoute')->middleware('auth');

    Route::get('/product-add-composing/{id}',[App\Http\Controllers\CompositionRecordController::class,'addCompositionToProduct'])->name('addCompositionToProduct');


    Route::get('/users/add-new', function(){
        return view('new-user');
    })->name('newUser')->middleware('auth');
   

    Route::post('/update-user-info/{user}', function(User $user, Request $request){
        $user->email = $request->useremail;
        $user->save();
        return back()->with('status', 'User Information Updated Successfully');
    })->name('updateuser')->middleware('auth');

     
    Route::post('/switch-branch', function(Request $request){
        
       if (empty(request('station'))) {
           return back()->with('statuspass', "No stations selected");
       }


        $user = User::findOrfail(auth()->user()->id);
        $user -> station = $request->station;
        $user->save();

        return redirect()->to('/dashboard')->with('status', 'STATION SWITCHED TO ' . $request->station);
    })->name('switch')->middleware('auth');

});



// Kitchen Routes
Route::get('/recieved-docks-list', function(){
    return view('recieve-item-list', [
        'docks'=>\DB::table('good_receipts')->orderBy('g_r_item', 'ASC')->get()
    ]);

});


Route::get('/reset-issue', function(){

    $dayClose = \DB::table('close_days')->first();
    

    \DB::table('item_stock_ledgers')->whereDate('date', $dayClose->day_close)
    ->whereIn('station', \DB::table('kitchens')->pluck('kitchen_name'))
    ->update([
        'item_issue'=> 0
    ]);

});

Route::get('/wac', function(){

    $dayClose = \DB::table('close_days')->first();

    $manu_id = \DB::table('items')->where('item_manufacturing', 1)->pluck('id');
    $manufacturing_items = \DB::table('item_b_o_m_s')->whereIn('bom_id', $manu_id)->get();

    $getBomID = [] ;

    foreach ($manufacturing_items as $key => $item) {
        $getBomID [] = $item->bom_id;

        $average_price_now = \DB::table('item_b_o_m_s')->where('item_id', $item->bom_id)->sum('item_bom_unit_rate');
        $manufacturing_items = \DB::table('item_b_o_m_s')->whereIn('bom_id', $manu_id)->update([
            'item_bom_unit_rate' => \DB::raw('item_bom_unit *' . $average_price_now)
        ]); 

       



        

        // \App\Models\AverageCost::updateOrcreate([
        //     'item_id' => $item->bom_id,
        //     'date' => $dayClose->day_close,
        //     'weighted_average' => $average_price_now,
        // ]);

    }

    $MaID = \DB::table('items')->where('item_manufacturing', 1)->whereIn('id', $getBomID)->pluck('id');


    return $manufacturing_items = \DB::table('item_b_o_m_s')->whereIn('bom_id', $MaID)->get();


     $manufacturing_items = \DB::table('item_b_o_m_s')->whereIn('bom_id', $manu_id)->where('inventory_state', 2)->get();
    
    
    foreach ($manufacturing_items as $key => $item) {

        return $average_price_now = \DB::table('item_b_o_m_s')->where('item_id', $item->bom_id)->get();

       return $average_price_now = \DB::table('item_b_o_m_s')->where('bom_id', $item->bom_id)->sum('item_bom_unit_rate');

        $goods = \DB::table('item_b_o_m_s')->where('item_id', $item->bom_id)->get();

        foreach ($goods as $key => $goods) {
            return \DB::table('average_costs')->where('item_id', $goods->item_id)->first();
        }

        $average_price_now = \DB::table('item_b_o_m_s')->where('item_id', $item->bom_id)->sum('item_bom_unit_rate');
        $manufacturing_items = \DB::table('item_b_o_m_s')->where('bom_id', $item->bom_id)->update([
            'item_bom_unit_rate' => \DB::raw('item_bom_unit *' . $average_price_now)
        ]); 

        \App\Models\AverageCost::updateOrcreate([
            'item_id' => $item->bom_id,
            'date' => $dayClose->day_close,
            'weighted_average' => $average_price_now,
        ]);

    }
    
});


Route::get('/duplicates-transactions', function(){

    $dayClose = \DB::table('close_days')->first();

   

    try {

        $kitchen = \DB::table('kitchens')->where('kitchen_name', request('station'))->first();
        $branch = \DB::table('branches')->where('branch_code',$kitchen->kitchen_code)->first();

        $dupl = \DB::table('orders')->whereIn('order_id', function( $query ){
            $query->select('order_id')->from('orders')->groupBy('order_id')
            ->havingRaw('count(*) > 1');
        })
        ->where('branch', $branch->branch_name)
        ->whereDate('created_at', $dayClose->day_close)
        ->get();
        
        return view('all-orders', [
            'all_sales'=>$dupl
        ]);
    } catch (\Throwable $th) {
        return back()->with('statuspass', "Sorry, there was an issue with this search");
    }
    

})->name('duplicates');


// Currency Routes
Route::post('/new-currency', function(){
    
   empty(request('currency')) ? abort(500) : request('currency');
    $data = ['currency' => request('currency')];
    Currency::create( $data );
    return back()->with('status', 'New Currecny Added Successfully');

})->name('Currency')->middleware('auth');


Route::get('cart', function(){
    return session()->get('requisition');
});




Route::get('/date-time', function(){
    return session()->get('cart_voucher');
});



require __DIR__.'/auth.php';
