<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    use HasFactory;

    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }

    public function customer_statements()
    {
        return $this->hasMany(CustomerStatement::class);
    }


    protected $fillable = [
        'customer_name',
        'customer_address',
        'customer_phone',
        'customer_date',
        'customer_branch',
        'role',
        'customer_enteredby',
        'customer_note'
    ];
}
