<?php

namespace App\Http\Controllers;

use App\Models\AccountSetting;
use App\Models\Setting;
use Illuminate\Http\Request;

class AccountSettingController extends Controller
{

    public function __construct()
    {
        return $this->middleware('auth');
    }

    
    public function index()
    {
        return view('setting.account-settings');
    }


    public function store(Request $request)
    {
        $this->validate($request, [
            'app_name' => 'required|max:300',
            'app_receipt_footer' => 'required|max:500',
            'app_tin' => 'required'
        ]);

        $setting = new Setting;
        $setting -> app_name = $request->app_name;
        $setting -> app_website = $request -> app_website;
        $setting -> app_email = $request -> app_email;
        $setting -> app_description = $request -> app_description;
        $setting -> app_tin = $request -> app_tin;
        $setting -> currency = $request -> currency;
        $setting -> app_receipt_footer = $request -> app_receipt_footer;

        if($file = $request->hasFile('image')) {
            $file = $request->file('image') ;
            $fileName = $file->getClientOriginalName() ;
            $destinationPath = '/assets/img/' ;
            $file->move($destinationPath,$fileName);
            $setting->app_logo = ''.$fileName ;
        }
        $setting -> save();
        return redirect('home');
    }


}
