<?php

namespace App\Http\Controllers;

use App\Models\Agency;
use Illuminate\Http\Request;
use Datetime;

class AgencyController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }


    public function index()
    {
        return view('agencies');
    }

   
    public function store(Request $request)
    {   
        $this->agencyValidate();
        
        $data = new Agency;
        $data->agency_name = $request->agency_name;
        $data->agency_description = $request->description;
        $data->agency_code = substr($request->agency_name, 0,3) . date('YdHi');
        $data->save();
        return back()->with('status', 'Agency Created Successfully');
    }


    public function GetAgencyReport(Request $request)
    {   
        $this->validate(request(), [
            'date' => 'required',
            'type' => 'required'
        ]);

        $value = explode(' - ', $request->date);
        
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if (request('type') == "GENERAL ORDERS") {

            $items = \DB::table('invoices')
            ->selectRaw('agency as agency,invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->groupBy('invoice_product_name')
            ->groupBy('agency')
            ->where('agency', NULL)
            ->where('branch', auth()->user()->branch)
            ->whereDate('created_at', $to)
            ->get();

            $total_cost = \DB::table('invoices')
                ->where('agency', $request->type)
                ->where('branch', auth()->user()->branch)
                ->whereDate('created_at', $to)
                ->sum('invoice_total_price');

            $qty = \DB::table('invoices')
                ->where('agency', $request->type)
                ->where('branch', auth()->user()->branch)
                ->whereDate('created_at', $to)
                ->sum('invoice_quantity');

        }else{
            
        if ($from == $to) {

          $items = \DB::table('invoices')
            ->selectRaw('agency as agency,invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->groupBy('invoice_product_name')
            ->groupBy('agency')
            ->where('agency', $request->type)
            ->where('branch', auth()->user()->branch)
            ->whereDate('created_at', $to)
            ->get();

        }else{

            $items = \DB::table('invoices')
            ->selectRaw('agency as agency,invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->groupBy('invoice_product_name')
            ->groupBy('agency')
            ->where('agency', $request->type)
            ->where('branch', auth()->user()->branch)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();

        }
    }


        return view('print-agency-analysis', [
                'itemAgent' => $items
        ]);
    }



    public function update(Agency $agency)
    {
        $this->agencyValidate();

        $agency->update([
            'agency_name' => request('agency_name'),
            'agency_description' => request('description'),
            'agency_code' => request('agency_code'),
        ]);

        return back()->with('status', "Agency Updated Succesfully");
    }


    public function destroy(Agency $agency)
    {
        $agency->delete();
        return back()->with('status', "Agency Updated Succesfully");
    }


    public function agencyValidate()
    {
        $this->validate(request(), [
            'agency_name' => 'required|max:300',
        ]);
    }

    

}
