<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\BarTable;
use App\Models\Invoice;
use App\Models\InvoiceDump;

class BarTableController extends Controller
{


    public function __construct()
    {
        $this->middleware('auth');
    }


    public function index()
    {
        // getDay close
        $getDayClose = \DB::table('close_days')->first();
        if (auth()->user()->role == "Administrator") {
            $tables_transactions = \DB::table('bar_tables')
            ->where('table_settlement', 0)
            ->whereDate('date', $getDayClose -> day_close)
            ->get();
        }elseif (auth()->user()->role == "Branch Officer") {
            $tables_transactions = \DB::table('bar_tables')
            ->where('table_settlement', 0)
            ->where('branch', auth()->user()->branch)
            ->whereDate('date', $getDayClose -> day_close)
            ->get();
        }
        else{
            $tables_transactions = \DB::table('bar_tables')
            ->where('table_settlement', 0)
            ->where('user_id', auth()->id())
            ->whereDate('date', $getDayClose -> day_close)
            ->get();
            }

        return view('tables.table-mgt', [
            'tables_transactions' => $tables_transactions
        ]);
    }


    public function tableLinks()
    {
        return view('tables.table-mgt-links', [
            'tables' => \DB::table('register_tables')->get()
        ]);
    }

    public function confirmPayment(BarTable $bar)
    {
        $bar->update([
            'table_settlement' => 1,
            'settled_at' => \Carbon\carbon::now()
        ]);
        return back()->with('status', "Order Settled Successfully");
    }

    public function AddToReceipt(BarTable $bar)
    {   
           session()->put('invoice_number', $bar->invoice_number);
             $confirmIfBar = \DB::table('branches')->where('branch_name', auth()->user()->branch)->first();
             if ($confirmIfBar->store_type == 1) {
                 $products = \DB::table('final_productions')->where('store_category', 1)->get();
                 return view('invoice.create-invoice-bar-edit', [
                     'products' => $products,
                     'table_data'=> $bar
                 ]);
             }
    }


    public function settledTable()
    {
        // getDay close
        $getDayClose = \DB::table('close_days')->first();
        if (auth()->user()->role == "Administrator") {
            $tables_transactions = \DB::table('bar_tables')
            ->where('table_settlement', 1)
            ->whereDate('date', $getDayClose -> day_close)
            ->get();
        }elseif (auth()->user()->role == "Branch Officer") {
            $tables_transactions = \DB::table('bar_tables')
            ->where('table_settlement', 1)
            ->where('branch', auth()->user()->branch)
            ->whereDate('date', $getDayClose -> day_close)
            ->get();
        }
        else{
            $tables_transactions = \DB::table('bar_tables')
            ->where('table_settlement', 1)
            ->where('user_id', auth()->id())
            ->whereDate('date', $getDayClose -> day_close)
            ->get();
            }
        return view('tables.settled-table', [
            'tables_transactions' => $tables_transactions
        ]);
    }
}
