<?php

namespace App\Http\Controllers;

use App\Models\CompositionRecord;
use Illuminate\Http\Request;
use Carbon\carbon;
use DateTime;

class CompositionRecordController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function RawMaterialBranchReport(Request $request)
    {   
        $this->set_date($request);
        if ($from == $to) {
            $comp = \DB::table('composition_records')
                ->selectRaw('comp_name as name, sum(comp_quantity) as quantity, sum(unit_total) as total')
                ->groupBy('comp_name')
                ->whereDate('created_at', $from)
                ->where('branch', $request->branch)
                ->get();

            return view('branch-composition-report', [
                'comp' => $comp
            ]);
        }else {
            $comp = \DB::table('composition_records')
                ->selectRaw('comp_name as name, sum(comp_quantity) as quantity, sum(unit_total) as total')
                ->groupBy('comp_name')
                ->whereBetween('created_at', [$from, $to])
                ->where('branch', $request->branch)
                ->get();

            return view('branch-composition-report', [
                'comp' => $comp
            ]);
        }
        
    }


    public function RawMaterialUserReport(Request $request)
    {   
        $this->set_date($request);

        if ($from == $to) {
            $comp = \DB::table('composition_records')
                ->selectRaw('comp_name as name, sum(comp_quantity) as quantity, sum(unit_total) as total')
                ->groupBy('comp_name')
                ->whereDate('created_at', $from)
                ->where('user_id', $request->user_id)
                ->get();

            return view('branch-composition-report', [
                'comp' => $comp
            ]);
        }else {
            $comp = \DB::table('composition_records')
                ->selectRaw('comp_name as name, sum(comp_quantity) as quantity, sum(unit_total) as total')
                ->groupBy('comp_name')
                ->whereBetween('created_at', [$from, $to])
                ->where('user_id', $request->user_id)
                ->get();

            return view('branch-composition-report', [
                'comp' => $comp
            ]);
        }
        
    }

    public function addCompositionToProduct($id)
    {   

        $Allitems = \DB::table('items')->get();

        $p_comp = \DB::table('material_product_compositons')->where('product_id', $id)->get();
        
        // check for Product Code
        $product = \DB::table('final_productions')->where('FinalProductionID', $id)->first();

        if ($product->product_code == null) {
            $product_code = "PD-".substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 6) . date("hi");
        }else {
            $product_code = $product->product_code;
        }

       $estimated_cost = \DB::table('material_product_compositons')->where('product_id',$id)->pluck('cost')->sum();


        return view('product.add-product-materials',[
            'id' => $id,
            'name' => request('item_name'),
            'p_comp' => $p_comp,
            'product_code' => $product_code,
            'products' => $product,
            'estimated_cost' => $estimated_cost,
            'Allitems' => $Allitems
        ]);
    }


    public function DeleteBOMSingle($id)
    {
        $p_comp = \DB::table('material_product_compositons')
        ->where('id', $id)
        ->delete();
    }


    public function updateBOMmaterial($id, $unit, $bom_id)
    {
        // Get Manufacturing Price
        $checkManfactureBOM = \DB::table('manufacture_b_o_m_s')
              ->where('item_id', $bom_id)->first();

              
        $p_comp = \DB::table('material_product_compositons')
        ->where('id', $id)
        ->update([
            'unit_measure' => $unit,
            'cost' => $checkManfactureBOM->estimated_cost * $unit
        ]);

        return response([
            'status' => 1000,
            'Message' => "Unit Measure updated successfully"
        ]);
    }
    /**
     * Display the specified resource.
     *
     * @param  \App\Models\CompositionRecord  $compositionRecord
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
         $comp = \DB::table('composition_records')
        ->selectRaw('comp_name as name, material_code as material_code,sum(comp_quantity) as quantity, sum(unit_total) as total')
        ->groupBy('comp_name')
        ->groupBy('material_code')
        ->whereDate('created_at', Carbon::today())
        ->get();

        return view('composition-report', [
            'comp' => $comp
        ]);
    }


    public function compReportDate(Request $request)
    {   
        if ($request->show_branch == null) {
        $this->set_date($request);
        if ($from == $to) {
        $comp = \DB::table('composition_records')
            ->selectRaw('comp_name as name, material_code as material_code,sum(comp_quantity) as quantity, sum(unit_total) as total')
            ->groupBy('comp_name')
            ->groupBy('material_code')
            ->whereDate('created_at', $to)
            ->get();
        }else {
            $comp = \DB::table('composition_records')
            ->selectRaw('comp_name as name, material_code as material_code, sum(comp_quantity) as quantity, sum(unit_total) as total')
            ->groupBy('comp_name')
            ->groupBy('material_code')
            ->whereBetween('created_at', [$from, $to])
            ->get();
        }
        }else {

            $this->set_date($request);

            if ($from == $to) {
            $collection = \DB::table('composition_records')
                    ->whereDate('created_at', $to)
                    ->get();
                    $grouped = $collection->groupBy('branch');
            }else {
                $collection = \DB::table('composition_records')
                    ->whereBetween('created_at', [$from, $to])
                    ->get();
                    $grouped = $collection->groupBy('branch');
            }
            return view('composition-all-branches', [
                'composition_all_branches' => $grouped->all()
            ]);
        }

        return view('composition-report', [
            'comp' => $comp
        ]);
    }



    public function set_date($request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');
    }

 
}
