<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use Illuminate\Http\Request;
use App\Models\Invoice;
use App\Models\InvoiceDump;
use Carbon\carbon;
use DateTime;

class CustomerController extends Controller
{
    
    public function __construct()
    {
       return $this->middleware('auth');
    }


    public function index(Customer $customer, $customer_id)
    {   
        $this->authorize('view', $customer);

        $customer = Customer::findOrfail($customer_id);
        $customer->updated_at = Carbon::now();
        $customer -> save();
        
        $products = \DB::table('final_productions')->get();

        $toInvoice = InvoiceDump::where('user_id', auth()->user()->id)->get();
        // check Discount

        if ($toInvoice->isEmpty()) {
            $discounting_amount = null;
        }else {
            $forDiscount = InvoiceDump::where('user_id', auth()->user()->id)->first();
            $discounting_amount = \DB::table('discounts')->where('order_id', $forDiscount->invoice_number)->first();
        }
        $total_cost_invoice = InvoiceDump::where('user_id', auth()->user()->id)->sum('invoice_total_price');
        return view('invoice.create-invoice-delivery', [
            'invoice' => $toInvoice,
            'total_cost_invoice' => $total_cost_invoice,
            'products' => $products,
            'invoice_number' => InvoiceDump::where('user_id', auth()->user()->id)->first(),
            'customer_id' => $customer_id,
            'customer_data' => $customer,
            'discounting_amount'=> $discounting_amount
        ]);
    }


    public function transactionsDetails($id)
    {
        $orders = \DB::table('orders')
            ->where('customer_id', $id)
            ->paginate(100);

        $invoices = \DB::table('invoices')
        ->where('customer_id', $id)
        ->where('invoice_status', 1)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->paginate(100);


        $remarks = \DB::table('remarks')
                ->where('customer_id', $id)
                ->get();

        $ordersRevenue = \DB::table('invoices')
        ->where('customer_id', $id)
        ->where('invoice_status', 1)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->sum('invoice_total_price');

        $customer = Customer::findOrfail($id);

        return view('customer.customer-orders', [
            'invoices' => $invoices,
            'ordering' => $orders,
            'customer' => $customer,
            'ordercount' =>  $orders->count(),
            'invoicecount' =>  $invoices->count(),
            'ordersRevenue' => $ordersRevenue,
            'remarking' => $remarks
        ]);
    }


    public function CustomerNote(Request $request, $note)
    {
        $request->session()->put('customer_note', $note);
        return $request->session()->get('customer_note');
    }


    public function updateNote($customer_id, $note)
    {
        $customer = Customer::findOrfail($customer_id);
        $customer->customer_note = $note;
        $customer->save();
        return response([
            'status' => 200,
            'message' => 'Success'
        ]);
    }


    public function indexAgency(Customer $customer, $customer_id, $agency)
    {   
        $this->authorize('view', $customer);
        $customer = Customer::findOrfail($customer_id);
        $customer->updated_at = Carbon::now();
        $customer -> save();
        
           // load Products
           $products = \DB::table('final_productions')->where('store_category', 0)->get();
           $toInvoice = InvoiceDump::where('user_id', auth()->id())
                       ->orderBy('created_at', 'DESC')
                       ->get();
   
           // check Discount
           if ($toInvoice->isEmpty()) {
               $discounting_amount = null;
           }else {
               $forDiscount = InvoiceDump::where('user_id', auth()->id())->first();
               $discounting_amount = \DB::table('discounts')->where('order_id', $forDiscount->invoice_number)->first();
           }
           $total_cost_invoice = InvoiceDump::where('user_id', auth()->id())->sum('invoice_total_price');
   
           $confirmIfBar = \DB::table('branches')->where('branch_name', auth()->user()->branch)->first();
           if ($confirmIfBar->store_type == 1) {
               $products = \DB::table('final_productions')->where('store_category', 1)->get();
               return view('invoice.create-invoice-bar', [
                   'invoice' => $toInvoice,
                   'total_cost_invoice' => $total_cost_invoice,
                   'products' => $products,
                   'invoice_number' => InvoiceDump::where('user_id', auth()->id())->first(),
                   'discounting_amount'=> $discounting_amount
               ]);
           }
             
        return view('invoice.create-invoice-delivery', [
            'invoice' => $toInvoice,
            'total_cost_invoice' => $total_cost_invoice,
            'products' => $products,
            'invoice_number' => InvoiceDump::where('user_id', auth()->user()->id)->first(),
            'customer_id' => $customer_id,
            'customer_data' => $customer,
            'agencying' => $agency,
            'discounting_amount'=> $discounting_amount
        ]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $this->validate($request, [
            'customer_name'=> ['required', 'string', 'max:255'],
            'customer_phone'=> ['required', 'string', 'min:10'],
        ]);

        if ($request->create_inv == 1) {
            
        $customer = Customer::updateOrCreate(
            [ 'customer_phone' => $request->customer_phone ],
                 [ 'customer_name' => $request->customer_name,
                'customer_address' => $request->customer_address,
                'customer_date' => $request->customer_date,
                'customer_enteredby' => auth()->user()->name,
                'customer_branch' =>  auth()->user()->branch,
                'customer_note' =>  $request->customer_note
            ]);

            if ($request->agency == null) {
                return redirect()->to('/ceqa-dashboard/create-invoice-delivery/' . $customer -> id);
            }
            else {
                return redirect()->to('/ceqa-dashboard/create-invoice-delivery/' . $customer -> id . "/" . $request->agency);
            }

        }else {
            $customer = Customer::updateOrCreate(
                [ 'customer_phone' => $request->customer_phone ],
                     [ 'customer_name' => $request->customer_name,
                    'customer_address' => $request->customer_address,
                    'customer_date' => $request->customer_date,
                    'customer_enteredby' => auth()->user()->name,
                    'customer_branch' =>  auth()->user()->branch,
                    'customer_note' =>  $request->customer_note
                ]);
            return back()->with('status','New Customer Added Suucessfully');
        }

    }


    public function CustomerName(Request $request, $name)
    {
        $request->session()->put('customer_name',$name);
    }


    public function CustomerAddress(Request $request, $address)
    {
        $request->session()->put('customer_address',$address);
    }


    public function CustomerContact(Request $request, $contact)
    {
        $request->session()->put('customer_contact',$contact);
    }





    public function storeDrive(Request $request)
    {
        $this->validate($request, [
            'customer_name'=> ['required', 'string', 'max:255'],
            'customer_phone'=> ['required', 'string', 'max:255'],
        ]);

        $customer = Customer::updateOrCreate(
            [ 'customer_phone' => $request->customer_phone ],
                 [ 'customer_name' => $request->customer_name,
                'customer_address' => $request->customer_address,
                'customer_date' => $request->customer_date,
                'customer_enteredby' => auth()->user()->name,
                'customer_branch' =>  auth()->user()->branch,
                'customer_note' =>  $request->customer_note
            ]);
        
            return response([
                'status' => 200,
                'message' => 'Success'
            ]);
    }


    public function transactions($id)
    {
        $orders = \DB::table('orders')
            ->where('customer_id', $id)
            ->get();

        $invoices = \DB::table('invoices')
        ->where('customer_id', $id)
        ->where('invoice_status', 1)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->get();


        $remarks = \DB::table('remarks')
                ->where('customer_id', $id)
                ->get();

        $ordersRevenue = \DB::table('invoices')
        ->where('customer_id', $id)
        ->where('invoice_status', 1)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->sum('invoice_total_price');

        $customer = Customer::findOrfail($id);

        return view('customer.customer-orders', [
            'invoices' => $invoices,
            'ordering' => $orders,
            'customer' => $customer,
            'ordercount' =>  $orders->count(),
            'invoicecount' =>  $invoices->count(),
            'ordersRevenue' => $ordersRevenue,
            'remark' => $remarks
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Customer  $customer
     * @return \Illuminate\Http\Response
     */
    public function show()
    {    
        if (auth()->user()->role == "Retention Officer") {
           $customer = \DB::table('customers')->where('customer_branch', auth()->user()->branch) -> paginate(100);
        }else {
            $customer = \DB::table('customers')->paginate(100);
        }
        return view('customer.customer-list', [
            'customers' => $customer
        ]);
    }


    public function showNewAndTransactions()
    {   
        if (auth()->user()->role == "Administrator") {
            $customer_data = \DB::table('customers')
                ->whereDate('created_at', Carbon::today())
                ->orWhereDate('updated_at', Carbon::today())
                ->get();
        }elseif (auth()->user()->role == "Retention Officer") {
            $customer_data = \DB::table('customers')
                ->whereDate('created_at', Carbon::today())
                ->orWhereDate('updated_at', Carbon::today())
                ->where('customer_branch', auth()->user()->branch)
                ->get();
        }else {
            $customer_data = \DB::table('customers')
                ->whereDate('created_at', Carbon::today())
                ->orWhereDate('updated_at', Carbon::today())
                ->get();
        }
       
        return view('customer.customer-transactions-today', [
            'customer_data' => $customer_data
        ]);
    }

    public function customerReportDateBranch()
    {
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $customer = \DB::table('customers')
                ->where('customer_branch', auth()->user()->branch)
                ->whereDate('created_at', $from)
                ->orWhereDate('updated_at', $from)
                ->get();
                    return view('customer.customer-transactions-today', [
                        'customer' => $customer
                    ]);
        }else{
            $customer = \DB::table('customers')
            ->where('customer_branch', auth()->user()->branch)
            ->whereBetween('created_at', [$from, $to])
            ->whereBetween('updated_at', [$from, $to])
            ->get();
            return view('customer.customer-transactions-today', [
                'customer' => $customer
            ]);
        }
    }

    public function customerReportDate(Request $request)
    {
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            if (auth()->user()->role == "Administrator") {
                $customer_data = \DB::table('customers')
                    ->whereDate('created_at', $from)
                    ->orWhereDate('updated_at', $from)
                    ->get();
            }else {
                $customer_data = \DB::table('customers')
                    ->whereDate('created_at', $from)
                    ->orWhereDate('updated_at', $from)
                    ->where('customer_branch', auth()->user()->branch)
                    ->get();
            }
        }else{
           if (auth()->user()->role == "Administrator") {
            $customer_data = \DB::table('customers')
                ->whereBetween('created_at', [$from, $to])
                ->whereBetween('updated_at', [$from, $to])
                ->get();
           }else {
            $customer_data = \DB::table('customers')
                ->whereBetween('created_at', [$from, $to])
                ->whereBetween('updated_at', [$from, $to])
                ->where('customer_branch', auth()->user()->branch)
                ->get();
           }
        }

        return view('customer.customer-transactions-today', [
            'customer_data' => $customer_data
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Customer  $customer
     * @return \Illuminate\Http\Response
     */
    public function OnlineCustomerInvoice($invoice_number)
    {   
        // Delete All Dump transactions
        \DB::table("invoice_dumps")->where('user_id', auth()->user()->id)->delete();
        // getDay close
        $getDayClose = \DB::table('close_days')->first(); $time = date('H:i:s');
        
        $online_oders = \DB::table('online_customers')->where('invoice_number', $invoice_number)->first();
        
        $customer = Customer::updateOrCreate(
            [ 'customer_phone' => $online_oders-> customer_phone],
                 [ 'customer_name' => $online_oders->customer_fname . " " . $online_oders->customer_lname,
                'customer_address' => $online_oders->delivery_location,
                'customer_date' =>  $getDayClose->day_close,
                'customer_enteredby' => auth()->user()->name,
                'customer_branch' =>  auth()->user()->branch,
                'customer_note' =>  $online_oders->comment
            ]);



        foreach ( json_decode($online_oders->orders) as $online_oders) {
            
            $dumpInvoice = new InvoiceDump;
            $dumpInvoice->user_id = auth()->user()->id;
            $dumpInvoice->product_id = $online_oders->id;
            $dumpInvoice->branch = $online_oders->branch;
            $dumpInvoice->customer_id = $customer->id;
            $dumpInvoice->invoice_product_name = $online_oders->Name;
            $dumpInvoice->invoice_number = $invoice_number;
            $dumpInvoice->invoice_status = 1;
            $dumpInvoice->invoice_sales_person_category = auth()->user()->sales_person_category;
            $dumpInvoice->invoice_quantity = $online_oders->quantity;
            $dumpInvoice->invoice_unit_price = (float)$online_oders->price;
            $dumpInvoice->invoice_total_price = (int)$online_oders->price*(int)$online_oders->quantity;
            $dumpInvoice->invoice_category = $online_oders->item_category;
            $dumpInvoice->created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));;
            $dumpInvoice->save();
            
        }
        
            \DB::table('online_customers')->where('invoice_number', $invoice_number)->update(
                ['order_state' => 1,'accepted_by' => auth()->id()]);

            // Complete ORDER HERE  DOES NOT APPEAR ON DISPLAY SCREEN 
            \DB::table('invoices')->where('invoice_number', $invoice_number)->update([
                'drive_thru_status' => 1
            ]);

            return redirect()->to('/generate-invoice/delivery/' . $customer->id);
    }


    public function OnlineCustomerAgency(Request $request, $invoice_number)
    {
        // Delete All Dump transactions
        $request->session()->forget([
            'cart','invoice_number', 'discount'
        ]);

        // getDay close
        $getDayClose = \DB::table('close_days')->first(); $time = date('H:i:s');
        
        $online_oders = \DB::table('online_customers')->where('invoice_number', $invoice_number)->first();
        $agency = \DB::table('agencies')->where('agency_code', $online_oders->agency)->first();

        $customer = Customer::updateOrCreate(
            [ 'customer_phone' => $online_oders-> customer_phone],
                 [ 'customer_name' => $online_oders->customer_fname . " " . $online_oders->customer_lname,
                'customer_address' => $online_oders->delivery_location,
                'customer_date' =>  $getDayClose->day_close,
                'customer_enteredby' => auth()->user()->name,
                'customer_branch' =>  auth()->user()->branch,
                'customer_note' =>  $online_oders->comment
            ]);
            
            
        $cart = $request->session()->get('cart', []);
        foreach ( json_decode($online_oders->agency_orders ) as $online_oders) {
            $item = \DB::table('final_productions')->where('product_code', $online_oders->product_code)->first();

            if (empty($item->FinalProductionID)||null) {
                continue;
            }

            $id = $item->FinalProductionID;
            
            $cart[$id] = [
                'id' => $id,
                'user_id' => auth()->user()->id,
                "branch" => auth()->user()->branch,
                "customer_id" =>  $customer->id,
                "invoice_product_name" => $item -> Name,
                "invoice_status" => 1,
                "invoice_sales_person_category" => auth()->user()->sales_person_category,
                "invoice_quantity"=> $online_oders->quantity,
                "invoice_unit_price" =>(float)$item->UnitPrice,
                "agency"=> $agency->agency_name,
                "invoice_total_price"=> (float)$item->UnitPrice*(int)$online_oders->quantity,
                "item_category"=> $item->production_category,
                ];

            $request->session()->put('cart', $cart);
            
        }

        $online_oders = \DB::table('online_customers')->where('invoice_number', $invoice_number)->update([
            'order_state' => 1,
            'accepted_by' => auth()->id()
        ]);

        if (empty($agency->agency_name)) {
            return redirect()->to('/ceqa-dashboard/create-invoice-delivery/' . $customer -> id);
        }
        else {
            return redirect()->to('/ceqa-dashboard/create-invoice-delivery/' . $customer -> id . "/" . $agency->agency_name);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Customer  $customer
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Customer $customer)
    {   

         $customer = Customer::findOrfail($request->id);
         $customer->customer_name = $request->customer_name;
         $customer->customer_address = $request->customer_location;
         $customer->customer_phone = $request->customer_phone;
         $customer->save();
         return response([
             'status' => 200,
             'message' => 'Success'
         ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Customer  $customer
     * @return \Illuminate\Http\Response
     */
    public function destroy(Customer $customer)
    {   
        $this->authorize('delete', $customer);
        $customer->delete();
        return response([
            'status' => 200,
            'message' => 'Success'
        ]);
    }

    
}
