<?php

namespace App\Http\Controllers;

use App\Models\Dispatch;
use App\Models\Rider;
use Illuminate\Http\Request;
use DateTime;
use Carbon\carbon;

class DispatchController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        return $this->middleware('auth');
    }

    public function index()
    {   
        // getDay close
        $getDayClose = \DB::table('close_days')->first();

        if (auth()->user()->role == "Call Center") {
            $orders = \DB::table('orders')
            ->select('customers.customer_name', 'customers.customer_phone','orders.order_id', 'orders.branch', 'orders.created_at', 'orders.dispatch_status', 'orders.customer_id','orders.total_cost_order')
            ->join('customers','orders.customer_id','customers.id')
            ->where('orders.customer_id', '!=', null)
            ->where('orders.status', 0)
            ->whereDate('orders.created_at', $getDayClose->day_close)
            ->paginate(50);
        }else {
            $orders = \DB::table('orders')
            ->select('customers.customer_name', 'customers.customer_phone','orders.order_id', 'orders.branch', 'orders.created_at', 'orders.dispatch_status', 'orders.customer_id','orders.total_cost_order')
            ->join('customers','orders.customer_id','customers.id')
            ->where('orders.customer_id', '!=', null)
            ->where('orders.status', 0)
            ->whereDate('orders.created_at', $getDayClose->day_close)
            ->where('orders.branch', auth()->user()->branch)
            ->paginate(50);
        }

        
        $riders_ = \DB::table('riders')->where('branch', auth()->user()->branch)->get();
        return view('dispatch.dispatch-sales', [
                'dispatchorders' => $orders,
                'riders_' => $riders_
        ]);
    }


    public function indexcashier()
    {   
        if (auth()->user()->role !== "Cashier") {
            abort(419, "Unauthorised Access");
        }
        // getDay close
        $getDayClose = \DB::table('close_days')->first();

            $collection = \DB::table('invoices')
                ->where('branch', auth()->user()->branch)
                ->where('drive_thru_status', 0)
                ->where('payment_status', 0)
                ->whereDate('created_at', $getDayClose->day_close)
                ->orderBy('created_at', 'ASC')
                ->paginate(1000);

                $grouped = $collection->groupBy('invoice_number');
                return view('delivery-orders-display', [
                    'order' => $grouped
                ]);
    }



    public function CashierReport(Request $request)
    {
        if (auth()->user()->role !== "Cashier") {
            abort(419, "Unauthorized Access");
        }
        $getDayClose = \DB::table('close_days')->first();
        if (empty(request('date'))) {
             // total Earnings With Delivery Cost
           $totalearning = \DB::table('invoices')
           ->where('invoice_status', 1)
           ->where('payment_status', 1)
           ->where('payment_accepted_by', auth()->user()->id)
           ->where('branch', auth()->user()->branch)
           ->whereDate('created_at', $getDayClose->day_close)
           ->sum('invoice_total_price');

           $deliveries =  \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', "TRANSPORT")
            ->where('invoice_sales_person_category', "Delivery")
            ->where('payment_status', 1)
            ->where('payment_accepted_by', auth()->user()->id)
            ->where('branch', auth()->user()->branch)
            ->whereDate('created_at', $getDayClose->day_close)
            ->sum('invoice_total_price');

            $discount_money = \DB::table('orders')
            ->where('payment_accepted_by', auth()->user()->id)
            ->where('payment_status', 1)
            ->where('branch', auth()->user()->branch)
            ->whereDate('created_at', $getDayClose->day_close)
            ->sum('discount');

                // total Earnings Without Delivery Cost
            $total_no_delivery = $totalearning - ($deliveries + $discount_money);


            // total Earnings Delivery Amount
            $total_actual_delivery = $deliveries;



             // completed Deliveries
             $completed_deliveries =  \DB::table('invoices')
             ->where('invoice_status', 1)
             ->where('payment_status', 1)
             ->where('payment_accepted_by', auth()->user()->id)
             ->where('branch', auth()->user()->branch)
             ->whereDate('created_at', $getDayClose->day_close)
             ->get();


             // CASH Receivables
             $cash = \DB::table('dispatches')
             ->where('dispatch_status', 1)
             ->where('dispatch_branch', auth()->user()->branch)
             ->where('momo',"CASH")
             ->whereDate('created_at', $getDayClose->day_close)
             ->sum('amount');


            //  riders
            $riders = \DB::table('riders')
            ->where('branch',auth()->user()->branch)
            ->get();


             $momo = \DB::table('dispatches')
             ->where('dispatch_status', 1)
             ->where('dispatch_branch', auth()->user()->branch)
             ->where('momo',"MOMO")
             ->whereDate('created_at', $getDayClose->day_close)
             ->sum('amount');
             


             $sales_p = \DB::table('users')
             ->where('role', "Sales Person")
             ->where('branch', auth()->user()->branch)
             ->get();

            return view('cashier.cashier-report', [
                'with_delivery' => $totalearning, 
                'total_no_delivery' => $total_no_delivery,
                'total_actual_delivery' => $total_actual_delivery,
                'completed_deliveries' => $completed_deliveries,
                'cash' => $cash,
                'momo' => $momo,
                'riders_' => $riders,
                'sales_p'=> $sales_p,
                'discount_money' =>  $discount_money,
                'all_customers' => \DB::table('customers')->get(),

            ]);
        }

        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');


        if ($from == $to) {
            // total Earnings With Delivery Cost
           $totalearning = \DB::table('invoices')
           ->where('invoice_status', 1)
           ->where('payment_status', 1)
           ->where('payment_accepted_by', auth()->user()->id)
           ->where('branch', auth()->user()->branch)
           ->whereDate('created_at', $from)
           ->sum('invoice_total_price');

           $deliveries =  \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', "TRANSPORT")
            ->where('invoice_sales_person_category', "Delivery")
            ->where('payment_status', 1)
            ->where('payment_accepted_by', auth()->user()->id)
            ->where('branch', auth()->user()->branch)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

            $discount_money = \DB::table('orders')
            ->where('payment_accepted_by', auth()->user()->id)
            ->where('payment_status', 1)
            ->where('branch', auth()->user()->branch)
            ->whereDate('created_at', $from)
            ->sum('discount');

                // total Earnings Without Delivery Cost
            $total_no_delivery = $totalearning - ($deliveries + $discount_money);


            // total Earnings Delivery Amount
            $total_actual_delivery = $deliveries;



             // completed Deliveries
             $completed_deliveries =  \DB::table('invoices')
             ->where('invoice_status', 1)
             ->where('payment_status', 1)
             ->where('payment_accepted_by', auth()->user()->id)
             ->where('branch', auth()->user()->branch)
             ->whereDate('created_at', $from)
             ->get();


             // CASH Receivables
             $cash = \DB::table('dispatches')
             ->where('dispatch_status', 1)
             ->where('dispatch_branch', auth()->user()->branch)
             ->where('momo',"CASH")
             ->whereDate('created_at', $from)
             ->sum('amount');


            //  riders
            $riders = \DB::table('riders')
            ->where('branch',auth()->user()->branch)
            ->get();


             $momo = \DB::table('dispatches')
             ->where('dispatch_status', 1)
             ->where('dispatch_branch', auth()->user()->branch)
             ->where('momo',"MOMO")
             ->whereDate('created_at', $from)
             ->sum('amount');
             


             $sales_p = \DB::table('users')
             ->where('role', "Sales Person")
             ->where('branch', auth()->user()->branch)
             ->get();

            return view('cashier.cashier-report', [
                'with_delivery' => $totalearning, 
                'total_no_delivery' => $total_no_delivery,
                'total_actual_delivery' => $total_actual_delivery,
                'completed_deliveries' => $completed_deliveries,
                'cash' => $cash,
                'momo' => $momo,
                'riders_' => $riders,
                'sales_p'=> $sales_p,
                'discount_money' =>  $discount_money,
                'all_customers' => \DB::table('customers')->get(),
                'from' => $from,
                'to' => $to

            ]);
        }else {
                // total Earnings With Delivery Cost
                $totalearning = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('payment_status', 1)
                ->where('payment_accepted_by', auth()->user()->id)
                ->where('branch', auth()->user()->branch)
                ->whereBetween('created_at', [$from, $to])
                ->sum('invoice_total_price');
       
                  $deliveries =  \DB::table('invoices')
                   ->where('invoice_status', 1)
                   ->where('invoice_sales_person_category', "Delivery")
                   ->where('invoice_category', "TRANSPORT")
                   ->where('branch', auth()->user()->branch)
                   ->whereBetween('created_at', [$from, $to])
                   ->sum('invoice_total_price');


                   $discount_money = \DB::table('orders')
                   ->where('payment_accepted_by', auth()->user()->id)
                   ->where('payment_status', 1)
                   ->where('branch', auth()->user()->branch)
                   ->whereDate('created_at', [$from, $to])
                   ->sum('discount');
       
                   // total Earnings Without Delivery Cost
                 $total_no_delivery = $totalearning - $deliveries;
       
       
                   // total Earnings Delivery Amount
                   $total_actual_delivery = $deliveries;
       
       
       
                    // completed Deliveries
                    $completed_deliveries = \DB::table('invoices')
                        ->where('invoice_status', 1)
                        ->where('payment_status', 1)
                        ->where('payment_accepted_by', auth()->user()->id)
                        ->where('branch', auth()->user()->branch)
                        ->whereBetween('created_at', [$from, $to])
                        ->get();
                    
       
       
                    // CASH Receivables
                    $cash = \DB::table('dispatches')
                    ->where('dispatch_status', 1)
                    ->where('dispatch_branch', auth()->user()->branch)
                    ->where('momo',"CASH")
                    ->whereBetween('created_at', [$from, $to])
                    ->sum('amount');
       
       
                   //  riders
                   $riders = \DB::table('riders')
                   ->where('branch',auth()->user()->branch)
                   ->get();
       
       
                    $momo = \DB::table('dispatches')
                    ->where('dispatch_status', 1)
                    ->where('dispatch_branch', auth()->user()->branch)
                    ->where('momo',"MOMO")
                    ->whereBetween('created_at', [$from, $to])
                    ->sum('amount');
                    
       
       
                    $sales_p = \DB::table('users')
                    ->where('role', "Sales Person")
                    ->where('branch', auth()->user()->branch)
                    ->get();
       
                   return view('cashier.cashier-report', [
                       'with_delivery' => $totalearning, 
                       'total_no_delivery' => $total_no_delivery,
                       'total_actual_delivery' => $total_actual_delivery,
                       'completed_deliveries' => $completed_deliveries,
                       'cash' => $cash,
                       'momo' => $momo,
                       'riders_' => $riders,
                       'sales_p'=> $sales_p,
                       'discount_money' =>  $discount_money,
                       'all_customers' => \DB::table('customers')->get(),
                       'from' => $from,
                       'to' => $to
       
                   ]);
        }
    }


    public function DispatchReport(Request $request)
    {
        if (auth()->user()->role != "Dispatch Manager" ) {
            abort(403,"UNAUTHORIZED");
        }
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');


        if ($from == $to) {
            // total Earnings With Delivery Cost
           $totalearning = \DB::table('invoices')
           ->where('invoice_status', 1)
           ->where('branch', auth()->user()->branch)
           ->where('invoice_sales_person_category', "Delivery")
           ->whereDate('created_at', $from)
           ->sum('invoice_total_price');

           $deliveries =  \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', "TRANSPORT")
            ->where('invoice_sales_person_category', "Delivery")
            ->where('branch', auth()->user()->branch)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

            // total Earnings Without Delivery Cost
          $total_no_delivery = $totalearning - $deliveries;

            // total Earnings Delivery Amount
            $total_actual_delivery = $deliveries;



             // completed Deliveries
             $completed_deliveries = \DB::table('dispatches')
             ->where('dispatch_status', 1)
             ->where('status', 1)
             ->where('dispatch_branch', auth()->user()->branch)
             ->whereDate('created_at', $from)
             ->get();


             // CASH Receivables
             $cash = \DB::table('dispatches')
             ->where('dispatch_status', 1)
             ->where('dispatch_branch', auth()->user()->branch)
             ->where('momo',"CASH")
             ->whereDate('created_at', $from)
             ->sum('amount');


            //  riders
            $riders = \DB::table('riders')
            ->where('branch',auth()->user()->branch)
            ->get();


             $momo = \DB::table('dispatches')
             ->where('dispatch_status', 1)
             ->where('dispatch_branch', auth()->user()->branch)
             ->where('momo',"MOMO")
             ->whereDate('created_at', $from)
             ->sum('amount');
             


             $sales_p = \DB::table('users')
             ->where('sales_person_category', "Delivery")
             ->where('role', "Sales Person")
             ->where('branch', auth()->user()->branch)
             ->get();

            return view('dispatch.dispatch-report', [
                'with_delivery' => $totalearning, 
                'total_no_delivery' => $total_no_delivery,
                'total_actual_delivery' => $total_actual_delivery,
                'completed_deliveries' => $completed_deliveries,
                'cash' => $cash,
                'momo' => $momo,
                'riders_' => $riders,
                'sales_p'=> $sales_p

            ]);
        }else {

                // total Earnings With Delivery Cost
                $totalearning = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('invoice_sales_person_category', "Delivery")
                ->where('branch', auth()->user()->branch)
                ->whereBetween('created_at', [$from, $to])
                ->sum('invoice_total_price');
       
                  $deliveries =  \DB::table('invoices')
                   ->where('invoice_status', 1)
                   ->where('invoice_sales_person_category', "Delivery")
                   ->where('invoice_category', "TRANSPORT")
                   ->where('branch', auth()->user()->branch)
                   ->whereBetween('created_at', [$from, $to])
                   ->sum('invoice_total_price');
       
                   // total Earnings Without Delivery Cost
                 $total_no_delivery = $totalearning - $deliveries;
       
       
                   // total Earnings Delivery Amount
                   $total_actual_delivery = $deliveries;
       
       
       
                    // completed Deliveries
                    $completed_deliveries = \DB::table('dispatches')
                    ->where('dispatch_status', 1)
                    ->where('dispatch_branch', auth()->user()->branch)
                    ->whereBetween('created_at', [$from, $to])
                    ->get();
       
       
                    // CASH Receivables
                    $cash = \DB::table('dispatches')
                    ->where('dispatch_status', 1)
                    ->where('dispatch_branch', auth()->user()->branch)
                    ->where('momo',"CASH")
                    ->whereBetween('created_at', [$from, $to])
                    ->sum('amount');
       
       
                   //  riders
                   $riders = \DB::table('riders')
                   ->where('branch',auth()->user()->branch)
                   ->get();
       
       
                    $momo = \DB::table('dispatches')
                    ->where('dispatch_status', 1)
                    ->where('dispatch_branch', auth()->user()->branch)
                    ->where('momo',"MOMO")
                    ->whereBetween('created_at', [$from, $to])
                    ->sum('amount');
                    
       
       
                    $sales_p = \DB::table('users')
                    ->where('sales_person_category', "Delivery")
                    ->where('role', "Sales Person")
                    ->where('branch', auth()->user()->branch)
                    ->get();
       
                   return view('dispatch.dispatch-report', [
                       'with_delivery' => $totalearning, 
                       'total_no_delivery' => $total_no_delivery,
                       'total_actual_delivery' => $total_actual_delivery,
                       'completed_deliveries' => $completed_deliveries,
                       'cash' => $cash,
                       'momo' => $momo,
                       'riders_' => $riders,
                       'sales_p'=> $sales_p
       
                   ]);
        }
    }


    public function customerInfo($id)
    {
       return \DB::table('customers')->where('id', $id)->first();
    }


    public function store(Request $request)
    {
        $this->validate($request, [
            'rider_id' => 'required'
        ]);
        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        // getDay close
        $getDayClose = \DB::table('close_days')->first();
        // current time 
        $time = date('H:i:s');

        $dispatch = new Dispatch;
        $dispatch->rider_id = $request->rider_id;
        $dispatch -> entered_by = auth()->user()->name;
        $dispatch -> momo = $request -> momo;
        $dispatch -> amount = $request ->amount;
        $dispatch -> deliveryamount = $request ->deliveryamount;
        $dispatch -> order_number = $request->order_number;
        $dispatch -> dispatch_branch = auth()->user()->branch;
        $dispatch -> customer_phone = $request->customer_phone;
        $dispatch -> ordered_at = $request->ordered_at;
        $dispatch -> dispatched_at = \Carbon\carbon::now();
        $dispatch -> category = auth()->user()->sales_person_category;
        $dispatch -> created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
        $dispatch -> save();
        
        $update_order_price =  \DB::table('orders')->where('order_id', $request->order_number)->first();

        \DB::table('orders')->where('order_id', $request->order_number)->update([
            'dispatch_status' => 1,
            'status' => 1,
            'total_cost_order' => $update_order_price -> total_cost_order,
            'updated_at' => date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"))
        ]);

        // find Rider
        $rider = Rider::findorfail($request->rider_id);

        // find Customer
        $inv = \DB::table('invoices')->where('invoice_number',$request->order_number)->first();
        $customer = \DB::table('customers')->where('id',$inv->customer_id)->first();

           $sender= 'PIZZAMAN';
           $numbers =  $customer->customer_phone;  
        
            if (strstr($rider->rd_name, "PICK") == true) {
                $msg = 'Dear ' . ucwords($customer->customer_name) . ", Thank you for buying from [PIZZAMAN-CHICKENMAN], your order is ready for Pick up." ; 
            }else{
                $msg = 'Dear ' . ucwords($customer->customer_name) . ", Thank you for buying from [PIZZAMAN-CHICKENMAN]. Delivery agent (" . ucwords($rider->rd_name) . " - " . $rider->rd_phone . " )" . " will call you soon for delivery. Delivery Fee is GHS" . $request ->deliveryamount . ". Thank you." ; 
            }      
           $message= rawurlencode($msg);                   
           $numbers= rawurlencode($numbers);                   
           $sender= rawurlencode($sender);                   
   
   
           $url= 'https://api.msmpusher.net/v1/send?privatekey=2021081489001008&publickey=38250fc14d69ae7b&sender=' . $sender . '&numbers=' . $numbers . '&message=' . $message;
           $result = file_get_contents($url);

        \DB::commit();  
            return back()->with('status', 'Processing, Kindly Mark as Completed after Delivery,  Message Sent to Customer');
            } catch (\Throwable $th) {
                \DB::rollback();
                return response([
                    'status' => 501,
                    "Message" => $th
                ]);
        }
    }


    public function notification()
    {
         // getDay close
         $getDayClose = \DB::table('close_days')->first();

         if (auth()->user()->role == "Call Center") {
             $orders = \DB::table('orders')
             ->join('customers','orders.customer_id','customers.id')
             ->where('orders.customer_id', '!=', null)
             ->where('orders.status', 0)
             ->whereDate('orders.created_at', $getDayClose->day_close)
             ->get();
         }else {
             $orders = \DB::table('orders')
             ->join('customers','orders.customer_id','customers.id')
             ->where('orders.customer_id', '!=', null)
             ->where('orders.status', 0)
             ->where('orders.branch', auth()->user()->branch)
             ->get();
         }
 
         
         $riders_ = \DB::table('riders')->where('branch', auth()->user()->branch)->get();
         return view('dispatch.dispatch-sales', [
                 'dispatchorders' => $orders,
                 'riders_' => $riders_
         ]);
 
    }


    public function rider(Request $request)
    {
        $rider = new Rider;
        $rider->rd_name = $request->rd_name;
        $rider->rd_phone = $request->rd_phone;
        $rider->branch = $request->branch;
        $rider->rd_motor = $request->rd_motor;
        $rider->rd_address = $request->rd_address;
        $rider->rd_description = $request->rd_description;
        $rider->save();
        return 123;
    }


    public function riderReport()
    {   
        // getDay close
        $getDayClose = \DB::table('close_days')->first();

        $riders_report = \DB::table('riders')
            ->join('dispatches','riders.id', 'dispatches.rider_id')
            ->whereDate('dispatches.created_at', $getDayClose->day_close)
            ->get();

        return view('dispatch.rider-report', [
                'riders_report' => $riders_report
            ]);
    }


        
    public function searchResults(){
        // getDay close
        $getDayClose = \DB::table('close_days')->first();
        if (auth()->user()->role == "Call Center") {
            $orders = \DB::table('orders')
            ->select('customers.customer_name', 'customers.customer_phone','orders.order_id', 'orders.branch', 'orders.created_at', 'orders.dispatch_status', 'orders.customer_id','orders.total_cost_order')
            ->join('customers','orders.customer_id','customers.id')
            ->where('orders.customer_id', '!=', null)
            ->where('orders.status', 0)
            ->whereDate('orders.created_at', $getDayClose->day_close)
            ->where('orders.order_id', 'LIKE', '%'.request('search').'%')
            ->orWhere('customers.customer_phone', 'LIKE', '%'.request('search').'%')
            ->orWhere('orders.branch', 'LIKE', '%'.request('search').'%')
            ->paginate(50);
        }else {
            $orders = \DB::table('orders')
            ->select('customers.customer_name', 'customers.customer_phone','orders.order_id', 'orders.branch', 'orders.created_at', 'orders.dispatch_status', 'orders.customer_id','orders.total_cost_order')
            ->join('customers','orders.customer_id','customers.id')
            ->where('orders.customer_id', '!=', null)
            ->where('orders.status', 0)
            ->whereDate('orders.created_at', $getDayClose->day_close)
            ->where('orders.branch', auth()->user()->branch)
            ->where('orders.order_id', 'LIKE', '%'.request('search').'%')
            ->orWhere('customers.customer_phone', 'LIKE', '%'.request('search').'%')
            ->paginate(50);
        }

        
        $riders_ = \DB::table('riders')->where('branch', auth()->user()->branch)->get();
        return view('dispatch.dispatch-sales', [
                'dispatchorders' => $orders,
                'riders_' => $riders_
        ]);
    }

  


    public function RiderReportDate(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');
        
    
        if ($from == $to) {
            $riders_report = \DB::table('riders')
                ->join('dispatches','riders.id', 'dispatches.rider_id')
                ->whereDate('dispatches.created_at', $from)
                ->get();
        }else {
            $riders_report = \DB::table('riders')
                ->join('dispatches','riders.id', 'dispatches.rider_id')
                ->whereDate('dispatches.created_at', [$from, $to])
                ->get();
        }

        return view('dispatch.rider-report', [
            'riders_report' => $riders_report
        ]);
    }

    public function riderIndex()
    {
        return view('dispatch.add-rider');
    }


    public function markAsCompleted($order_number)
    {
        \DB::table('orders')->where('order_id', $order_number)->update(['status' => 1]);
        \DB::table('dispatches')->where('order_number', $order_number)->update(['dispatch_status' => 1]);
        return back()->with('status','Order Completed');
    }


    public function riderTransactions(Request $request)
    {
        
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');
        
        $riderinfo = Rider::findOrfail( $request->rider_id);
        if ($from == $to) {
            $results = \DB::table('riders')
                ->select('*')
                ->join('dispatches', 'riders.id', 'dispatches.rider_id')
                ->where('dispatches.rider_id', $request->rider_id)
                ->whereDate('dispatches.created_at', $from)
                ->get();

            // amount to Rider
            $amountToRider = \DB::table('riders')
            ->select('*')
            ->join('dispatches', 'riders.id', 'dispatches.rider_id')
            ->where('dispatches.rider_id', $request->rider_id)
            ->whereDate('dispatches.created_at', $from)
            ->sum('deliveryamount');

                return view('dispatch.rider-profile', [
                    'results' => $results,
                    'rider' => $riderinfo,
                    'deliveryamount' => $amountToRider
                ]);
        }else {
            $results = \DB::table('riders')
            ->select('*')
            ->join('dispatches', 'riders.id', 'dispatches.rider_id')
            ->where('dispatches.rider_id', $request->rider_id)
            ->whereBetween('dispatches.created_at', [$from, $to])
            ->get();

        // amount to Rider
        $amountToRider = \DB::table('riders')
        ->select('*')
        ->join('dispatches', 'riders.id', 'dispatches.rider_id')
        ->where('dispatches.rider_id', $request->rider_id)
        ->whereBetween('dispatches.created_at', [$from, $to])
        ->sum('deliveryamount');

            return view('dispatch.rider-profile', [
                'results' => $results,
                'rider' => $riderinfo,
                'deliveryamount' => $amountToRider
            ]);
        }
    }




    public function RemoveRider($id)
    {
        $rd = Rider::findOrfail($id);
        $rd->delete();
        return 123;
    }

  
}
