<?php

namespace App\Http\Controllers;

use App\Models\DraftInvoice;
use App\Models\DraftOrder;
use App\Models\InvoiceDump;
use App\Models\Invoice;
use Illuminate\Http\Request;
use Session;

class DraftInvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function store(Request $request)
    {
        // ITEMS FROM CART
        $cart = session()->get('cart');

        // GENERATE TRANSACTION NUMBER
        $generateInvoice = substr(auth()->user()->branch, 0,3) . rand(5034580,10034580)+rand(5034580,10034580) . date("Yd") . date('Hi');
        session()->put('invoice_number', $generateInvoice);
        // CHECK CART IF EMPTY
        if (empty($cart)) {
            return back()->with('status', 'No Item Added to Cart');
        }else{
        // TOTAL COST OF ORDER
        $total = 0;
        foreach ($cart as $inv) {
            $total += $inv['invoice_quantity'] * $inv['invoice_unit_price'];
            $new_invoice = new DraftInvoice;
            $new_invoice->user_id = auth()->id();
            $new_invoice->invoice_product_name = $inv['invoice_product_name'];
            $new_invoice->customer_id = $inv['customer_id'];
            $new_invoice->branch = auth()->user()->branch;
            if ($inv['invoice_status'] == "General") {
                $new_invoice['invoice_status'] = 1;
            }elseif ($inv['invoice_status'] == "On The House") {
                $new_invoice['invoice_status'] = 2;
            }else{
                $new_invoice['invoice_status'] = 0;
            }
            $new_invoice->invoice_sales_person_category = $inv['invoice_sales_person_category'];
            $new_invoice->invoice_quantity = $inv['invoice_quantity'];
            $new_invoice->invoice_unit_price = $inv['invoice_unit_price'];
            $new_invoice->invoice_total_price = $inv['invoice_total_price'];
            $new_invoice->invoice_category = $inv['item_category'];
            $new_invoice->save();
       }

       $order_ = new DraftOrder;
       $order_ -> user_id = auth()->id();
       $order_ -> branch = auth()->user()->branch;
       $order_ -> order_id = session()->get('invoice_number');
       $order_ -> status = 1;
       $order_ -> category = auth()->user()->sales_person_category;
       $order_ -> total_cost_order = $total;
       $order_ ->save();
       
        Session::forget('cart');
        Session::forget('invoice_number');
        return 123;

     }
    }


    public function DraftInvoiceDelivery($id)
    {   

        $transfer = InvoiceDump::where('user_id', auth()->user()->id)->get();
        $getInvoiceNumber = InvoiceDump::where('user_id', auth()->user()->id)->first();

        if ($transfer === null || $getInvoiceNumber == null) {
           return back()->with('status', 'No Item Added to Cart');
        }else{
        //    Get Order Number or Invoice Number

        foreach ($transfer as $inv) {
            $new_invoice = new DraftInvoice;
            $new_invoice->user_id = $inv->user_id;
            $new_invoice->customer_id = $inv->customer_id;
            $new_invoice->branch = $inv->branch;
            $new_invoice->invoice_product_name = $inv -> invoice_product_name;
            if ($inv -> invoice_status == "General" || $inv -> invoice_status == 1) {
                $new_invoice->invoice_status = 1;
            }elseif ($inv -> invoice_status == "On The House" || $inv -> invoice_status == 2) {
                $new_invoice->invoice_status = 2;
            }else{
                $new_invoice->invoice_status = 0;
            }
            $new_invoice->invoice_sales_person_category = $inv->invoice_sales_person_category;
            $new_invoice->invoice_quantity = $inv -> invoice_quantity;
            $new_invoice->invoice_unit_price = $inv -> invoice_unit_price;
            $new_invoice->invoice_total_price = $inv -> invoice_total_price;
            $new_invoice->invoice_number = $inv -> invoice_number;
            $new_invoice->save();
       }


       $order_ = new DraftOrder;
       $order_ -> order_id = $getInvoiceNumber->invoice_number;
       $order_ -> user_id = auth()->user()->id;
       $order_ -> customer_id = $id;
       $order_ -> status = 0;
       $order_ -> branch = $getInvoiceNumber->branch;
       $order_ -> total_cost_order = InvoiceDump::where('user_id', auth()->user()->id)->sum('invoice_total_price');
       $order_ -> category = auth()->user()->sales_person_category;
       $order_ ->save();


       \DB::table("invoice_dumps")->where('user_id', auth()->user()->id)->delete();
        }
    }

    
}
