<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\carbon;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {   
        // getDay close
        $getDayClose = \DB::table('close_days')->first();
        
        $products = \DB::table('final_productions')->get();

        $users = \DB::table('users')
            ->where('role', "Sales Person")
            ->get();

        $usersOnline = \DB::table('users')->where('branch', '!=', Null)->get();

        $app = \DB::table('settings')->first();
        if (empty($app)) {
            return redirect('/get-started');
        }

        if (auth()->user()->role == "Administrator") {

            
            $all_invoice = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $getDayClose->day_close)
            ->sum('invoice_total_price');

            $onthehouse = \DB::table('invoices')
            ->where('invoice_status', 2)
            ->whereDate('created_at', $getDayClose->day_close)
            ->sum('invoice_total_price');

            $rejected = \DB::table('invoices')
            ->where('invoice_status', 0)
            ->whereDate('created_at', $getDayClose->day_close)
            ->sum('invoice_total_price');

           $delivery = \DB::table('orders')
            ->whereDate('created_at', $getDayClose->day_close)
            ->where('status', 1)
            ->where('dispatch_status', 1)
            ->where('category', "Delivery")
            ->sum('total_cost_order');
            
            $counter = \DB::table('orders')
            ->whereDate('created_at', $getDayClose->day_close)
            ->where('category', "Counter")
            ->sum('total_cost_order');


            $deliveryfee = \DB::table('dispatches')
            ->whereDate('created_at', $getDayClose->day_close)
            ->where('dispatch_status', 1)
            ->sum('deliveryamount');

            $orders = \DB::table('orders')
            ->whereDate('created_at', $getDayClose->day_close)
            ->get();

            $discounts = \DB::table('discounts')
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('amount_deducted');

            $all_invoice_today_sales = $all_invoice-($discounts);

            return view('home', [
                'total_sales' => $all_invoice_today_sales,
                'countproduct' => $products->count(),
                'orders' => $orders->count(),
                'all_users' => $users,
                'usersOnline' => $usersOnline
            ]);

        }elseif (auth()->user()->role == "Sales Person") {
            // if sales Person and Has Delivery Category 
            if (auth()->user()->sales_person_category == "Delivery") {

                $products = \DB::table('final_productions')->get();

                $orders = \DB::table('orders')
                ->whereDate('created_at', $getDayClose->day_close)
                ->where('user_id', auth()->user()->id)
                ->where('category', auth()->user()->sales_person_category)
                ->where('branch', auth()->user()->branch)
                ->get();

                $all_sales_today = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 1)
                ->whereDate('created_at', $getDayClose->day_close)
                ->get();
    
               $orderssales = \DB::table('orders')
                ->whereDate('created_at', $getDayClose->day_close)
                ->where('user_id', auth()->user()->id)
                ->where('status', 1)
                ->where('dispatch_status', 1)
                ->sum('total_cost_order');

                $rejected = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 0)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $onthehouse = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 2)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $deliveryfee = \DB::table('dispatches')
                ->whereDate('created_at', $getDayClose->day_close)
                ->where('dispatch_status', 1)
                ->sum('deliveryamount');

                 $discounts = \DB::table('discounts')
                ->where('user_id', auth()->user()->id)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('amount_deducted');
                

                $all_invoice_today_sales = $orderssales -($discounts);
    
                $orders = \DB::table('orders')
                ->where('user_id', auth()->user()->id)
                ->whereDate('created_at', $getDayClose->day_close)
                ->get();
    
                return view('home', [
                    'sales_today' => $all_sales_today->count(),
                    'total_sales' => $all_invoice_today_sales,
                    'countproduct' => $products->count(),
                    'orders' => $orders->count(),
                    'all_users' => $users,
                    'usersOnline' => $usersOnline
                ]);
    
            }elseif (auth()->user()->sales_person_category == "Drive Thru") {
                $sales_today = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('user_id', auth()->user()->id)
                ->whereDate('created_at', $getDayClose->day_close)
                ->get();

                $sales_today = $sales_today->sortByDesc('created_at');
                
        
                // $total_sales_today = \DB::table('orders')
                // ->whereDate('created_at', Carbon::today())
                // ->where('user_id',auth()->user()->id)
                // ->where('branch', auth()->user()->branch)
                // ->sum('total_cost_order');

                $invoices = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 1)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $rejected = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 0)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $onthehouse = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 2)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $discounts = \DB::table('discounts')
                ->where('user_id', auth()->user()->id)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('amount_deducted');

                $total_sales_today = $invoices - $discounts;
        
                $sales_today_count = $sales_today->count();
        
                $orders = \DB::table('orders')
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->where('user_id',auth()->user()->id)
                    ->get();
        
                return view('home', [
                    'sales_today' => $sales_today_count,
                    'sales_today_lists' => $sales_today,
                    'total_sales' => $total_sales_today,
                    'countproduct' => $products->count(),
                    'orders' => $orders->count(),
                    'all_users' => $users,
                    'usersOnline' => $usersOnline
        
                ]);
            }
            elseif (auth()->user()->sales_person_category == "Counter") {
                $sales_today = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('user_id', auth()->user()->id)
                ->whereDate('created_at', $getDayClose->day_close)
                ->paginate(100);

                $sales_today = $sales_today->sortByDesc('created_at');
                

                $invoices = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 1)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $rejected = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 0)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $onthehouse = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 2)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $discounts = \DB::table('discounts')
                ->where('user_id', auth()->user()->id)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('amount_deducted');

                $total_sales_today = $invoices -$discounts;
        
                $sales_today_count = $sales_today->count();
        
                $orders = \DB::table('orders')
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->where('user_id',auth()->user()->id)
                    ->get();
        
                return view('home', [
                    'sales_today_lists' => $sales_today,
                    'total_sales' => $total_sales_today,
                    'countproduct' => $products->count(),
                    'orders' => $orders->count(),
                    'all_users' => $users,
                    'usersOnline' => $usersOnline
                ]);
            }
    
        }elseif (auth()->user()->role == "Branch Officer") {
            $all_sales_today = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->whereDate('created_at', $getDayClose->day_close)
            ->paginate(100);


            $onthehouse = \DB::table('invoices')
            ->where('invoice_status', 2)
            ->whereDate('created_at', $getDayClose->day_close)
            ->sum('invoice_total_price');

            $rejected = \DB::table('invoices')
            ->where('invoice_status', 0)
            ->whereDate('created_at', $getDayClose->day_close)
            ->sum('invoice_total_price');

           $delivery = \DB::table('orders')
            ->whereDate('created_at', $getDayClose->day_close)
            ->where('status', 1)
            ->where('dispatch_status', 1)
            ->where('category', "Delivery")
            ->sum('total_cost_order');
            
            $counter = \DB::table('orders')
            ->whereDate('created_at', $getDayClose->day_close)
            ->where('category', "Counter")
            ->sum('total_cost_order');


            $deliveryfee = \DB::table('dispatches')
            ->whereDate('created_at', $getDayClose->day_close)
            ->where('dispatch_status', 1)
            ->sum('deliveryamount');

            $orders = \DB::table('orders')
            ->whereDate('created_at', $getDayClose->day_close)
            ->get();

            $discounts = \DB::table('discounts')
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('amount_deducted');

            $all_invoice_today_sales = ($counter + $delivery)-($discounts+$onthehouse+$rejected);

            return view('home', [
                'total_sales' => $all_invoice_today_sales,
                'countproduct' => $products->count(),
                'orders' => $orders->count(),
                'all_users' => $users,
                'usersOnline' => $usersOnline
            ]);
        }elseif (auth()->user()->role == "Retention Officer") {
            return redirect()->to('/ceqa-dashboard/customer-list');
        }elseif (auth()->user()->role == "Cashier"){
            return redirect()->to('/ceqa-dashboard/make-sales/cashier');
        }else {
            return redirect()->to('/ceqa-dashboard/make-sales/dispatch');
        }

    }



    public function showTransactions(Request $request)
    {   
        $getDayClose = \DB::table('close_days')->first();
        if (auth()->user()->role == "Administrator") {
            $all_sales_today = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $getDayClose->day_close)
            ->get();
        }else {
            $all_sales_today = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', '!=', "TRANSPORT")
            ->where('user_id', auth()->user()->id)
            ->whereDate('created_at', $getDayClose->day_close)
            ->get();
        }

        return view('inc.print-transactions', [
            'all_sales' => $all_sales_today
        ]);
    }

}
