<?php

namespace App\Http\Controllers;

use App\Models\HousePerson;
use Illuminate\Http\Request;

class HousePersonController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = new HousePerson;
        $data->name = $request -> name;
        $data->phone = $request -> phone;
        $data->description = $request -> description;
        $data -> save();
        return 123;
    }


    public function summary($id)
    {
        $userInvoices = \DB::table('on_houses')->where('person_id', $id)->pluck('order_number');

        $invoices = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->whereIn('invoice_number', $userInvoices)
        ->get();


        $orders = \DB::table('orders')
            ->whereIn('order_id', $userInvoices)
            ->get();

        $ordersRevenue = \DB::table('invoices')
            ->where('invoice_status', 2)
            ->where('invoice_category', '!=', "TRANSPORT")
            ->whereIn('invoice_number', $userInvoices)
            ->sum('invoice_total_price');

        $person = \DB::table('house_people')->where('id',$id)->first();

        return view('users-house-report', [
            'invoices' => $invoices,
            'ordering' => $orders,
            'ordercount' =>  $orders->count(),
            'invoicecount' =>  $invoices->count(),
            'ordersRevenue' => $ordersRevenue,
            'person' => $person
        ]);

        
    }
    /**
     * Display the specified resource.
     *
     * @param  \App\Models\HousePerson  $housePerson
     * @return \Illuminate\Http\Response
     */
    public function show(HousePerson $housePerson)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\HousePerson  $housePerson
     * @return \Illuminate\Http\Response
     */
    public function edit(HousePerson $housePerson)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\HousePerson  $housePerson
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, HousePerson $housePerson)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\HousePerson  $housePerson
     * @return \Illuminate\Http\Response
     */
    public function destroy(HousePerson $housePerson)
    {
        //
    }
}
