<?php

namespace App\Http\Controllers;

use App\Models\MonthTarget;
use Illuminate\Http\Request;

class MonthTargetController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('month-target');
    }

    public function ActivateTarget()
    {
        $checkTarget = \DB::table('settings')->first();
        if ($checkTarget->sales_target == 0) {
            \DB::table('settings')->update([
                'sales_target'=>1
            ]);
        }else {
            \DB::table('settings')->update([
                'sales_target'=> 0
            ]);
        }

    }

    public function store(Request $request)
    {   
        // Get days in Month
        $days=cal_days_in_month(CAL_GREGORIAN,explode(' - ', $request -> target_month)[0],explode(' - ', $request -> target_month)[1]);
        
        $data = new MonthTarget;
        $data -> target_month =  explode(' - ', $request -> target_month)[0];
        $data -> target_branch = $request -> branch_name;
        $data -> target_amount = $request -> target_amount;
        $data -> target_month_days =  $days;
        $data -> save();
        
        return response([
            'status' => 200,
            "Message" => "Saved Successfully"
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\MonthTarget  $monthTarget
     * @return \Illuminate\Http\Response
     */
    public function show(MonthTarget $monthTarget)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\MonthTarget  $monthTarget
     * @return \Illuminate\Http\Response
     */
    public function edit(MonthTarget $monthTarget)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\MonthTarget  $monthTarget
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, MonthTarget $monthTarget)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\MonthTarget  $monthTarget
     * @return \Illuminate\Http\Response
     */
    public function destroy(MonthTarget $monthTarget)
    {
        $monthTarget->delete();
        return response([
            'status' => 200,
            'Message' => "Deleted Successfully"
        ]);
    }
}
