<?php

namespace App\Http\Controllers;

use App\Models\OnHouse;
use Illuminate\Http\Request;

class OnHouseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        return $this->middleware('auth');
    }
    
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $getDayClose = \DB::table('close_days')->first(); // getDay close
        $time = date('H:i:s'); // current time 

        $response = explode('-', $request->name);
        $person = \DB::table('house_people')->where('id', $response[1])->first();
        
        // GENERATE INVOICE NUMBER
        if (empty(session()->get('invoice_number'))) {
            $generateInvoice = substr(auth()->user()->branch, 0,3) . rand(5034580,10034580)+rand(5034580,10034580) . date("Yd") . date('Hi');
            session()->put('invoice_number', $generateInvoice);
        }

        $data = new OnHouse;
        $data->user_id = auth()->user()->id;
        $data->person_id = $person ->id;
        $data->name = $response[0];
        $data->order_number = session()->get('invoice_number');
        $data ->phone = $person -> phone;
        $data-> comment = $request -> comment;
        $data-> created_at = date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time"));
        $data->save();
        return 123;
        
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\OnHouse  $onHouse
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
        $getDayClose = \DB::table('close_days')->first(); // getDay close
        return view('on-the-house', [
            'onhouse' => OnHouse::whereDate('created_at', $getDayClose->day_close)->get()
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\OnHouse  $onHouse
     * @return \Illuminate\Http\Response
     */
    public function edit(OnHouse $onHouse)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\OnHouse  $onHouse
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, OnHouse $onHouse)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\OnHouse  $onHouse
     * @return \Illuminate\Http\Response
     */
    public function destroy(OnHouse $onHouse)
    {
        //
    }
}
